/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.NumberUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps04001.Ps04001ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps04001.Ps04001RspDtlDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps04001.Ps04001RspDto;
import cn.com.yusys.yusp.pay.position.domain.entity.PsBranchAccountDo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBankaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBankaccbookVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBranchadmVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS04001Service {
    private static final Logger log = LoggerFactory.getLogger(PS04001Service.class);
    @Autowired
    private PsDBankaccbookRepo psDBankaccbookRepo;
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;

    public YuinResultDto<Ps04001RspDto> ps04001(YuinRequestDto<Ps04001ReqDto> yuinRequestDto) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(head);
        Ps04001RspDto rspBodyDto = new Ps04001RspDto();
        YuinRequestHead header = yuinRequestDto.getSysHead();
        Ps04001ReqDto requestDtoBody = (Ps04001ReqDto)yuinRequestDto.getBody();
        String headerBrNo = header.getBrno();
        if (!this.psDBranchadmRepo.isBranchCanOperate(headerBrNo)) {
            throw new BizBaseException(PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg(), new Object[0]);
        }
        String brType = requestDtoBody.getBrType();
        String brNo = requestDtoBody.getBrNo();
        PsBranchAccountDo branchAccountDo = new PsBranchAccountDo();
        branchAccountDo.checkBrTypeValue(brType);
        boolean isTopBranch = this.psDBranchadmRepo.isTopBranch(headerBrNo);
        List<String> queryBrNoList = new ArrayList<String>();
        if ("01".equals(brType)) {
            queryBrNoList.add(headerBrNo);
        } else if ("02".equals(brType)) {
            if (isTopBranch) {
                queryBrNoList = this.psDBranchadmRepo.getBranchNoList93();
            }
        } else if ("03".equals(brType)) {
            if (StringUtils.isBlank((String)brNo)) {
                throw new BizBaseException(PSErrorMsg.PS000008.getErrCode(), "\u673a\u6784\u7c7b\u522b" + PSErrorMsg.PS000008.getErrMsg(), new Object[0]);
            }
            if (isTopBranch) {
                queryBrNoList.add(brNo);
            }
        }
        List bankAccBookVoList = new ArrayList();
        if (CollectionUtils.nonEmpty(queryBrNoList)) {
            ArrayList<String> queryFlagList = new ArrayList<String>();
            if (isTopBranch) {
                queryFlagList.add("01");
                queryFlagList.add("03");
                bankAccBookVoList = this.psDBankaccbookRepo.getAccBookListByBrNoList(queryBrNoList, queryFlagList);
            } else {
                queryFlagList.add("02");
                queryFlagList.add("03");
                bankAccBookVoList = this.psDBankaccbookRepo.getAccBookListByBrNoList(queryBrNoList, queryFlagList);
            }
        }
        List<Object> brNoList = new ArrayList();
        brNoList = queryBrNoList;
        List branchAdmVoList = new ArrayList();
        long totalSize = 0L;
        if (CollectionUtils.nonEmpty(brNoList)) {
            Long pageNum = Long.parseLong(String.valueOf(header.getPageNum()));
            Long pageSize = Long.parseLong(String.valueOf(header.getPageSize()));
            IPage queryResultObj = this.psDBranchadmRepo.getBranchList(pageNum, pageSize, brNoList);
            branchAdmVoList = queryResultObj.getRecords();
            totalSize = queryResultObj.getTotal();
        }
        ArrayList<Ps04001RspDtlDto> list = new ArrayList<Ps04001RspDtlDto>();
        Ps04001RspDtlDto dtlDto = null;
        for (PsDBranchadmVo branchVo : branchAdmVoList) {
            dtlDto = new Ps04001RspDtlDto();
            dtlDto.setBrNo(branchVo.getBrno());
            dtlDto.setBrName(branchVo.getBrname());
            BigDecimal posAmt = new BigDecimal("0");
            BigDecimal provAmt = new BigDecimal("0");
            BigDecimal cashAmt = new BigDecimal("0");
            BigDecimal yestodayAmt = new BigDecimal("0");
            for (PsDBankaccbookVo bankAccBookVo : bankAccBookVoList) {
                if (!branchVo.getBrno().equals(bankAccBookVo.getClearbrno())) continue;
                if ("01".equals(bankAccBookVo.getAcctype())) {
                    dtlDto.setPosAccAmt(NumberUtils.nullDefaultZero((Number)bankAccBookVo.getTodaybal()).toString());
                    if (bankAccBookVo.getTodaybal() == null) continue;
                    posAmt = bankAccBookVo.getTodaybal();
                    continue;
                }
                if ("02".equals(bankAccBookVo.getAcctype())) {
                    dtlDto.setProvAmt(NumberUtils.nullDefaultZero((Number)bankAccBookVo.getTodaybal()).toString());
                    if (bankAccBookVo.getTodaybal() == null) continue;
                    provAmt = bankAccBookVo.getTodaybal();
                    continue;
                }
                if ("03".equals(bankAccBookVo.getAcctype())) {
                    dtlDto.setInteCurAccAmt(NumberUtils.nullDefaultZero((Number)bankAccBookVo.getTodaybal()).toString());
                    continue;
                }
                if ("04".equals(bankAccBookVo.getAcctype())) {
                    if (bankAccBookVo.getTodaybal() == null) continue;
                    cashAmt = bankAccBookVo.getTodaybal();
                    continue;
                }
                if (!"05".equals(bankAccBookVo.getAcctype()) || bankAccBookVo.getLastbal() == null) continue;
                yestodayAmt = bankAccBookVo.getLastbal();
            }
            if (yestodayAmt.compareTo(new BigDecimal("0")) == 1) {
                BigDecimal sum = posAmt.add(cashAmt).add(provAmt);
                BigDecimal rate = NumberUtils.divide((BigDecimal)sum, (BigDecimal)yestodayAmt);
                rate = NumberUtils.multiply((BigDecimal[])new BigDecimal[]{rate, BigDecimal.TEN, BigDecimal.TEN});
                dtlDto.setProvRate(NumberUtils.round((BigDecimal)rate, (int)2).toString());
            } else {
                dtlDto.setProvRate("--");
            }
            if (yestodayAmt.compareTo(new BigDecimal("0")) == 1) {
                BigDecimal rate = NumberUtils.divide((BigDecimal)posAmt, (BigDecimal)yestodayAmt);
                rate = NumberUtils.multiply((BigDecimal[])new BigDecimal[]{rate, BigDecimal.TEN, BigDecimal.TEN});
                dtlDto.setStorageRate(NumberUtils.round((BigDecimal)rate, (int)2).toString());
            } else {
                dtlDto.setStorageRate("--");
            }
            list.add(dtlDto);
        }
        head.setTotalSize(totalSize);
        rspBodyDto.setList(list);
        rspBodyDto.setStatus("1");
        rspBodyDto.setErrcode(head.getResponseCode());
        rspBodyDto.setErrmsg(head.getResponseMsg());
        yuinResultDto.setBody((Object)rspBodyDto);
        return yuinResultDto;
    }
}

