/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps03005.Ps03005DtelRspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03005.Ps03005ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03005.Ps03005RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS03001Service;
import cn.com.yusys.yusp.pay.position.domain.repo.PsBCtyspecbookRepo;
import cn.com.yusys.yusp.pay.position.domain.service.PsDBranchadmDomainService;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsBCtyspecbookVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS03005Service {
    @Autowired
    private PsBCtyspecbookRepo ps03005Repo;
    @Autowired
    private PsDBranchadmDomainService psDBranchadmDomainService;
    private static final Logger log = LoggerFactory.getLogger(PS03001Service.class);

    public YuinResultDto ps03005(YuinRequestDto<Ps03005ReqDto> yuinRequestDto) {
        Ps03005ReqDto ps03005ReqDto = (Ps03005ReqDto)yuinRequestDto.getBody();
        String funcType = ps03005ReqDto.getFunctype();
        String tellerNo = yuinRequestDto.getSysHead().getTellerno();
        String brNo = yuinRequestDto.getSysHead().getBrno();
        YuinRequestDto request = new YuinRequestDto();
        request.setSysHead(yuinRequestDto.getSysHead());
        request.setBody(BeanUtils.beanCopy((Object)yuinRequestDto.getBody(), PsBCtyspecbookVo.class));
        YuinResultDto resultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        resultDto.setHead(head);
        try {
            switch (funcType) {
                case "1": {
                    resultDto.setBody((Object)this.doInset((PsBCtyspecbookVo)request.getBody(), tellerNo, brNo));
                    break;
                }
                case "2": {
                    resultDto.setBody((Object)this.doUpdate((PsBCtyspecbookVo)request.getBody()));
                    break;
                }
                case "3": {
                    resultDto.setBody((Object)this.doQuery((PsBCtyspecbookVo)request.getBody(), brNo));
                    break;
                }
                case "4": {
                    resultDto.setBody((Object)this.doDelete((PsBCtyspecbookVo)request.getBody()));
                    break;
                }
                default: {
                    resultDto.setBody((Object)new Ps03005RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000002.getErrMsg()));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.toString());
            resultDto.setBody((Object)new Ps03005RspDto("0", PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg()));
        }
        if ("3".equals(funcType)) {
            head.setTotalSize((long)((Ps03005RspDto)resultDto.getBody()).getList().size());
        }
        if (!"1".equals(((Ps03005RspDto)resultDto.getBody()).getStatus())) {
            head.setResponseCode(((Ps03005RspDto)resultDto.getBody()).getErrcode());
            head.setResponseMsg(((Ps03005RspDto)resultDto.getBody()).getErrmsg());
        }
        return resultDto;
    }

    private Ps03005RspDto doInset(PsBCtyspecbookVo dataVo, String tellerNo, String brNo) {
        dataVo.setBrno(brNo);
        dataVo.setWorkdate(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT));
        dataVo.setAppid("PS");
        dataVo.setSysid("PS");
        this.ps03005Repo.save(dataVo);
        return new Ps03005RspDto("1", "", "");
    }

    private Ps03005RspDto doUpdate(PsBCtyspecbookVo dataVo) {
        this.ps03005Repo.updateById(dataVo);
        return new Ps03005RspDto("1", "", "");
    }

    private Ps03005RspDto doQuery(PsBCtyspecbookVo dataVo, String brno) {
        if (!brno.equals(dataVo.getBrno()) && !this.psDBranchadmDomainService.juageSuperBrno(brno, dataVo.getBrno()).booleanValue()) {
            return new Ps03005RspDto("0", PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg());
        }
        PsBCtyspecbookVo psVo = this.ps03005Repo.doQuery(dataVo);
        Ps03005DtelRspDto ps03005Dto = (Ps03005DtelRspDto)BeanUtils.beanCopy((Object)psVo, Ps03005DtelRspDto.class);
        ArrayList<Ps03005DtelRspDto> list = new ArrayList<Ps03005DtelRspDto>();
        if (ps03005Dto != null) {
            list.add(ps03005Dto);
        }
        Ps03005RspDto rspDto = new Ps03005RspDto();
        rspDto.setStatus("1");
        rspDto.setList(list);
        return rspDto;
    }

    private Ps03005RspDto doDelete(PsBCtyspecbookVo dataVo) {
        this.ps03005Repo.delete(dataVo);
        return new Ps03005RspDto("1", "", "");
    }
}

