/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps01001.Ps01001DetRspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps01001.Ps01001ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps01001.Ps01001RspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps02001.Ps02001RspDto;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBankaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBankaccbookVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS01001Service {
    private static final Logger log = LoggerFactory.getLogger(PS01001Service.class);
    @Autowired
    private PsDBankaccbookRepo psDBankaccbookRepo;
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;

    public YuinResultDto<Ps01001RspDto> PsDBankaccbookRManagement(YuinRequestDto<Ps01001ReqDto> yuinRequestDto) {
        YuinRequestHead header = yuinRequestDto.getSysHead();
        Ps01001ReqDto ps01001ReqDto = (Ps01001ReqDto)Optional.ofNullable(yuinRequestDto.getBody()).orElse(new Ps01001ReqDto());
        ps01001ReqDto.setAppid(header.getAppid());
        ps01001ReqDto.setSysid(header.getSysid());
        PsDBankaccbookVo psDBankaccbookVo = (PsDBankaccbookVo)BeanUtils.beanCopy((Object)ps01001ReqDto, PsDBankaccbookVo.class);
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        try {
            switch (StringUtils.isBlank((CharSequence)psDBankaccbookVo.getOpertype()) ? "9999" : psDBankaccbookVo.getOpertype()) {
                case "1": {
                    yuinResultDto.setBody((Object)this.doInsert(psDBankaccbookVo, header));
                    break;
                }
                case "2": {
                    yuinResultDto.setBody((Object)this.doUpdate(psDBankaccbookVo, header));
                    break;
                }
                case "3": {
                    yuinResultDto.setBody((Object)this.doDelete(psDBankaccbookVo));
                    break;
                }
                case "4": {
                    psDBankaccbookVo.setPage(Long.valueOf(header.getPageNum() == null ? 1L : (long)header.getPageNum().intValue()));
                    psDBankaccbookVo.setSize(Long.valueOf(header.getPageSize() == null ? 10L : (long)header.getPageSize().intValue()));
                    yuinResultDto.setBody((Object)this.doQuery(psDBankaccbookVo, head, header));
                    break;
                }
                default: {
                    yuinResultDto.setBody((Object)new Ps02001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000002.getErrMsg()));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.toString());
            head.setResponseCode(PSErrorMsg.PS000001.getErrCode());
            head.setResponseMsg(PSErrorMsg.PS000001.getErrMsg());
            head.setStatus("0");
            yuinResultDto.setBody((Object)new Ps02001RspDto("0", PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg()));
        }
        head.setStatus("1");
        yuinResultDto.setHead(head);
        return yuinResultDto;
    }

    private Ps01001RspDto doQuery(PsDBankaccbookVo psDBankaccbookVo, YuinResultHead head, YuinRequestHead header) {
        ArrayList<String> brnoList = new ArrayList<String>(13);
        if ("01".equals(psDBankaccbookVo.getBranchquerytype())) {
            brnoList.add(header.getBrno());
        }
        if ("02".equals(psDBankaccbookVo.getBranchquerytype())) {
            brnoList.addAll(this.psDBranchadmRepo.getBrnoTreeInfoByBrno(header.getBrno()));
        }
        if ("03".equals(psDBankaccbookVo.getBranchquerytype())) {
            brnoList.add(psDBankaccbookVo.getQueryorgid());
        }
        psDBankaccbookVo.setBrnoList(brnoList);
        IPage rspDtoIPage = this.psDBankaccbookRepo.doQuery(psDBankaccbookVo).convert(vo -> (Ps01001DetRspDto)BeanUtils.beanCopy((Object)vo, Ps01001DetRspDto.class));
        head.setTotalSize(rspDtoIPage.getTotal());
        Ps01001RspDto ps01001RspDto = new Ps01001RspDto("1", "", "");
        ps01001RspDto.setList(rspDtoIPage.getRecords());
        return ps01001RspDto;
    }

    private Ps01001RspDto doDelete(PsDBankaccbookVo psDBankaccbookVo) {
        this.psDBankaccbookRepo.doDelete(psDBankaccbookVo);
        Ps01001RspDto ps01001RspDto = new Ps01001RspDto("1", "", "");
        return ps01001RspDto;
    }

    private Ps01001RspDto doUpdate(PsDBankaccbookVo psDBankaccbookVo, YuinRequestHead header) {
        psDBankaccbookVo.setModifier(header.getChnlcode());
        psDBankaccbookVo.setModifytime(DateUtils.getCurrDateTimeStr());
        this.psDBankaccbookRepo.doUpdate(psDBankaccbookVo);
        Ps01001RspDto ps01001RspDto = new Ps01001RspDto("1", "", "");
        return ps01001RspDto;
    }

    private Ps01001RspDto doInsert(PsDBankaccbookVo psDBankaccbookVo, YuinRequestHead header) {
        psDBankaccbookVo.setCreator(header.getChnlcode());
        psDBankaccbookVo.setCreatetime(DateUtils.getCurrDateTimeStr());
        this.psDBankaccbookRepo.doInsert(psDBankaccbookVo);
        Ps01001RspDto ps01001RspDto = new Ps01001RspDto("1", "", "");
        return ps01001RspDto;
    }
}

