/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps02001.Ps02001RspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03007.Ps03007ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03007.Ps03007RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS03007Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS03007"})
@RestController
public class PS03007Resource {
    @Autowired
    private PS03007Service pS03007Service;

    @ApiOperation(value="\u652f\u4ed8\u5b9e\u65f6\u6d41\u6c34\u83b7\u53d6\uff08\u81ea\u52a8\u6838\u9500\uff09")
    @PostMapping(value={"/api/payment/ps/ps03007"})
    public YuinResultDto<Ps03007RspDto> ps03007(@RequestBody @Validated YuinRequestDto<Ps03007ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS03007Service.ps03007(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps03007ReqDto> yuinRequestDto) {
        Ps03007ReqDto ps03007ReqDto = (Ps03007ReqDto)yuinRequestDto.getBody();
        try {
            ValidatorUtils.validate((Object)ps03007ReqDto, (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)ps03007ReqDto.getCorppway())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)ps03007ReqDto.getWorkdate())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)ps03007ReqDto.getWorkseqid())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
    }

    private YuinResultDto handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        Ps02001RspDto rspDto = new Ps02001RspDto("0", errCode, errMsg);
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        yuinResultDto.setHead(head);
        yuinResultDto.setBody((Object)rspDto);
        return yuinResultDto;
    }
}

