/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps02001.Ps02001RspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03005.Ps03005DtelRspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03005.Ps03005ReqDto;
import cn.com.yusys.yusp.pay.position.application.service.PS03005Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS03005"})
@RestController
public class PS03005Resource {
    @Autowired
    private PS03005Service pS03005Service;

    @ApiOperation(value="\u65d7\u53bf\u8054\u793e\u5321\u7b97\u4fe1\u606f\u7ef4\u62a4")
    @PostMapping(value={"/api/payment/ps/ps03005"})
    public YuinResultDto<Ps03005DtelRspDto> ps03005(@RequestBody @Validated YuinRequestDto<Ps03005ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS03005Service.ps03005(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps03005ReqDto> yuinRequestDto) {
        Ps03005ReqDto ps03005ReqDto = (Ps03005ReqDto)yuinRequestDto.getBody();
        try {
            ValidatorUtils.validate((Object)ps03005ReqDto, (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)((Ps03005ReqDto)yuinRequestDto.getBody()).getFunctype())) {
            throw new BizBaseException(PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000002.getErrMsg(), new Object[0]);
        }
        if ("3".equals(((Ps03005ReqDto)yuinRequestDto.getBody()).getFunctype()) && StringUtils.isBlank((CharSequence)((Ps03005ReqDto)yuinRequestDto.getBody()).getBrno())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)((Ps03005ReqDto)yuinRequestDto.getBody()).getWorkdate())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
    }

    private YuinResultDto handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        Ps02001RspDto rspDto = new Ps02001RspDto("0", errCode, errMsg);
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        yuinResultDto.setHead(head);
        yuinResultDto.setBody((Object)rspDto);
        return yuinResultDto;
    }
}

