/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps01001.Ps01001ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps01001.Ps01001RspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps01002.Ps01002ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps01002.Ps01002RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS01001Service;
import cn.com.yusys.yusp.pay.position.application.service.PS01002Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS01001"})
@RestController
public class PS01001Resource {
    @Autowired
    private PS01001Service pS01001Service;
    @Autowired
    private PS01002Service ps01002Service;

    @ApiOperation(value="\u884c\u5185\u5934\u5bf8\u7ba1\u7406")
    @PostMapping(value={"/api/payment/ps/ps01001"})
    public YuinResultDto PsDBankaccbookRManagement(@RequestBody @Validated YuinRequestDto<Ps01001ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS01001Service.PsDBankaccbookRManagement(yuinRequestDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private YuinResultDto handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        Ps01001RspDto rspDto = new Ps01001RspDto("0", errCode, errMsg);
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        yuinResultDto.setHead(head);
        yuinResultDto.setBody((Object)rspDto);
        return yuinResultDto;
    }

    private void validateRequestDto(YuinRequestDto<Ps01001ReqDto> yuinRequestDto) {
        Ps01001ReqDto ps01001ReqDto = (Ps01001ReqDto)yuinRequestDto.getBody();
        try {
            ValidatorUtils.validate((Object)ps01001ReqDto, (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        if (!StringUtils.containsAny((CharSequence)ps01001ReqDto.getOpertype(), (CharSequence[])new CharSequence[]{"1", "2", "3", "4"})) {
            throw new BizBaseException(PSErrorMsg.PS000003.getErrCode(), PSErrorMsg.PS000003.getErrMsg(), new Object[0]);
        }
        if (StringUtils.containsAny((CharSequence)ps01001ReqDto.getOpertype(), (CharSequence[])new CharSequence[]{"1", "2", "3"}) && StringUtils.isBlank((CharSequence)ps01001ReqDto.getClearbrno())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
        if (StringUtils.containsAny((CharSequence)ps01001ReqDto.getOpertype(), (CharSequence[])new CharSequence[]{"1", "2"}) && StringUtils.isBlank((CharSequence)ps01001ReqDto.getPosorgtype())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
        if (StringUtils.containsAny((CharSequence)ps01001ReqDto.getOpertype(), (CharSequence[])new CharSequence[]{"1", "2", "3"}) && StringUtils.isBlank((CharSequence)ps01001ReqDto.getPostaccno())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
        if (StringUtils.containsAny((CharSequence)ps01001ReqDto.getOpertype(), (CharSequence[])new CharSequence[]{"1", "2"}) && StringUtils.isBlank((CharSequence)ps01001ReqDto.getAcctype())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
        if (StringUtils.containsAny((CharSequence)ps01001ReqDto.getOpertype(), (CharSequence[])new CharSequence[]{"1", "2"}) && StringUtils.isBlank((CharSequence)ps01001ReqDto.getStatus())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
    }

    @ApiOperation(value="\u5934\u5bf8\u8d26\u53f7\u9a8c\u8bc1\u529f\u80fd")
    @PostMapping(value={"/api/payment/ps/ps01002"})
    public YuinResultDto<Ps01002RspDto> posvalid(@RequestBody @Validated YuinRequestDto<Ps01002ReqDto> yuinRequestDto) {
        try {
            this.validatePs01002RspDtoRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.ps01002Service.posvalid(yuinRequestDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(PSErrorMsg.PS010001.getErrCode(), PSErrorMsg.PS010001.getErrMsg());
        }
    }

    private void validatePs01002RspDtoRequestDto(YuinRequestDto<Ps01002ReqDto> yuinRequestDto) {
        try {
            ValidatorUtils.validate((Object)yuinRequestDto.getBody(), (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
    }
}

