/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.pay.position.application.dto.ps09002.Ps09002ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps09002.Ps09002RspDtlDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps09002.Ps09002RspDto;
import cn.com.yusys.yusp.pay.position.domain.entity.PsBranchAccountDo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMPaytranjnlRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMPaytranjnlQueryVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMPaytranjnlVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS09002Service {
    private static final Logger log = LoggerFactory.getLogger(PS09002Service.class);
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;
    @Autowired
    private PsMPaytranjnlRepo psMPaytranjnlRepo;

    public YuinResultDto<Ps09002RspDto> ps09002(YuinRequestDto<Ps09002ReqDto> yuinRequestDto) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinRequestHead header = yuinRequestDto.getSysHead();
        Ps09002ReqDto ps09002ReqDto = (Ps09002ReqDto)yuinRequestDto.getBody();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(head);
        String headerBrNo = header.getBrno();
        String brType = ps09002ReqDto.getBrType();
        String brNo = ps09002ReqDto.getBrNo();
        PsBranchAccountDo branchAccountDo = new PsBranchAccountDo();
        branchAccountDo.checkBrTypeValue(brType);
        List<String> queryBrNoList = new ArrayList<String>();
        if ("01".equals(brType)) {
            queryBrNoList.add(headerBrNo);
        } else if ("02".equals(brType)) {
            queryBrNoList = this.psDBranchadmRepo.getBrnoTreeInfoByBrno(headerBrNo);
        } else if ("03".equals(brType)) {
            if (StringUtils.isBlank((String)brNo)) {
                throw new BizBaseException(PSErrorMsg.PS000008.getErrCode(), "\u673a\u6784\u53f7" + PSErrorMsg.PS000008.getErrMsg(), new Object[0]);
            }
            queryBrNoList.add(brNo);
        }
        boolean isTopBranch = this.psDBranchadmRepo.isTopBranch(headerBrNo);
        if (isTopBranch) {
            PsMPaytranjnlQueryVo psMPaytranjnlQueryVo = new PsMPaytranjnlQueryVo();
            psMPaytranjnlQueryVo.setPage(Long.valueOf(Long.parseLong(String.valueOf(header.getPageNum()))));
            psMPaytranjnlQueryVo.setSize(Long.valueOf(Long.parseLong(String.valueOf(header.getPageSize()))));
            psMPaytranjnlQueryVo.setStartDate(ps09002ReqDto.getStartDate());
            psMPaytranjnlQueryVo.setEndDate(ps09002ReqDto.getEndDate());
            psMPaytranjnlQueryVo.setBrnoList(null);
            psMPaytranjnlQueryVo.setPredflag("0");
            IPage psMPaytranjnlVoIPage = this.psMPaytranjnlRepo.queryPageByBrno(psMPaytranjnlQueryVo);
            ArrayList<Ps09002RspDtlDto> result_list = new ArrayList<Ps09002RspDtlDto>();
            Ps09002RspDtlDto ps09002RspDtlDto = null;
            for (PsMPaytranjnlVo psMPaytranjnlVo : psMPaytranjnlVoIPage.getRecords()) {
                ps09002RspDtlDto = new Ps09002RspDtlDto();
                ps09002RspDtlDto.setBusiDate(psMPaytranjnlVo.getWorkdate());
                ps09002RspDtlDto.setBusiTime(psMPaytranjnlVo.getWorktime());
                ps09002RspDtlDto.setBrNo(psMPaytranjnlVo.getBrno());
                ps09002RspDtlDto.setAccNo(psMPaytranjnlVo.getPayeraccno());
                ps09002RspDtlDto.setAccName(psMPaytranjnlVo.getPayername());
                ps09002RspDtlDto.setAmt(psMPaytranjnlVo.getAmt().toString());
                ps09002RspDtlDto.setChnlName(psMPaytranjnlVo.getChnlcode());
                ps09002RspDtlDto.setPayChnlName(psMPaytranjnlVo.getCorppway());
                ps09002RspDtlDto.setPmtdrtName(psMPaytranjnlVo.getMbflag());
                result_list.add(ps09002RspDtlDto);
            }
            Ps09002RspDto ps09002RspDto = new Ps09002RspDto("1", head.getResponseCode(), head.getResponseMsg());
            head.setTotalSize(psMPaytranjnlVoIPage.getTotal());
            ps09002RspDto.setList(result_list);
            yuinResultDto.setBody((Object)ps09002RspDto);
        } else {
            PsMPaytranjnlQueryVo psMPaytranjnlQueryVo = new PsMPaytranjnlQueryVo();
            psMPaytranjnlQueryVo.setPage(Long.valueOf(Long.parseLong(String.valueOf(header.getPageNum()))));
            psMPaytranjnlQueryVo.setSize(Long.valueOf(Long.parseLong(String.valueOf(header.getPageSize()))));
            psMPaytranjnlQueryVo.setStartDate(ps09002ReqDto.getStartDate());
            psMPaytranjnlQueryVo.setEndDate(ps09002ReqDto.getEndDate());
            psMPaytranjnlQueryVo.setBrnoList(queryBrNoList);
            psMPaytranjnlQueryVo.setPredflag("0");
            IPage psMPaytranjnlVoIPage = this.psMPaytranjnlRepo.queryPageByBrno(psMPaytranjnlQueryVo);
            ArrayList<Ps09002RspDtlDto> result_list = new ArrayList<Ps09002RspDtlDto>();
            Ps09002RspDtlDto ps09002RspDtlDto = null;
            for (PsMPaytranjnlVo psMPaytranjnlVo : psMPaytranjnlVoIPage.getRecords()) {
                ps09002RspDtlDto = new Ps09002RspDtlDto();
                ps09002RspDtlDto.setBusiDate(psMPaytranjnlVo.getWorkdate());
                ps09002RspDtlDto.setBusiTime(psMPaytranjnlVo.getWorktime());
                ps09002RspDtlDto.setBrNo(psMPaytranjnlVo.getBrno());
                ps09002RspDtlDto.setAccNo(psMPaytranjnlVo.getPayeraccno());
                ps09002RspDtlDto.setAccName(psMPaytranjnlVo.getPayername());
                ps09002RspDtlDto.setAmt(psMPaytranjnlVo.getAmt().toString());
                ps09002RspDtlDto.setChnlName(psMPaytranjnlVo.getChnlcode());
                ps09002RspDtlDto.setPayChnlName(psMPaytranjnlVo.getCorppway());
                ps09002RspDtlDto.setPmtdrtName(psMPaytranjnlVo.getMbflag());
                result_list.add(ps09002RspDtlDto);
            }
            Ps09002RspDto ps09002RspDto = new Ps09002RspDto("1", head.getResponseCode(), head.getResponseMsg());
            head.setTotalSize(psMPaytranjnlVoIPage.getTotal());
            ps09002RspDto.setList(result_list);
            yuinResultDto.setBody((Object)ps09002RspDto);
        }
        return yuinResultDto;
    }
}

