/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.application.dto.Ps06003.Ps06003ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.Ps06003.Ps06003RspDto;
import cn.com.yusys.yusp.pay.position.application.dto.Ps06003.Ps06003RspListDto;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDMaillistRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDMaillistVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class PS06003Service {
    private static final Logger log = LoggerFactory.getLogger(PS06003Service.class);
    @Autowired
    private PsDMaillistRepo psDMaillistRepo;
    @Autowired
    RedisTemplate<String, String> redisTemplate;

    private Ps06003RspDto getRecvcode(String pre) {
        String code = "";
        PsDMaillistVo psDMaillistVo = new PsDMaillistVo();
        psDMaillistVo.setPage(Long.valueOf(1L));
        psDMaillistVo.setSize(Long.valueOf(1L));
        List listVo = this.psDMaillistRepo.doQueryList(psDMaillistVo);
        if (CollectionUtils.isEmpty((Collection)listVo)) {
            code = pre + "000001";
        } else {
            String srcCode = ((PsDMaillistVo)listVo.get(0)).getRecvcode();
            String temp = srcCode.substring(pre.length());
            int i = Integer.parseInt(temp) + 1;
            code = pre + String.format("%06d", i);
        }
        Ps06003RspDto ps06003RspDto = new Ps06003RspDto("1", "", "");
        ps06003RspDto.setRecvcode(code);
        return ps06003RspDto;
    }

    public YuinResultDto<Ps06003RspDto> mailHandle(YuinRequestDto<Ps06003ReqDto> yuinRequestDto) {
        YuinRequestDto request = new YuinRequestDto();
        request.setSysHead(yuinRequestDto.getSysHead());
        request.setBody(BeanUtils.beanCopy((Object)yuinRequestDto.getBody(), PsDMaillistVo.class));
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead resultHead = new YuinResultHead();
        resultHead.setResponseCode("200");
        resultHead.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(resultHead);
        PsDMaillistVo psDMaillistVo = (PsDMaillistVo)Optional.ofNullable(request.getBody()).orElse(new PsDMaillistVo());
        psDMaillistVo.setPage(Long.valueOf(request.getSysHead().getPageNum().intValue()));
        psDMaillistVo.setSize(Long.valueOf(request.getSysHead().getPageSize().intValue()));
        psDMaillistVo.setAppid(request.getSysHead().getAppid());
        psDMaillistVo.setSysid(request.getSysHead().getSysid());
        try {
            switch (StringUtils.isBlank((CharSequence)psDMaillistVo.getFuncType()) ? "9999" : psDMaillistVo.getFuncType()) {
                case "1": {
                    yuinResultDto.setBody((Object)this.doInsert(psDMaillistVo, request.getSysHead()));
                    break;
                }
                case "2": {
                    yuinResultDto.setBody((Object)this.doUpdate(psDMaillistVo, request.getSysHead()));
                    break;
                }
                case "3": {
                    yuinResultDto.setBody((Object)this.doDelete(psDMaillistVo));
                    break;
                }
                case "4": {
                    yuinResultDto.setBody((Object)this.doQuery(psDMaillistVo, resultHead));
                    break;
                }
                case "5": {
                    yuinResultDto.setBody((Object)this.getRecvcode("RECV"));
                    break;
                }
                default: {
                    yuinResultDto.setBody((Object)new Ps06003RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000002.getErrMsg()));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.toString());
            yuinResultDto.setBody((Object)new Ps06003RspDto("0", PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg()));
        }
        return yuinResultDto;
    }

    private Ps06003RspDto doQuery(PsDMaillistVo psDMaillistVo, YuinResultHead resultHead) {
        IPage rspDtoIPage = this.psDMaillistRepo.doQuery(psDMaillistVo).convert(vo -> (Ps06003RspListDto)BeanUtils.beanCopy((Object)vo, Ps06003RspListDto.class));
        resultHead.setTotalSize(rspDtoIPage.getTotal());
        Ps06003RspDto ps06003RspDto = new Ps06003RspDto("1", "", "");
        ps06003RspDto.setList(rspDtoIPage.getRecords());
        return ps06003RspDto;
    }

    private Ps06003RspDto doDelete(PsDMaillistVo psDMaillistVo) {
        if (StringUtils.isBlank((CharSequence)psDMaillistVo.getRecvcode())) {
            return new Ps06003RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11\u5220\u9664\u4e3b\u952e:msgcode-\u6a21\u677f\u7f16\u53f7");
        }
        this.psDMaillistRepo.doDelete(psDMaillistVo);
        return new Ps06003RspDto("1", "", "");
    }

    private Ps06003RspDto doUpdate(PsDMaillistVo psDMaillistVo, YuinRequestHead requestHead) {
        if (StringUtils.isBlank((CharSequence)psDMaillistVo.getRecvcode())) {
            return new Ps06003RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11\u5220\u9664\u4e3b\u952e:recvcode-\u77ed\u4fe1\u63a5\u6536\u4eba\u7f16\u53f7");
        }
        psDMaillistVo.setModifytime(DateUtils.getCurrDateTimeStr());
        psDMaillistVo.setModifier(requestHead.getTellerno());
        this.psDMaillistRepo.doUpdate(psDMaillistVo);
        return new Ps06003RspDto("1", "", "");
    }

    private Ps06003RspDto doInsert(PsDMaillistVo psDMaillistVo, YuinRequestHead requestHead) {
        if (StringUtils.isBlank((CharSequence)psDMaillistVo.getRecvcode())) {
            return new Ps06003RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11\u5220\u9664\u4e3b\u952e:recvcode-\u77ed\u4fe1\u63a5\u6536\u4eba\u7f16\u53f7");
        }
        String cacheVerificationCode = (String)this.redisTemplate.opsForValue().get((Object)("PS06003" + psDMaillistVo.getLinkmobile()));
        if (StringUtils.isBlank((CharSequence)cacheVerificationCode)) {
            return new Ps06003RspDto("0", PSErrorMsg.PS060002.getErrCode(), PSErrorMsg.PS060002.getErrMsg());
        }
        if (!cacheVerificationCode.equals(psDMaillistVo.getVerificationCode())) {
            return new Ps06003RspDto("0", PSErrorMsg.PS060003.getErrCode(), PSErrorMsg.PS060003.getErrMsg());
        }
        psDMaillistVo.setCreatetime(DateUtils.getCurrDateTimeStr());
        psDMaillistVo.setCreator(requestHead.getTellerno());
        this.psDMaillistRepo.doInsert(psDMaillistVo);
        return new Ps06003RspDto("1", "", "");
    }
}

