/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.NumberUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps05001.Ps05001ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps05001.Ps05001RspDtlDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps05001.Ps05001RspDto;
import cn.com.yusys.yusp.pay.position.domain.repo.PsBCtyspecbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsBPostpredbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBankaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDCorpaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMPaytranjnlRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMPostcaljnlRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMWrtoffinlRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsBCtyspecbookVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBankaccbookVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS05001Service {
    private static final Logger log = LoggerFactory.getLogger(PS05001Service.class);
    @Autowired
    private PsDBankaccbookRepo psDBankaccbookRepo;
    @Autowired
    private PsDCorpaccbookRepo psDCorpaccbookRepo;
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;
    @Autowired
    private PsMPostcaljnlRepo psMPostcaljnlRepo;
    @Autowired
    private PsMPaytranjnlRepo psMPaytranjnlRepo;
    @Autowired
    private PsBPostpredbookRepo psBPostpredbookRepo;
    @Autowired
    private PsMWrtoffinlRepo psMWrtoffinlRepo;
    @Autowired
    private PsBCtyspecbookRepo psBCtyspecbookRepo;

    public YuinResultDto<Ps05001RspDto> ps05001(YuinRequestDto<Ps05001ReqDto> yuinRequestDto) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(head);
        Ps05001RspDto rspBodyDto = new Ps05001RspDto();
        YuinRequestHead header = yuinRequestDto.getSysHead();
        String headerBrNo = header.getBrno();
        if (!this.psDBranchadmRepo.isBranchCanOperate(headerBrNo)) {
            throw new BizBaseException(PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg(), new Object[0]);
        }
        Ps05001ReqDto requestDtoBody = (Ps05001ReqDto)yuinRequestDto.getBody();
        String predDate = requestDtoBody.getPredDate();
        boolean isTopBranch = this.psDBranchadmRepo.isTopBranch(headerBrNo);
        String currentDate = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
        ArrayList<Ps05001RspDtlDto> list = new ArrayList<Ps05001RspDtlDto>();
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)currentDate, (String)predDate)) {
            if (isTopBranch) {
                BigDecimal yesterdayAmt = this.psDCorpaccbookRepo.getCorpAccYesterdayBalSum();
                BigDecimal predInflowAmt = this.psBPostpredbookRepo.getAllBranchPredInflowAmtSum(predDate);
                BigDecimal predOutflowAmt = this.psBPostpredbookRepo.getAllBranchPredOutflowAmtSum(predDate);
                BigDecimal predAmt = yesterdayAmt.add(predInflowAmt);
                predAmt = NumberUtils.sub((BigDecimal[])new BigDecimal[]{predAmt, predOutflowAmt});
                BigDecimal pureInflowAmt = NumberUtils.sub((BigDecimal[])new BigDecimal[]{predInflowAmt, predOutflowAmt});
                Ps05001RspDtlDto dtlDto = new Ps05001RspDtlDto();
                dtlDto.setCrAmt(NumberUtils.nullDefaultZero((Number)predInflowAmt).toString());
                dtlDto.setDrAmt(NumberUtils.nullDefaultZero((Number)predOutflowAmt).toString());
                dtlDto.setNettingAmt(NumberUtils.nullDefaultZero((Number)pureInflowAmt).toString());
                dtlDto.setPosAccAmt(NumberUtils.nullDefaultZero((Number)predAmt).toString());
                dtlDto.setPredDate(predDate);
                list.add(dtlDto);
            } else {
                BigDecimal predInflowAmt = this.psBPostpredbookRepo.getBranchPredInflowAmtSum(headerBrNo, predDate);
                BigDecimal predOutflowAmt = this.psBPostpredbookRepo.getBranchPredOutflowAmtSum(headerBrNo, predDate);
                BigDecimal predAmt = NumberUtils.sub((BigDecimal[])new BigDecimal[]{predInflowAmt, predOutflowAmt});
                BigDecimal pureInflowAmt = NumberUtils.sub((BigDecimal[])new BigDecimal[]{predInflowAmt, predOutflowAmt});
                Ps05001RspDtlDto dtlDto = new Ps05001RspDtlDto();
                dtlDto.setCrAmt(NumberUtils.nullDefaultZero((Number)predInflowAmt).toString());
                dtlDto.setDrAmt(NumberUtils.nullDefaultZero((Number)predOutflowAmt).toString());
                dtlDto.setNettingAmt(NumberUtils.nullDefaultZero((Number)pureInflowAmt).toString());
                dtlDto.setPosAccAmt(NumberUtils.nullDefaultZero((Number)predAmt).toString());
                dtlDto.setPredDate(predDate);
                list.add(dtlDto);
            }
        } else if (currentDate.equals(predDate)) {
            if (isTopBranch) {
                BigDecimal yesterdayAmt = this.psDCorpaccbookRepo.getCorpAccYesterdayBalSum();
                BigDecimal nettingAmt = this.psMPostcaljnlRepo.getAllBranchLatestNettingAmtSum(predDate);
                BigDecimal inflowAmt = this.psMPaytranjnlRepo.getAllBranchInFlowAmtSum(predDate);
                BigDecimal outflowAmt = this.psMPaytranjnlRepo.getAllBranchOutFlowAmtSum(predDate);
                BigDecimal pureInflowAmt = NumberUtils.sub((BigDecimal[])new BigDecimal[]{inflowAmt, outflowAmt});
                Ps05001RspDtlDto dtlDto = new Ps05001RspDtlDto();
                dtlDto.setCrAmt(NumberUtils.nullDefaultZero((Number)inflowAmt).toString());
                dtlDto.setDrAmt(NumberUtils.nullDefaultZero((Number)outflowAmt).toString());
                dtlDto.setNettingAmt(NumberUtils.nullDefaultZero((Number)pureInflowAmt).toString());
                dtlDto.setPosAccAmt(NumberUtils.nullDefaultZero((Number)yesterdayAmt.add(nettingAmt)).toString());
                dtlDto.setPredDate(predDate);
                list.add(dtlDto);
            } else {
                PsBCtyspecbookVo bCtyspecbookVo;
                BigDecimal bal = new BigDecimal("0");
                BigDecimal predadjamt = new BigDecimal("0");
                BigDecimal financeadjamt = new BigDecimal("0");
                BigDecimal financepaycoll = new BigDecimal("0");
                BigDecimal cashpaycoll = new BigDecimal("0");
                BigDecimal loanenjapay = new BigDecimal("0");
                BigDecimal trealibtax = new BigDecimal("0");
                BigDecimal bankrefin = new BigDecimal("0");
                PsDBankaccbookVo dBankaccbookVo = this.psDBankaccbookRepo.getBranchBankaccbookInfo(headerBrNo);
                if (ObjectUtils.isNotEmpty((Object)dBankaccbookVo)) {
                    bal = dBankaccbookVo.getTodaybal();
                }
                if (ObjectUtils.isNotEmpty((Object)(bCtyspecbookVo = this.psBCtyspecbookRepo.getPsBCtyspecbookInfo(headerBrNo, predDate)))) {
                    predadjamt = bCtyspecbookVo.getPredadjamt();
                    financeadjamt = bCtyspecbookVo.getFinanceadjamt();
                    financepaycoll = bCtyspecbookVo.getFinancepaycoll();
                    cashpaycoll = bCtyspecbookVo.getCashpaycoll();
                    loanenjapay = bCtyspecbookVo.getLoanenjapay();
                    trealibtax = bCtyspecbookVo.getTrealibtax();
                    bankrefin = bCtyspecbookVo.getBankrefin();
                }
                BigDecimal postPredAmt = this.psBPostpredbookRepo.getBranchPostPredAmtSum(headerBrNo, predDate);
                BigDecimal wrtoffAmt = this.psMWrtoffinlRepo.getBranchWrtoffAmtSum(headerBrNo, predDate);
                BigDecimal inflowAmt = this.psMPaytranjnlRepo.getBranchInFlowAmtSum(headerBrNo, predDate);
                BigDecimal outflowAmt = this.psMPaytranjnlRepo.getBranchOutFlowAmtSum(headerBrNo, predDate);
                BigDecimal pureInflowAmt = NumberUtils.sub((BigDecimal[])new BigDecimal[]{inflowAmt, outflowAmt});
                BigDecimal predAmt = NumberUtils.sub((BigDecimal[])new BigDecimal[]{bal, predadjamt, financeadjamt, financepaycoll, cashpaycoll, loanenjapay});
                predAmt = predAmt.add(trealibtax).add(bankrefin);
                predAmt = NumberUtils.sub((BigDecimal[])new BigDecimal[]{predAmt, postPredAmt}).add(wrtoffAmt).add(inflowAmt);
                predAmt = NumberUtils.sub((BigDecimal[])new BigDecimal[]{predAmt, outflowAmt});
                Ps05001RspDtlDto dtlDto = new Ps05001RspDtlDto();
                dtlDto.setCrAmt(NumberUtils.nullDefaultZero((Number)inflowAmt).toString());
                dtlDto.setDrAmt(NumberUtils.nullDefaultZero((Number)outflowAmt).toString());
                dtlDto.setNettingAmt(NumberUtils.nullDefaultZero((Number)pureInflowAmt).toString());
                dtlDto.setPosAccAmt(NumberUtils.nullDefaultZero((Number)predAmt).toString());
                dtlDto.setPredDate(predDate);
                list.add(dtlDto);
            }
        }
        head.setTotalSize(1L);
        rspBodyDto.setList(list);
        rspBodyDto.setStatus("1");
        rspBodyDto.setErrcode(head.getResponseCode());
        rspBodyDto.setErrmsg(head.getResponseMsg());
        yuinResultDto.setBody((Object)rspBodyDto);
        return yuinResultDto;
    }
}

