/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps03007.Ps03007ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03007.Ps03007RspDto;
import cn.com.yusys.yusp.pay.position.dao.po.PsBPostpredbookPo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsBPostpredbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMPaytranjnlRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMWrtoffinlRepo;
import cn.com.yusys.yusp.pay.position.domain.service.PsHvTranJnlDomainService;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsBPostpredbookVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMPaytranjnlVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMWrtoffinlVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS03007Service {
    @Autowired
    private PsMPaytranjnlRepo ps03007Repo;
    @Autowired
    private PsBPostpredbookRepo ps03001Repo;
    @Autowired
    private PsMWrtoffinlRepo ps03008Repo;
    @Autowired
    private PsHvTranJnlDomainService psHvTranJnlDomainService;
    private static final Logger log = LoggerFactory.getLogger(PS03007Service.class);

    public YuinResultDto ps03007(YuinRequestDto<Ps03007ReqDto> yuinRequestDto) {
        Ps03007ReqDto Ps03007ReqDto2 = (Ps03007ReqDto)yuinRequestDto.getBody();
        PsMPaytranjnlVo psMPaytranjnlVo = (PsMPaytranjnlVo)BeanUtils.beanCopy((Object)Ps03007ReqDto2, PsMPaytranjnlVo.class);
        YuinResultDto resultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        resultDto.setHead(head);
        try {
            this.ps03007Repo.save(psMPaytranjnlVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.toString());
            resultDto.setBody((Object)new Ps03007RspDto("0", PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg()));
        }
        this.psHvTranJnlDomainService.invokeHvTranJnlHandler(psMPaytranjnlVo);
        PsBPostpredbookVo predVo = new PsBPostpredbookVo();
        String dcflag = psMPaytranjnlVo.getDcflag();
        String payeeaccno = psMPaytranjnlVo.getPayeeaccno();
        String payeraccno = psMPaytranjnlVo.getPayeraccno();
        BigDecimal amt = psMPaytranjnlVo.getAmt();
        predVo.setPreddate(psMPaytranjnlVo.getWorkdate());
        predVo.setBrno(psMPaytranjnlVo.getBrno());
        predVo.setBusitype(psMPaytranjnlVo.getBusitype());
        if ("d".equals(dcflag) || "D".equals(dcflag)) {
            predVo.setAccno(payeraccno);
            predVo.setPmtdrt("2");
        } else {
            predVo.setAccno(payeeaccno);
            predVo.setPmtdrt("1");
        }
        if (StringUtils.isNotBlank((CharSequence)predVo.getAccno()) && StringUtils.isNotBlank((CharSequence)predVo.getPmtdrt())) {
            List listPredPo = this.ps03001Repo.getpredList(predVo);
            BigDecimal diff = new BigDecimal("0");
            BigDecimal wortAmt = amt;
            if (listPredPo.size() == 0) {
                psMPaytranjnlVo.setPredflag("0");
            } else {
                psMPaytranjnlVo.setPredflag("1");
            }
            for (PsBPostpredbookPo psBPostpredbookPo : listPredPo) {
                PsBPostpredbookVo rspPredVo = (PsBPostpredbookVo)BeanUtils.beanCopy((Object)psBPostpredbookPo, PsBPostpredbookVo.class);
                BigDecimal predAmt = rspPredVo.getWrtoffbal();
                if (wortAmt.compareTo(BigDecimal.ZERO) == 0) break;
                if (wortAmt.compareTo(predAmt) == 0) {
                    rspPredVo.setWrtoffbal(BigDecimal.valueOf(0L));
                    rspPredVo.setWrtofftype("01");
                    rspPredVo.setWrtoffstatus("03");
                }
                if (wortAmt.compareTo(predAmt) < 0) {
                    rspPredVo.setWrtoffbal(predAmt.subtract(amt));
                    rspPredVo.setWrtofftype("01");
                    rspPredVo.setWrtoffstatus("02");
                }
                if (wortAmt.compareTo(predAmt) > 0) {
                    rspPredVo.setWrtoffbal(new BigDecimal("0"));
                    rspPredVo.setWrtofftype("01");
                    rspPredVo.setWrtoffstatus("03");
                    wortAmt = predAmt;
                }
                this.ps03001Repo.doUpdate(rspPredVo);
                PsMWrtoffinlVo wrtoff = new PsMWrtoffinlVo();
                wrtoff.setAccno(rspPredVo.getAccno());
                wrtoff.setBrno(rspPredVo.getBrno());
                wrtoff.setAppid("PS");
                wrtoff.setOrigworkdate(psMPaytranjnlVo.getWorkdate());
                wrtoff.setOrigworkseqid(psMPaytranjnlVo.getWorkseqid());
                wrtoff.setPmtdrt(rspPredVo.getPmtdrt());
                wrtoff.setPreddate(rspPredVo.getPreddate());
                wrtoff.setPredno(rspPredVo.getPredno());
                wrtoff.setPredworkdate(rspPredVo.getWorkdate());
                wrtoff.setSysid("PS");
                wrtoff.setWorkdate(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT));
                wrtoff.setWrtoffseqno(SequenceUtils.getSequence((String)"bankseqno"));
                wrtoff.setWrtofftellerno("Auto");
                wrtoff.setWrtofftype("1");
                wrtoff.setWrtoffamt(wortAmt);
                wrtoff.setWrtoffbal(rspPredVo.getWrtoffbal());
                this.ps03008Repo.save(wrtoff);
                psMPaytranjnlVo.setPredflag("2");
                if (wortAmt.compareTo(predAmt) <= 0) break;
                wortAmt = wortAmt.subtract(predAmt);
            }
            this.ps03007Repo.updateById(psMPaytranjnlVo);
        }
        resultDto.setBody((Object)new Ps03007RspDto("1", "", ""));
        return resultDto;
    }
}

