/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps02001.Ps02001RspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03001.Ps03001DtelRspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03001.Ps03001ReqDto;
import cn.com.yusys.yusp.pay.position.application.service.PS03001Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS03001"})
@RestController
public class PS03001Resource {
    @Autowired
    private PS03001Service pS03001Service;

    @ApiOperation(value="\u5934\u5bf8\u9884\u62a5\u53ca\u5ba1\u6279")
    @PostMapping(value={"/api/payment/ps/ps03001"})
    public YuinResultDto<Ps03001DtelRspDto> ps03001(@RequestBody @Validated YuinRequestDto<Ps03001ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS03001Service.ps03001(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps03001ReqDto> yuinRequestDto) {
        Ps03001ReqDto ps03001ReqDto = (Ps03001ReqDto)yuinRequestDto.getBody();
        try {
            ValidatorUtils.validate((Object)ps03001ReqDto, (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)((Ps03001ReqDto)yuinRequestDto.getBody()).getFunctype())) {
            throw new BizBaseException(PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000002.getErrMsg(), new Object[0]);
        }
        if ("6".equals(((Ps03001ReqDto)yuinRequestDto.getBody()).getFunctype())) {
            if (StringUtils.isBlank((CharSequence)((Ps03001ReqDto)yuinRequestDto.getBody()).getPreddate())) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
            if (((Ps03001ReqDto)yuinRequestDto.getBody()).getAmt().compareTo(BigDecimal.ZERO) == 0) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
            if (((Ps03001ReqDto)yuinRequestDto.getBody()).getAmt().compareTo(BigDecimal.ZERO) == 0) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
            if (StringUtils.isBlank((CharSequence)((Ps03001ReqDto)yuinRequestDto.getBody()).getAccno())) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
        } else if ("7".equals(((Ps03001ReqDto)yuinRequestDto.getBody()).getFunctype())) {
            if (StringUtils.isBlank((CharSequence)((Ps03001ReqDto)yuinRequestDto.getBody()).getStartdate())) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
            if (StringUtils.isBlank((CharSequence)((Ps03001ReqDto)yuinRequestDto.getBody()).getEnddate())) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
            if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)((Ps03001ReqDto)yuinRequestDto.getBody()).getEnddate(), (String)((Ps03001ReqDto)yuinRequestDto.getBody()).getStartdate())) {
                throw new BizBaseException(PSErrorMsg.PS080003.getErrCode(), PSErrorMsg.PS080003.getErrMsg(), new Object[0]);
            }
            if (StringUtils.isBlank((CharSequence)((Ps03001ReqDto)yuinRequestDto.getBody()).getBrnotype())) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
            if ("03".equals(((Ps03001ReqDto)yuinRequestDto.getBody()).getBrnotype()) && StringUtils.isBlank((CharSequence)((Ps03001ReqDto)yuinRequestDto.getBody()).getBrno())) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
        } else {
            if (StringUtils.isBlank((CharSequence)((Ps03001ReqDto)yuinRequestDto.getBody()).getWorkdate())) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
            if (StringUtils.isBlank((CharSequence)((Ps03001ReqDto)yuinRequestDto.getBody()).getPredno())) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
        }
    }

    private YuinResultDto handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        Ps02001RspDto rspDto = new Ps02001RspDto("0", errCode, errMsg);
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        yuinResultDto.setHead(head);
        yuinResultDto.setBody((Object)rspDto);
        return yuinResultDto;
    }
}

