/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.pay.position.application.dto.ps12001.Ps12001ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps12001.Ps12001ReqListDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps12001.Ps12001RspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps12001.Ps12001RspList1Dto;
import cn.com.yusys.yusp.pay.position.application.dto.ps12001.Ps12001RspList2Dto;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDHolidayrecordRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDHolidayrecordVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS12001Service {
    private static final Logger log = LoggerFactory.getLogger(PS12001Service.class);
    @Autowired
    private PsDHolidayrecordRepo psDHolidayrecordRepo;

    public YuinResultDto<Ps12001RspDto> ps12001(YuinRequestDto<Ps12001ReqDto> yuinRequestDto) {
        YuinRequestDto request = new YuinRequestDto();
        request.setSysHead(yuinRequestDto.getSysHead());
        Ps12001ReqDto ps12001ReqDto = (Ps12001ReqDto)yuinRequestDto.getBody();
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead resultHead = new YuinResultHead();
        resultHead.setResponseCode("200");
        resultHead.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(resultHead);
        try {
            switch (StringUtils.isBlank((CharSequence)ps12001ReqDto.getFuncType()) ? "9999" : ps12001ReqDto.getFuncType()) {
                case "1": 
                case "2": {
                    yuinResultDto.setBody((Object)this.doInsert(ps12001ReqDto, request.getSysHead()));
                    break;
                }
                case "3": {
                    yuinResultDto.setBody((Object)this.doDelete(ps12001ReqDto, request.getSysHead()));
                    break;
                }
                case "4": {
                    yuinResultDto.setBody((Object)this.doQuery(ps12001ReqDto, request.getSysHead(), resultHead));
                    break;
                }
                default: {
                    yuinResultDto.setBody((Object)new Ps12001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000002.getErrMsg()));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.toString());
            yuinResultDto.setBody((Object)new Ps12001RspDto("0", PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg()));
        }
        return yuinResultDto;
    }

    private Ps12001RspDto doDelete(Ps12001ReqDto ps12001ReqDto, YuinRequestHead requestHead) {
        String datetype = ps12001ReqDto.getDatetype();
        String holidayyear = ps12001ReqDto.getHolidayyear();
        if (StringUtils.isBlank((CharSequence)datetype)) {
            return new Ps12001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570datetype");
        }
        if (StringUtils.isBlank((CharSequence)holidayyear)) {
            return new Ps12001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11\u53c2\u6570:holidayyear-\u8282\u5047\u65e5\u5e74\u4efd");
        }
        PsDHolidayrecordVo psDHolidayrecordVo = new PsDHolidayrecordVo();
        psDHolidayrecordVo.setDatetype(datetype);
        psDHolidayrecordVo.setHolidayyear(holidayyear);
        psDHolidayrecordVo.setAppid(requestHead.getAppid());
        psDHolidayrecordVo.setSysid(requestHead.getSysid());
        this.psDHolidayrecordRepo.doDelete(psDHolidayrecordVo);
        return new Ps12001RspDto("1", "", "");
    }

    private Ps12001RspDto doInsert(Ps12001ReqDto ps12001ReqDto, YuinRequestHead requestHead) {
        List<Ps12001ReqListDto> list = ps12001ReqDto.getList();
        ArrayList<PsDHolidayrecordVo> voList = new ArrayList<PsDHolidayrecordVo>();
        String datetype = ps12001ReqDto.getDatetype();
        String holidayyear = ps12001ReqDto.getHolidayyear();
        if (StringUtils.isBlank((CharSequence)datetype)) {
            return new Ps12001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11\u53c2\u6570:datetype-\u8282\u5047\u65e5\u7c7b\u578b");
        }
        if (StringUtils.isBlank((CharSequence)holidayyear)) {
            return new Ps12001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11\u53c2\u6570:holidayyear-\u8282\u5047\u65e5\u5e74\u4efd");
        }
        if ("01".equals(datetype)) {
            List weekDays = PSDateUtil.getWeekDay((int)Integer.parseInt(holidayyear));
            List voList1 = this.psDHolidayrecordRepo.doQuery(holidayyear);
            for (PsDHolidayrecordVo vo : voList1) {
                if (!weekDays.contains(vo.getHoliday())) continue;
                weekDays.remove(vo.getHoliday());
            }
            for (String holiday : weekDays) {
                PsDHolidayrecordVo vo = new PsDHolidayrecordVo();
                vo.setAppid(requestHead.getAppid());
                vo.setSysid(requestHead.getSysid());
                vo.setHolidayyear(holidayyear);
                vo.setDatetype(datetype);
                vo.setHoliday(holiday);
                voList.add(vo);
            }
        } else {
            for (Ps12001ReqListDto d : list) {
                PsDHolidayrecordVo vo = new PsDHolidayrecordVo();
                vo.setAppid(requestHead.getAppid());
                vo.setSysid(requestHead.getSysid());
                vo.setHolidayyear(holidayyear);
                vo.setDatetype(datetype);
                vo.setHoliday(d.getHoliday());
                voList.add(vo);
            }
        }
        this.psDHolidayrecordRepo.doInsetBatch(voList, datetype, holidayyear);
        return new Ps12001RspDto("1", "", "");
    }

    private Ps12001RspDto doQuery(Ps12001ReqDto ps12001ReqDto, YuinRequestHead requestHead, YuinResultHead resultHead) {
        String datetype = ps12001ReqDto.getDatetype();
        PsDHolidayrecordVo psDHolidayrecordVo = new PsDHolidayrecordVo();
        psDHolidayrecordVo.setDatetype(datetype);
        psDHolidayrecordVo.setHolidayyear(ps12001ReqDto.getHolidayyear());
        psDHolidayrecordVo.setAppid(requestHead.getAppid());
        psDHolidayrecordVo.setSysid(requestHead.getSysid());
        psDHolidayrecordVo.setSize(Long.valueOf(requestHead.getPageSize().intValue()));
        psDHolidayrecordVo.setPage(Long.valueOf(requestHead.getPageNum().intValue()));
        IPage pages = this.psDHolidayrecordRepo.doQuery(psDHolidayrecordVo);
        List voList = pages.getRecords();
        if (CollectionUtils.isEmpty((Collection)voList)) {
            return new Ps12001RspDto("1", "", "");
        }
        HashMap<String, Ps12001RspList1Dto> maps = new HashMap<String, Ps12001RspList1Dto>();
        for (PsDHolidayrecordVo vo : voList) {
            List<Ps12001RspList2Dto> list2Dtos;
            Ps12001RspList1Dto list1Dto;
            String key = vo.getDatetype() + vo.getHolidayyear();
            if (maps.containsKey(key)) {
                list1Dto = (Ps12001RspList1Dto)maps.get(key);
                list2Dtos = list1Dto.getList();
                list2Dtos.add(new Ps12001RspList2Dto(vo.getHoliday()));
                maps.put(key, list1Dto);
                continue;
            }
            list1Dto = new Ps12001RspList1Dto(vo.getDatetype(), vo.getHolidayyear());
            list2Dtos = new ArrayList<Ps12001RspList2Dto>();
            list2Dtos.add(new Ps12001RspList2Dto(vo.getHoliday()));
            list1Dto.setList(list2Dtos);
            maps.put(key, list1Dto);
        }
        resultHead.setTotalSize((long)maps.size());
        Ps12001RspDto ps12001RspDto = new Ps12001RspDto("1", "", "");
        ps12001RspDto.setList(maps.values().stream().collect(Collectors.toList()));
        return ps12001RspDto;
    }
}

