/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.pay.position.application.dto.ps08003.Ps08003ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps08003.Ps08003RspDtlDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps08003.Ps08003RspDto;
import cn.com.yusys.yusp.pay.position.domain.entity.PsBranchAccountDo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.ReportDoSqlRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS08003Service {
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;
    @Autowired
    private ReportDoSqlRepo reportDoSqlRepo;

    public YuinResultDto<Ps08003RspDto> ps08003(YuinRequestDto<Ps08003ReqDto> yuinRequestDto) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinRequestHead header = yuinRequestDto.getSysHead();
        Ps08003ReqDto ps08003ReqDto = (Ps08003ReqDto)yuinRequestDto.getBody();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(head);
        String headerBrNo = header.getBrno();
        String brType = ps08003ReqDto.getBrType();
        String brNo = ps08003ReqDto.getBrNo();
        PsBranchAccountDo branchAccountDo = new PsBranchAccountDo();
        branchAccountDo.checkBrTypeValue(brType);
        List<String> queryBrNoList = new ArrayList<String>();
        if ("01".equals(brType)) {
            queryBrNoList.add(headerBrNo);
        } else if ("02".equals(brType)) {
            queryBrNoList = this.psDBranchadmRepo.getBrnoTreeInfoByBrno(headerBrNo);
        } else if ("03".equals(brType)) {
            if (StringUtils.isBlank((String)brNo)) {
                throw new BizBaseException(PSErrorMsg.PS000008.getErrCode(), "\u673a\u6784\u53f7" + PSErrorMsg.PS000008.getErrMsg(), new Object[0]);
            }
            queryBrNoList.add(brNo);
        }
        IPage page_res = this.reportDoSqlRepo.getReportData(ps08003ReqDto.getStartDate(), ps08003ReqDto.getEndDate(), queryBrNoList, header.getPageNum(), header.getPageSize());
        page_res.getRecords().removeAll(Collections.singleton(null));
        ArrayList<Ps08003RspDtlDto> result_list = new ArrayList<Ps08003RspDtlDto>();
        Ps08003RspDtlDto ps08003RspDtlDto = null;
        if (page_res.getRecords() != null && !page_res.getRecords().isEmpty()) {
            for (Map map : page_res.getRecords()) {
                ps08003RspDtlDto = new Ps08003RspDtlDto();
                ps08003RspDtlDto.setBrno(ObjectUtils.isNotEmpty(map.get("brno")) ? map.get("brno").toString() : "");
                ps08003RspDtlDto.setBrname(ObjectUtils.isNotEmpty(map.get("brname")) ? map.get("brname").toString() : "");
                ps08003RspDtlDto.setLadayacctbal(ObjectUtils.isNotEmpty(map.get("ladayacctbal")) ? map.get("ladayacctbal").toString() : "");
                ps08003RspDtlDto.setLadaydeposbal(ObjectUtils.isNotEmpty(map.get("ladaydeposbal")) ? map.get("ladaydeposbal").toString() : "");
                ps08003RspDtlDto.setDeposper(ObjectUtils.isNotEmpty(map.get("deposper")) ? map.get("deposper").toString() : "");
                ps08003RspDtlDto.setTodaydramt(ObjectUtils.isNotEmpty(map.get("todaydramt")) ? map.get("todaydramt").toString() : "");
                ps08003RspDtlDto.setTodaycramt(ObjectUtils.isNotEmpty(map.get("todaycramt")) ? map.get("todaycramt").toString() : "");
                ps08003RspDtlDto.setNetoutflow(ObjectUtils.isNotEmpty(map.get("netoutflow")) ? map.get("netoutflow").toString() : "");
                result_list.add(ps08003RspDtlDto);
            }
        }
        Ps08003RspDto ps08003RspDto = new Ps08003RspDto("1", head.getResponseCode(), head.getResponseMsg());
        head.setTotalSize(page_res.getTotal());
        ps08003RspDto.setList(result_list);
        yuinResultDto.setBody((Object)ps08003RspDto);
        return yuinResultDto;
    }
}

