/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.NumberUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps05002.Ps05002ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps05002.Ps05002RspDtlDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps05002.Ps05002RspDto;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsRBankPosDayBalRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsRBrpaytranRepo;
import cn.com.yusys.yusp.pay.position.domain.service.PS05002DomainService;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBranchadmVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsRBrpaytranVo;
import cn.com.yusys.yusp.pay.position.domain.vo.service.CalculationDateVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS05002Service {
    private static final Logger log = LoggerFactory.getLogger(PS05002Service.class);
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;
    @Autowired
    private PsRBrpaytranRepo psRBrpaytranRepo;
    @Autowired
    private PsRBankPosDayBalRepo psRBankPosDayBalRepo;
    @Autowired
    private PS05002DomainService ps05002DomainService;

    public YuinResultDto<Ps05002RspDto> ps05002(YuinRequestDto<Ps05002ReqDto> yuinRequestDto) {
        PsRBrpaytranVo psRBrpaytranVo;
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(head);
        Ps05002RspDto rspBodyDto = new Ps05002RspDto();
        YuinRequestHead header = yuinRequestDto.getSysHead();
        String headerBrNo = header.getBrno();
        if (!this.psDBranchadmRepo.isBranchCanOperate(headerBrNo)) {
            throw new BizBaseException(PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg(), new Object[0]);
        }
        String headerBrName = "";
        PsDBranchadmVo psDBranchadmVo = this.psDBranchadmRepo.getBranchInfoByBrNo(headerBrNo);
        if (ObjectUtils.isNotEmpty((Object)psDBranchadmVo)) {
            headerBrName = psDBranchadmVo.getBrname();
        }
        Ps05002ReqDto requestDtoBody = (Ps05002ReqDto)yuinRequestDto.getBody();
        String holType = requestDtoBody.getHolType();
        String holYear = requestDtoBody.getHolYear();
        CalculationDateVo calculationDateVo = this.ps05002DomainService.getCalculationDate(holYear, holType);
        String thisYearStartDate = calculationDateVo.getThisYearStartDate();
        String thisYearEndDate = calculationDateVo.getThisYearEndDate();
        String lastYearStartDate = calculationDateVo.getLastYearStartDate();
        String lastYearEndDate = calculationDateVo.getLastYearEndDate();
        String holDays = calculationDateVo.getHolDays();
        String holTypeName = calculationDateVo.getHolTypeName();
        boolean isTopBranch = this.psDBranchadmRepo.isTopBranch(headerBrNo);
        BigDecimal recent15dayInflowAmt = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal recent15dayOutflowAmt = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal recent15dayHvInflowAmt = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal recent15dayHvOutflowAmt = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal hvInflowRate = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal hvOutflowRate = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal recentInflowPredAmt = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal recentOutflowPredAmt = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal recentNettingInflowPredAmt = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal thisYearDepositAmt = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal lastYearDepositAmt = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal thisYearPostAmt = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal lastYearPostAmt = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal depositRate = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal postRate = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal increaseRate = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal predAmtByLastYear = NumberUtils.nullDefaultZero((String)"0");
        BigDecimal predAmt = NumberUtils.nullDefaultZero((String)"0");
        String startDate = PSDateUtil.getPastDate((int)-15);
        String endDate = PSDateUtil.getPastDate((int)-1);
        if (isTopBranch) {
            psRBrpaytranVo = this.psRBrpaytranRepo.getAllBranchAmt(startDate, endDate);
            if (ObjectUtils.isNotEmpty((Object)psRBrpaytranVo)) {
                recent15dayInflowAmt = NumberUtils.nullDefaultZero((Number)psRBrpaytranVo.getCramt());
                recent15dayOutflowAmt = NumberUtils.nullDefaultZero((Number)psRBrpaytranVo.getDramt());
                recent15dayHvInflowAmt = NumberUtils.nullDefaultZero((Number)psRBrpaytranVo.getHvcramt());
                recent15dayHvOutflowAmt = NumberUtils.nullDefaultZero((Number)psRBrpaytranVo.getHvdramt());
            }
            thisYearDepositAmt = NumberUtils.nullDefaultZero((Number)this.psRBankPosDayBalRepo.getAllBranchDepositAmt(thisYearStartDate, thisYearEndDate));
            lastYearDepositAmt = NumberUtils.nullDefaultZero((Number)this.psRBankPosDayBalRepo.getAllBranchDepositAmt(lastYearStartDate, lastYearEndDate));
            thisYearPostAmt = NumberUtils.nullDefaultZero((Number)this.psRBankPosDayBalRepo.getAllBranchPostAmt(thisYearStartDate, thisYearEndDate));
            lastYearPostAmt = NumberUtils.nullDefaultZero((Number)this.psRBankPosDayBalRepo.getAllBranchPostAmt(lastYearStartDate, lastYearEndDate));
        } else {
            psRBrpaytranVo = this.psRBrpaytranRepo.getBranchAmt(headerBrNo, startDate, endDate);
            if (ObjectUtils.isNotEmpty((Object)psRBrpaytranVo)) {
                recent15dayInflowAmt = NumberUtils.nullDefaultZero((Number)psRBrpaytranVo.getCramt());
                recent15dayOutflowAmt = NumberUtils.nullDefaultZero((Number)psRBrpaytranVo.getDramt());
                recent15dayHvInflowAmt = NumberUtils.nullDefaultZero((Number)psRBrpaytranVo.getHvcramt());
                recent15dayHvOutflowAmt = NumberUtils.nullDefaultZero((Number)psRBrpaytranVo.getHvdramt());
            }
            thisYearDepositAmt = NumberUtils.nullDefaultZero((Number)this.psRBankPosDayBalRepo.getBranchDepositAmt(headerBrNo, thisYearStartDate, thisYearEndDate));
            lastYearDepositAmt = NumberUtils.nullDefaultZero((Number)this.psRBankPosDayBalRepo.getBranchDepositAmt(headerBrNo, lastYearStartDate, lastYearEndDate));
            thisYearPostAmt = NumberUtils.nullDefaultZero((Number)this.psRBankPosDayBalRepo.getBranchPostAmt(headerBrNo, thisYearStartDate, thisYearEndDate));
            lastYearPostAmt = NumberUtils.nullDefaultZero((Number)this.psRBankPosDayBalRepo.getBranchPostAmt(headerBrNo, lastYearStartDate, lastYearEndDate));
        }
        if (recent15dayInflowAmt.compareTo(BigDecimal.ZERO) == 1) {
            hvInflowRate = NumberUtils.round((BigDecimal)NumberUtils.divide((BigDecimal)recent15dayHvInflowAmt, (BigDecimal)recent15dayInflowAmt), (int)4);
        }
        if (recent15dayOutflowAmt.compareTo(BigDecimal.ZERO) == 1) {
            hvOutflowRate = NumberUtils.round((BigDecimal)NumberUtils.divide((BigDecimal)recent15dayHvOutflowAmt, (BigDecimal)recent15dayOutflowAmt), (int)4);
        }
        recentInflowPredAmt = NumberUtils.sub((BigDecimal[])new BigDecimal[]{BigDecimal.ONE, hvInflowRate}).multiply(recent15dayInflowAmt);
        recentOutflowPredAmt = NumberUtils.sub((BigDecimal[])new BigDecimal[]{BigDecimal.ONE, hvOutflowRate}).multiply(recent15dayOutflowAmt);
        recentNettingInflowPredAmt = NumberUtils.sub((BigDecimal[])new BigDecimal[]{recentInflowPredAmt, recentOutflowPredAmt});
        if (lastYearDepositAmt.compareTo(BigDecimal.ZERO) == 1) {
            depositRate = NumberUtils.round((BigDecimal)NumberUtils.divide((BigDecimal)NumberUtils.sub((BigDecimal[])new BigDecimal[]{thisYearDepositAmt, lastYearDepositAmt}), (BigDecimal)lastYearDepositAmt), (int)4);
        }
        if (lastYearPostAmt.compareTo(BigDecimal.ZERO) == 1) {
            postRate = NumberUtils.round((BigDecimal)NumberUtils.divide((BigDecimal)NumberUtils.sub((BigDecimal[])new BigDecimal[]{thisYearPostAmt, lastYearPostAmt}), (BigDecimal)lastYearPostAmt), (int)4);
        }
        increaseRate = depositRate;
        if (postRate.compareTo(depositRate) == 1) {
            increaseRate = postRate;
        }
        predAmtByLastYear = NumberUtils.multiply((BigDecimal[])new BigDecimal[]{lastYearPostAmt, increaseRate});
        predAmt = NumberUtils.multiply((BigDecimal[])new BigDecimal[]{predAmtByLastYear, new BigDecimal(holDays)});
        if (recentNettingInflowPredAmt.compareTo(predAmtByLastYear) == 1) {
            predAmt = NumberUtils.multiply((BigDecimal[])new BigDecimal[]{recentNettingInflowPredAmt, new BigDecimal(holDays)});
        }
        ArrayList<Ps05002RspDtlDto> list = new ArrayList<Ps05002RspDtlDto>();
        Ps05002RspDtlDto dtlDto = new Ps05002RspDtlDto();
        dtlDto.setBrName(headerBrName);
        dtlDto.setBrNo(headerBrNo);
        dtlDto.setDepositRiseRate(NumberUtils.round((BigDecimal)NumberUtils.multiply((BigDecimal[])new BigDecimal[]{depositRate, BigDecimal.TEN, BigDecimal.TEN}), (int)2).toString());
        dtlDto.setHolTypeName(holTypeName);
        dtlDto.setLastYearCrAmt(NumberUtils.round((BigDecimal)lastYearPostAmt, (int)0).toString());
        dtlDto.setLastYearDeposit(NumberUtils.round((BigDecimal)lastYearDepositAmt, (int)0).toString());
        dtlDto.setLastYearPredAmt(NumberUtils.round((BigDecimal)predAmtByLastYear, (int)0).toString());
        dtlDto.setPosPredAmt(NumberUtils.round((BigDecimal)predAmt, (int)0).toString());
        dtlDto.setReceChnlCrRate(NumberUtils.round((BigDecimal)NumberUtils.multiply((BigDecimal[])new BigDecimal[]{hvInflowRate, BigDecimal.TEN, BigDecimal.TEN}), (int)2).toString());
        dtlDto.setReceChnlDrRate(NumberUtils.round((BigDecimal)NumberUtils.multiply((BigDecimal[])new BigDecimal[]{hvOutflowRate, BigDecimal.TEN, BigDecimal.TEN}), (int)2).toString());
        dtlDto.setReceCrAmt(NumberUtils.round((BigDecimal)recent15dayInflowAmt, (int)0).toString());
        dtlDto.setReceDrAmt(NumberUtils.round((BigDecimal)recent15dayOutflowAmt, (int)0).toString());
        dtlDto.setRecePredCrAmt(NumberUtils.round((BigDecimal)recentInflowPredAmt, (int)0).toString());
        dtlDto.setRecePredDrAmt(NumberUtils.round((BigDecimal)recentOutflowPredAmt, (int)0).toString());
        dtlDto.setRecePredNettingAmt(NumberUtils.round((BigDecimal)recentNettingInflowPredAmt, (int)0).toString());
        dtlDto.setRiseRate(NumberUtils.round((BigDecimal)NumberUtils.multiply((BigDecimal[])new BigDecimal[]{postRate, BigDecimal.TEN, BigDecimal.TEN}), (int)2).toString());
        dtlDto.setThisYearCrAmt(NumberUtils.round((BigDecimal)thisYearPostAmt, (int)0).toString());
        dtlDto.setThisYearDeposit(NumberUtils.round((BigDecimal)thisYearDepositAmt, (int)0).toString());
        list.add(dtlDto);
        head.setTotalSize(1L);
        rspBodyDto.setList(list);
        rspBodyDto.setStatus("1");
        rspBodyDto.setErrcode(head.getResponseCode());
        rspBodyDto.setErrmsg(head.getResponseMsg());
        yuinResultDto.setBody((Object)rspBodyDto);
        return yuinResultDto;
    }
}

