/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps03004.Ps03004DtelRspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03004.Ps03004ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03004.Ps03004RspDto;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDCorpaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMPostcaljnlRepo;
import cn.com.yusys.yusp.pay.position.domain.service.PsMPostcaljnlDomainService;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDCorpaccbookVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS03004Service {
    @Autowired
    private PsMPostcaljnlRepo ps03004Repo;
    @Autowired
    private PsDCorpaccbookRepo psDCorpaccbookRepo;
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;
    @Autowired
    private PsMPostcaljnlDomainService psMPostcaljnlDomainService;
    private static final Logger log = LoggerFactory.getLogger(PS03004Service.class);

    public YuinResultDto ps03004(YuinRequestDto<Ps03004ReqDto> yuinRequestDto) {
        String postType = ((Ps03004ReqDto)yuinRequestDto.getBody()).getPostype();
        List<Ps03004DtelRspDto> list = new ArrayList<Ps03004DtelRspDto>();
        YuinResultDto resultDto = new YuinResultDto();
        Ps03004RspDto ps03004RspDto = new Ps03004RspDto("1", "", "");
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        if (!this.psDBranchadmRepo.isTopBranch(yuinRequestDto.getSysHead().getBrno())) {
            resultDto.setBody((Object)new Ps03004RspDto("0", PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg()));
        } else {
            PsDCorpaccbookVo psDCorpaccbookVo = new PsDCorpaccbookVo();
            psDCorpaccbookVo.setPostype(postType);
            psDCorpaccbookVo.setStatus("1");
            psDCorpaccbookVo.setClearbrno(yuinRequestDto.getSysHead().getBrno());
            List accList = this.psDCorpaccbookRepo.getAllByBean(psDCorpaccbookVo);
            for (PsDCorpaccbookVo accVo : accList) {
                String accNo = accVo.getPostaccno();
                String workDate = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
                try {
                    List caljnlList = this.ps03004Repo.doQuery(workDate, accNo);
                    list = caljnlList.stream().map(vo -> (Ps03004DtelRspDto)BeanUtils.beanCopy((Object)vo, Ps03004DtelRspDto.class)).collect(Collectors.toList());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.info(e.toString());
                    resultDto.setBody((Object)new Ps03004RspDto("0", PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg()));
                }
            }
        }
        ps03004RspDto.setList(list);
        head.setTotalSize((long)list.size());
        resultDto.setHead(head);
        resultDto.setBody((Object)ps03004RspDto);
        if (!"1".equals(((Ps03004RspDto)resultDto.getBody()).getStatus())) {
            head.setResponseCode(((Ps03004RspDto)resultDto.getBody()).getErrcode());
            head.setResponseMsg(((Ps03004RspDto)resultDto.getBody()).getErrmsg());
        }
        return resultDto;
    }

    public YuinResultDto budGettop(YuinRequestDto<Ps03004ReqDto> yuinRequestDto) {
        BigDecimal tagevalue = ((Ps03004ReqDto)yuinRequestDto.getBody()).getTagprovamt();
        this.psMPostcaljnlDomainService.budGet(tagevalue);
        log.info(String.format("%s \u5321\u7b97\u5f02\u6b65\u6267\u884c\u4e2d...", DateUtils.getCurrDateTimeStr()));
        YuinResultDto result = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u6b63\u5728\u5321\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2");
        result.setHead(head);
        return result;
    }
}

