/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps02001.Ps02001DetRspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps02001.Ps02001ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps02001.Ps02001RspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps02003.Ps02003ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps02003.Ps02003RspDto;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDCorpaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDCorpaccbookVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS02001Service {
    private static final Logger log = LoggerFactory.getLogger(PS02001Service.class);
    @Autowired
    private PsDCorpaccbookRepo psDCorpaccbookRepo;

    public YuinResultDto<Ps02001RspDto> PsDCorpaccbookManagement(YuinRequestDto<Ps02001ReqDto> yuinRequestDto) {
        YuinRequestHead header = yuinRequestDto.getSysHead();
        Ps02001ReqDto ps02001ReqDto = (Ps02001ReqDto)Optional.ofNullable(yuinRequestDto.getBody()).orElse(new Ps02001ReqDto());
        ps02001ReqDto.setAppid(header.getAppid());
        ps02001ReqDto.setSysid(header.getSysid());
        PsDCorpaccbookVo psDCorpaccbookVo = (PsDCorpaccbookVo)BeanUtils.beanCopy((Object)ps02001ReqDto, PsDCorpaccbookVo.class);
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        try {
            switch (StringUtils.isBlank((CharSequence)ps02001ReqDto.getOpertype()) ? "9999" : ps02001ReqDto.getOpertype()) {
                case "1": {
                    yuinResultDto.setBody((Object)this.doInsert(psDCorpaccbookVo, header));
                    break;
                }
                case "2": {
                    yuinResultDto.setBody((Object)this.doUpdate(psDCorpaccbookVo, header));
                    break;
                }
                case "3": {
                    yuinResultDto.setBody((Object)this.doDelete(psDCorpaccbookVo));
                    break;
                }
                case "4": {
                    psDCorpaccbookVo.setPage(Long.valueOf(header.getPageNum() == null ? 1L : (long)header.getPageNum().intValue()));
                    psDCorpaccbookVo.setSize(Long.valueOf(header.getPageSize() == null ? 10L : (long)header.getPageSize().intValue()));
                    yuinResultDto.setBody((Object)this.doQuery(psDCorpaccbookVo, head));
                    break;
                }
                default: {
                    yuinResultDto.setBody((Object)new Ps02001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000002.getErrMsg()));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.toString());
            head.setResponseCode(PSErrorMsg.PS000001.getErrCode());
            head.setResponseMsg(PSErrorMsg.PS000001.getErrMsg());
            head.setStatus("0");
            yuinResultDto.setBody((Object)new Ps02001RspDto("0", PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg()));
        }
        yuinResultDto.setHead(head);
        return yuinResultDto;
    }

    private Ps02001RspDto doQuery(PsDCorpaccbookVo psDCorpaccbookVo, YuinResultHead head) {
        IPage rspDtoIPage = this.psDCorpaccbookRepo.queryPage(psDCorpaccbookVo).convert(vo -> (Ps02001DetRspDto)BeanUtils.beanCopy((Object)vo, Ps02001DetRspDto.class));
        head.setTotalSize(rspDtoIPage.getTotal());
        Ps02001RspDto Ps02001RspDto2 = new Ps02001RspDto("1", "", "");
        Ps02001RspDto2.setList(rspDtoIPage.getRecords());
        return Ps02001RspDto2;
    }

    private Ps02001RspDto doDelete(PsDCorpaccbookVo psDCorpaccbookVo) {
        this.psDCorpaccbookRepo.removeById(psDCorpaccbookVo);
        Ps02001RspDto Ps02001RspDto2 = new Ps02001RspDto("1", "", "");
        return Ps02001RspDto2;
    }

    private Ps02001RspDto doUpdate(PsDCorpaccbookVo psDCorpaccbookVo, YuinRequestHead header) {
        psDCorpaccbookVo.setModifier(header.getChnlcode());
        psDCorpaccbookVo.setModifytime(DateUtils.getCurrDateTimeStr());
        this.psDCorpaccbookRepo.updateById(psDCorpaccbookVo);
        Ps02001RspDto Ps02001RspDto2 = new Ps02001RspDto("1", "", "");
        return Ps02001RspDto2;
    }

    private Ps02001RspDto doInsert(PsDCorpaccbookVo psDCorpaccbookVo, YuinRequestHead header) {
        psDCorpaccbookVo.setCreator(header.getChnlcode());
        psDCorpaccbookVo.setCreatetime(DateUtils.getCurrDateTimeStr());
        this.psDCorpaccbookRepo.save(psDCorpaccbookVo);
        Ps02001RspDto Ps02001RspDto2 = new Ps02001RspDto("1", "", "");
        return Ps02001RspDto2;
    }

    public YuinResultDto<Ps02003RspDto> PS02003(YuinRequestDto<Ps02003ReqDto> yuinRequestDto) {
        String posType = ((Ps02003ReqDto)yuinRequestDto.getBody()).getPostype();
        String brNo = yuinRequestDto.getSysHead().getBrno();
        YuinResultDto yuinResultDto = new YuinResultDto();
        Ps02003RspDto result = new Ps02003RspDto("1", "", "");
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        try {
            PsDCorpaccbookVo dataVo = this.psDCorpaccbookRepo.queryNoe(posType, brNo);
            if (dataVo != null) {
                result.setBanklastbal(dataVo.getBanklastbal());
                result.setBanktodaybal(dataVo.getBanktodaybal());
                result.setCorplastbal(dataVo.getCorplastbal());
                result.setCorptodaybal(dataVo.getCorptodaybal());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.toString());
            head.setResponseCode(PSErrorMsg.PS000001.getErrCode());
            head.setResponseMsg(PSErrorMsg.PS000001.getErrMsg());
            head.setStatus("0");
            yuinResultDto.setBody((Object)new Ps02003RspDto("0", PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg()));
        }
        yuinResultDto.setBody((Object)result);
        yuinResultDto.setHead(head);
        return yuinResultDto;
    }
}

