/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps10000.Ps10000ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps10000.Ps10000RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS10000Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS10000"})
@RestController
public class PS10000Resource {
    @Autowired
    private PS10000Service ps10000Service;

    @ApiOperation(value="\u81ea\u5b9a\u4e49\u5b57\u5178\u67e5\u8be2")
    @PostMapping(value={"/api/payment/ps/ps10000"})
    public YuinResultDto<Ps10000RspDto> ps10000(@RequestBody @Validated YuinRequestDto<Ps10000ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.ps10000Service.ps10000(yuinRequestDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps10000ReqDto> yuinRequestDto) {
        try {
            ValidatorUtils.validate((Object)yuinRequestDto.getBody(), (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
    }

    private YuinResultDto<Ps10000RspDto> handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        Ps10000RspDto rspDto = new Ps10000RspDto("0", errCode, errMsg);
        yuinResultDto.setBody((Object)rspDto);
        YuinResultHead head = new YuinResultHead();
        yuinResultDto.setHead(head);
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        return yuinResultDto;
    }
}

