/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps08001.Ps08001ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps08001.Ps08001RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS08001Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS08001"})
@RestController
@RequestMapping(value={"/api/payment/ps"})
public class PS08001Resource {
    @Autowired
    private PS08001Service pS08001Service;

    @ApiOperation(value="\u7b2c\u4e09\u65b9\u8d85\u5907\u4f59\u989d\u6309\u65e5\u671f\u7edf\u8ba1\u5206\u6790")
    @PostMapping(value={"/ps08001"})
    public YuinResultDto<Ps08001RspDto> ps08001(@RequestBody YuinRequestDto<Ps08001ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS08001Service.ps08001(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps08001ReqDto> requestDto) {
        try {
            ValidatorUtils.validate((Object)requestDto.getBody(), (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        String queryDate = ((Ps08001ReqDto)requestDto.getBody()).getQueryDate();
        String currentDate = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)currentDate, (String)queryDate)) {
            throw new BizBaseException(PSErrorMsg.PS080001.getErrCode(), "\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65e5\u671f", new Object[0]);
        }
    }

    private YuinResultDto<Ps08001RspDto> handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        Ps08001RspDto rspDto = new Ps08001RspDto("0", errCode, errMsg);
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        yuinResultDto.setHead(head);
        yuinResultDto.setBody((Object)rspDto);
        return yuinResultDto;
    }
}

