/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps02001.Ps02001RspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03004.Ps03004ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03004.Ps03004RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS03004Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS03004"})
@RestController
public class PS03004Resource {
    @Autowired
    private PS03004Service pS03004Service;

    @ApiOperation(value="\u5934\u5bf8\u5321\u7b97\u67e5\u8be2")
    @PostMapping(value={"/api/payment/ps/ps03004"})
    public YuinResultDto<Ps03004RspDto> ps03004(@RequestBody @Validated YuinRequestDto<Ps03004ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        String funcType = ((Ps03004ReqDto)yuinRequestDto.getBody()).getFunctype();
        try {
            if ("1".equals(funcType)) {
                return this.pS03004Service.ps03004(yuinRequestDto);
            }
            return this.pS03004Service.budGettop(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private YuinResultDto handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        Ps02001RspDto rspDto = new Ps02001RspDto("0", errCode, errMsg);
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        yuinResultDto.setHead(head);
        yuinResultDto.setBody((Object)rspDto);
        return yuinResultDto;
    }

    private void validateRequestDto(YuinRequestDto<Ps03004ReqDto> yuinRequestDto) {
        Ps03004ReqDto ps03004ReqDto = (Ps03004ReqDto)yuinRequestDto.getBody();
        try {
            ValidatorUtils.validate((Object)ps03004ReqDto, (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        if (StringUtils.isBlank((String)((Ps03004ReqDto)yuinRequestDto.getBody()).getFunctype())) {
            throw new BizBaseException(PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000002.getErrMsg(), new Object[0]);
        }
    }
}

