/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps02001.Ps02001ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps02001.Ps02001RspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps02003.Ps02003ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps02003.Ps02003RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS02001Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS02001"})
@RestController
public class PS02001Resource {
    @Autowired
    private PS02001Service pS02001Service;

    @ApiOperation(value="\u7b2c\u4e09\u65b9\u5934\u5bf8\u7ba1\u7406")
    @PostMapping(value={"/api/payment/ps/ps02001"})
    public YuinResultDto<Ps02001RspDto> ps02001(@RequestBody @Validated YuinRequestDto<Ps02001ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS02001Service.PsDCorpaccbookManagement(yuinRequestDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    @ApiOperation(value="\u7b2c\u4e09\u65b9\u4fe1\u606f\u67e5\u8be2")
    @PostMapping(value={"/api/payment/ps/ps02003"})
    public YuinResultDto<Ps02003RspDto> ps02003(@RequestBody @Validated YuinRequestDto<Ps02003ReqDto> yuinRequestDto) {
        try {
            this.validateRequest(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS02001Service.PS02003(yuinRequestDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private YuinResultDto handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        Ps02001RspDto rspDto = new Ps02001RspDto("0", errCode, errMsg);
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        yuinResultDto.setHead(head);
        yuinResultDto.setBody((Object)rspDto);
        return yuinResultDto;
    }

    private void validateRequestDto(YuinRequestDto<Ps02001ReqDto> yuinRequestDto) {
        Ps02001ReqDto ps02001ReqDto = (Ps02001ReqDto)yuinRequestDto.getBody();
        try {
            ValidatorUtils.validate((Object)ps02001ReqDto, (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        if (!StringUtils.containsAny((CharSequence)ps02001ReqDto.getOpertype(), (CharSequence[])new CharSequence[]{"1", "2", "3", "4"})) {
            throw new BizBaseException(PSErrorMsg.PS000003.getErrCode(), PSErrorMsg.PS000003.getErrMsg(), new Object[0]);
        }
        if (StringUtils.containsAny((CharSequence)ps02001ReqDto.getOpertype(), (CharSequence[])new CharSequence[]{"1", "2", "3"}) && StringUtils.isBlank((CharSequence)ps02001ReqDto.getClearbrno())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
        if (StringUtils.containsAny((CharSequence)ps02001ReqDto.getOpertype(), (CharSequence[])new CharSequence[]{"1", "2"}) && StringUtils.isBlank((CharSequence)ps02001ReqDto.getCorpaccno())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
        if (StringUtils.containsAny((CharSequence)ps02001ReqDto.getOpertype(), (CharSequence[])new CharSequence[]{"1", "2", "3"}) && StringUtils.isBlank((CharSequence)ps02001ReqDto.getPostaccno())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
        if (StringUtils.containsAny((CharSequence)ps02001ReqDto.getOpertype(), (CharSequence[])new CharSequence[]{"1", "2"}) && StringUtils.isBlank((CharSequence)ps02001ReqDto.getPostype())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
        if (StringUtils.containsAny((CharSequence)ps02001ReqDto.getOpertype(), (CharSequence[])new CharSequence[]{"1", "2"}) && StringUtils.isBlank((CharSequence)ps02001ReqDto.getPosname())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
        if (StringUtils.containsAny((CharSequence)ps02001ReqDto.getOpertype(), (CharSequence[])new CharSequence[]{"1", "2"}) && StringUtils.isBlank((CharSequence)ps02001ReqDto.getStatus())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
        if (StringUtils.containsAny((CharSequence)ps02001ReqDto.getOpertype(), (CharSequence[])new CharSequence[]{"1", "2"}) && StringUtils.isBlank((CharSequence)ps02001ReqDto.getCurcode())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
    }

    private void validateRequest(YuinRequestDto<Ps02003ReqDto> yuinRequestDto) {
        Ps02003ReqDto ps02003ReqDto = (Ps02003ReqDto)yuinRequestDto.getBody();
        try {
            ValidatorUtils.validate((Object)ps02003ReqDto, (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)ps02003ReqDto.getPostype())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
    }
}

