/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.NumberUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps04003.Ps04003ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps04003.Ps04003RspDtlDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps04003.Ps04003RspDto;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDCorpaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMPostcaljnlRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDCorpaccbookVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMPostcaljnlVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS04003Service {
    private static final Logger log = LoggerFactory.getLogger(PS04003Service.class);
    @Autowired
    private PsDCorpaccbookRepo psDCorpaccbookRepo;
    @Autowired
    private PsMPostcaljnlRepo psMPostcaljnlRepo;
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;

    public YuinResultDto<Ps04003RspDto> ps04003(YuinRequestDto<Ps04003ReqDto> yuinRequestDto) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(head);
        Ps04003RspDto rspBodyDto = new Ps04003RspDto();
        YuinRequestHead header = yuinRequestDto.getSysHead();
        String headerBrNo = header.getBrno();
        if (!this.psDBranchadmRepo.isBranchCanOperate(headerBrNo)) {
            throw new BizBaseException(PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg(), new Object[0]);
        }
        Ps04003ReqDto requestDtoBody = (Ps04003ReqDto)yuinRequestDto.getBody();
        String postType = requestDtoBody.getPostType();
        String workDate = requestDtoBody.getWorkDate();
        boolean isTopBranch = this.psDBranchadmRepo.isTopBranch(headerBrNo);
        if (!isTopBranch) {
            throw new BizBaseException(PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg(), new Object[0]);
        }
        List corpaccbookVoList = this.psDCorpaccbookRepo.getAllCorpAccBookList();
        ArrayList<Ps04003RspDtlDto> list = new ArrayList<Ps04003RspDtlDto>();
        Ps04003RspDtlDto dtlDto = null;
        if (StringUtils.isBlank((String)postType)) {
            for (PsDCorpaccbookVo corpaccbookVo : corpaccbookVoList) {
                dtlDto = new Ps04003RspDtlDto();
                if ("02".equals(corpaccbookVo.getPostype())) {
                    dtlDto.setPosTypeName("\u4eba\u6c11\u94f6\u884c");
                } else {
                    if (!"03".equals(corpaccbookVo.getPostype())) continue;
                    dtlDto.setPosTypeName("\u519c\u4fe1\u94f6");
                }
                dtlDto.setWorkDate(workDate);
                dtlDto.setPostAccNo(corpaccbookVo.getPostaccno());
                dtlDto.setPosName(corpaccbookVo.getPosname());
                IPage page = this.psMPostcaljnlRepo.getLatestPostCalJnlList(Long.valueOf(1L), Long.valueOf(1L), workDate, corpaccbookVo.getPostaccno());
                List dbList = page.getRecords();
                if (ObjectUtils.isNotEmpty((Object)dbList) && dbList.size() > 0) {
                    PsMPostcaljnlVo postcaljnlVo = (PsMPostcaljnlVo)dbList.get(0);
                    dtlDto.setCrAmt(NumberUtils.nullDefaultZero((Number)postcaljnlVo.getActualcramt()).toString());
                    dtlDto.setDrAmt(NumberUtils.nullDefaultZero((Number)postcaljnlVo.getActualdramt()).toString());
                    dtlDto.setNettingAmt(NumberUtils.nullDefaultZero((Number)postcaljnlVo.getActualntamt()).toString());
                }
                list.add(dtlDto);
            }
        } else {
            for (PsDCorpaccbookVo corpaccbookVo : corpaccbookVoList) {
                if (!postType.equals(corpaccbookVo.getPostype())) continue;
                dtlDto = new Ps04003RspDtlDto();
                if ("02".equals(corpaccbookVo.getPostype())) {
                    dtlDto.setPosTypeName("\u4eba\u6c11\u94f6\u884c");
                } else {
                    if (!"03".equals(corpaccbookVo.getPostype())) continue;
                    dtlDto.setPosTypeName("\u519c\u4fe1\u94f6");
                }
                dtlDto.setWorkDate(workDate);
                dtlDto.setPostAccNo(corpaccbookVo.getPostaccno());
                dtlDto.setPosName(corpaccbookVo.getPosname());
                IPage page = this.psMPostcaljnlRepo.getLatestPostCalJnlList(Long.valueOf(1L), Long.valueOf(1L), workDate, corpaccbookVo.getPostaccno());
                List dbList = page.getRecords();
                if (ObjectUtils.isNotEmpty((Object)dbList) && dbList.size() > 0) {
                    PsMPostcaljnlVo postcaljnlVo = (PsMPostcaljnlVo)dbList.get(0);
                    dtlDto.setCrAmt(NumberUtils.nullDefaultZero((Number)postcaljnlVo.getActualcramt()).toString());
                    dtlDto.setDrAmt(NumberUtils.nullDefaultZero((Number)postcaljnlVo.getActualdramt()).toString());
                    dtlDto.setNettingAmt(NumberUtils.nullDefaultZero((Number)postcaljnlVo.getActualntamt()).toString());
                }
                list.add(dtlDto);
                break;
            }
        }
        if (list != null) {
            head.setTotalSize((long)list.size());
        } else {
            head.setTotalSize(0L);
        }
        rspBodyDto.setList(list);
        rspBodyDto.setStatus("1");
        rspBodyDto.setErrcode(head.getResponseCode());
        rspBodyDto.setErrmsg(head.getResponseMsg());
        yuinResultDto.setBody((Object)rspBodyDto);
        return yuinResultDto;
    }
}

