/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.NumberUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps04002.Ps04002ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps04002.Ps04002RspDtlDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps04002.Ps04002RspDto;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDCorpaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDCorpaccbookVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS04002Service {
    private static final Logger log = LoggerFactory.getLogger(PS04002Service.class);
    @Autowired
    private PsDCorpaccbookRepo psDCorpaccbookRepo;
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;

    public YuinResultDto<Ps04002RspDto> ps04002(YuinRequestDto<Ps04002ReqDto> yuinRequestDto) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(head);
        Ps04002RspDto rspBodyDto = new Ps04002RspDto();
        YuinRequestHead header = yuinRequestDto.getSysHead();
        String headerBrNo = header.getBrno();
        if (!this.psDBranchadmRepo.isBranchCanOperate(headerBrNo)) {
            throw new BizBaseException(PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg(), new Object[0]);
        }
        Ps04002ReqDto requestDtoBody = (Ps04002ReqDto)yuinRequestDto.getBody();
        boolean isTopBranch = this.psDBranchadmRepo.isTopBranch(headerBrNo);
        if (!isTopBranch) {
            throw new BizBaseException(PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg(), new Object[0]);
        }
        List corpaccbookVoList = this.psDCorpaccbookRepo.getAllCorpAccBookList();
        ArrayList<Ps04002RspDtlDto> list = new ArrayList<Ps04002RspDtlDto>();
        Ps04002RspDtlDto dtlDto = null;
        for (PsDCorpaccbookVo corpaccbookVo : corpaccbookVoList) {
            dtlDto = new Ps04002RspDtlDto();
            if ("02".equals(corpaccbookVo.getPostype()) || "01".equals(corpaccbookVo.getPostype())) {
                dtlDto.setPosTypeName("\u4eba\u6c11\u94f6\u884c");
            } else if ("03".equals(corpaccbookVo.getPostype())) {
                dtlDto.setPosTypeName("\u519c\u4fe1\u94f6");
            }
            dtlDto.setPosName(corpaccbookVo.getPosname());
            dtlDto.setPostAccNo(corpaccbookVo.getPostaccno());
            dtlDto.setPosAccAmt(NumberUtils.nullDefaultZero((Number)corpaccbookVo.getBanktodaybal()).toString());
            list.add(dtlDto);
        }
        if (list != null) {
            head.setTotalSize((long)list.size());
        } else {
            head.setTotalSize(0L);
        }
        rspBodyDto.setList(list);
        rspBodyDto.setStatus("1");
        rspBodyDto.setErrcode(head.getResponseCode());
        rspBodyDto.setErrmsg(head.getResponseMsg());
        yuinResultDto.setBody((Object)rspBodyDto);
        return yuinResultDto;
    }
}

