/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps03001.Ps03001DtelRspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03008.Ps03008ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03008.Ps03008RspDto;
import cn.com.yusys.yusp.pay.position.domain.repo.PsBPostpredbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMWrtoffinlRepo;
import cn.com.yusys.yusp.pay.position.domain.service.PsDBranchadmDomainService;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsBPostpredbookQueryVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsBPostpredbookVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBranchadmVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMWrtoffinlVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS03008Service {
    @Autowired
    private PsBPostpredbookRepo ps03001Repo;
    @Autowired
    private PsMWrtoffinlRepo ps0300Repo;
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;
    @Autowired
    private PsDBranchadmDomainService psDBranchadmDomainService;
    private static final Logger log = LoggerFactory.getLogger(PS03008Service.class);

    public YuinResultDto ps03008(YuinRequestDto<Ps03008ReqDto> yuinRequestDto) {
        Ps03008ReqDto ps03008ReqDto = (Ps03008ReqDto)yuinRequestDto.getBody();
        String funcType = ps03008ReqDto.getFunctype();
        String tellerNo = yuinRequestDto.getSysHead().getTellerno();
        String brNo = yuinRequestDto.getSysHead().getBrno();
        YuinRequestDto request = new YuinRequestDto();
        request.setSysHead(yuinRequestDto.getSysHead());
        request.setBody(BeanUtils.beanCopy((Object)ps03008ReqDto, PsBPostpredbookVo.class));
        PsBPostpredbookQueryVo queryVo = (PsBPostpredbookQueryVo)BeanUtils.beanCopy((Object)yuinRequestDto.getBody(), PsBPostpredbookQueryVo.class);
        queryVo.setPage(Long.valueOf(yuinRequestDto.getSysHead().getPageNum().intValue()));
        queryVo.setSize(Long.valueOf(yuinRequestDto.getSysHead().getPageSize().intValue()));
        YuinResultDto resultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        resultDto.setHead(head);
        try {
            switch (funcType) {
                case "1": {
                    resultDto.setBody((Object)this.doQuery(queryVo, tellerNo, brNo, head));
                    break;
                }
                case "2": {
                    resultDto.setBody((Object)this.doUpdate(ps03008ReqDto, "2", tellerNo, brNo));
                    break;
                }
                case "3": {
                    resultDto.setBody((Object)this.doUpdate(ps03008ReqDto, "3", tellerNo, brNo));
                    break;
                }
                default: {
                    resultDto.setBody((Object)new Ps03008RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000002.getErrMsg()));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.toString());
            resultDto.setBody((Object)new Ps03008RspDto("0", PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg()));
        }
        if (!"1".equals(((Ps03008RspDto)resultDto.getBody()).getStatus())) {
            head.setResponseCode(((Ps03008RspDto)resultDto.getBody()).getErrcode());
            head.setResponseMsg(((Ps03008RspDto)resultDto.getBody()).getErrmsg());
        }
        return resultDto;
    }

    private Ps03008RspDto doUpdate(Ps03008ReqDto ps03008ReqDto, String funcType, String tellerNo, String brNo) {
        PsBPostpredbookVo dataVo = (PsBPostpredbookVo)BeanUtils.beanCopy((Object)ps03008ReqDto, PsBPostpredbookVo.class);
        BigDecimal wrtoffbal = ps03008ReqDto.getWrtoffbal();
        BigDecimal wrtoffamt = "3".equals(funcType) ? wrtoffbal : ps03008ReqDto.getWrtoffamt();
        PsDBranchadmVo psDBranchadmVo = this.psDBranchadmRepo.getBranchInfoByBrNo(brNo);
        if (!"41".equals(psDBranchadmVo.getOrgtype())) {
            return new Ps03008RspDto("0", PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg());
        }
        if (!this.psDBranchadmDomainService.juageSuperBrno(brNo, dataVo.getBrno()).booleanValue()) {
            return new Ps03008RspDto("0", PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg());
        }
        if (!("05".equals(dataVo.getPredstatus()) || "07".equals(dataVo.getPredstatus()) || "09".equals(dataVo.getPredstatus()))) {
            return new Ps03008RspDto("0", PSErrorMsg.PS030002.getErrCode(), PSErrorMsg.PS030002.getErrMsg());
        }
        if (!"01".equals(dataVo.getWrtoffstatus()) && !"02".equals(dataVo.getWrtoffstatus())) {
            return new Ps03008RspDto("0", PSErrorMsg.PS030002.getErrCode(), PSErrorMsg.PS030002.getErrMsg());
        }
        if (wrtoffbal.compareTo(wrtoffamt) <= 0) {
            dataVo.setWrtofftype("02");
            dataVo.setWrtoffstatus("03");
        } else {
            dataVo.setWrtofftype("02");
            dataVo.setWrtoffstatus("02");
        }
        if ("2".equals(funcType)) {
            dataVo.setWrtoffbal(wrtoffbal.subtract(wrtoffamt));
        } else {
            dataVo.setWrtoffbal(BigDecimal.valueOf(0L));
        }
        this.ps03001Repo.doUpdate(dataVo);
        PsMWrtoffinlVo wrtoff = new PsMWrtoffinlVo();
        wrtoff.setAccno(dataVo.getAccno());
        wrtoff.setBrno(dataVo.getBrno());
        wrtoff.setAppid("PS");
        wrtoff.setOrigworkdate(ps03008ReqDto.getOrigworkdate());
        wrtoff.setOrigworkseqid(ps03008ReqDto.getOrigworkseqid());
        wrtoff.setPmtdrt(dataVo.getPmtdrt());
        wrtoff.setPreddate(dataVo.getPreddate());
        wrtoff.setPredno(dataVo.getPredno());
        wrtoff.setPredworkdate(dataVo.getWorkdate());
        wrtoff.setSysid("PS");
        wrtoff.setWorkdate(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT));
        wrtoff.setWrtoffseqno(SequenceUtils.getSequence((String)"bankseqno"));
        wrtoff.setWrtofftellerno(tellerNo);
        wrtoff.setWrtofftype("2");
        if ("2".equals(funcType)) {
            wrtoff.setWrtoffamt(wrtoffamt);
            wrtoff.setWrtoffbal(wrtoffbal.subtract(wrtoffamt));
        } else {
            wrtoff.setWrtoffamt(wrtoffbal);
            wrtoff.setWrtoffbal(new BigDecimal("0"));
        }
        this.ps0300Repo.save(wrtoff);
        return new Ps03008RspDto("1", "", "");
    }

    private Ps03008RspDto doQuery(PsBPostpredbookQueryVo dataVo, String tellerNo, String brNo, YuinResultHead head) {
        if ("01".equals(dataVo.getBrnotype()) || "02".equals(dataVo.getBrnotype())) {
            dataVo.setBrno(brNo);
        } else if (!this.psDBranchadmDomainService.juageSuperBrno(brNo, dataVo.getBrno()).booleanValue()) {
            return new Ps03008RspDto("0", PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg());
        }
        IPage pageData = this.ps03001Repo.doQuery(dataVo).convert(po -> (Ps03001DtelRspDto)BeanUtils.beanCopy((Object)po, Ps03001DtelRspDto.class));
        Ps03008RspDto ps03008RspDto = new Ps03008RspDto("1", "", "");
        ArrayList<Ps03001DtelRspDto> reList = new ArrayList<Ps03001DtelRspDto>();
        for (Ps03001DtelRspDto po2 : pageData.getRecords()) {
            po2.setWrtoffamt(po2.getAmt().subtract(po2.getWrtoffbal()));
            po2.setBrnoName(this.psDBranchadmRepo.getBranchInfoByBrNo(po2.getBrno()).getBrname());
            reList.add(po2);
        }
        pageData.setRecords(reList);
        ps03008RspDto.setList(pageData.getRecords());
        head.setTotalSize(pageData.getTotal());
        return ps03008RspDto;
    }
}

