/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps03006.Ps03006DtelRspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03006.Ps03006ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03006.Ps03006RspDto;
import cn.com.yusys.yusp.pay.position.domain.repo.PsBCtypostcaljnlRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsBCtyspecbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsBPostpredbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBankaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.service.PsDBranchadmDomainService;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsBCtypostcaljnlVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsBCtyspecbookVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBankaccbookVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS03006Service {
    @Autowired
    private PsBCtypostcaljnlRepo ps03006Repo;
    @Autowired
    private PsDBankaccbookRepo psDBankaccbookRepo;
    @Autowired
    private PsBPostpredbookRepo psBPostpredbookRepo;
    @Autowired
    private PsBCtyspecbookRepo psBCtyspecbookRepo;
    @Autowired
    private PsDBranchadmDomainService psDBranchadmDomainService;
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;

    public YuinResultDto ps03006(YuinRequestDto<Ps03006ReqDto> yuinRequestDto) {
        String workdate = ((Ps03006ReqDto)yuinRequestDto.getBody()).getWorkdate();
        String brNo = ((Ps03006ReqDto)yuinRequestDto.getBody()).getBrno();
        String headBrno = yuinRequestDto.getSysHead().getBrno();
        BigDecimal pre = new BigDecimal("0");
        YuinResultDto resultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        head.setTotalSize(0L);
        if (!headBrno.equals(brNo) && !this.psDBranchadmDomainService.juageSuperBrno(headBrno, brNo).booleanValue()) {
            resultDto.setBody((Object)new Ps03006RspDto("0", PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg()));
            if (!"1".equals(((Ps03006RspDto)resultDto.getBody()).getStatus())) {
                head.setResponseCode(((Ps03006RspDto)resultDto.getBody()).getErrcode());
                head.setResponseMsg(((Ps03006RspDto)resultDto.getBody()).getErrmsg());
            }
            resultDto.setHead(head);
            return resultDto;
        }
        if (this.psDBranchadmRepo.isTopBranch(brNo)) {
            resultDto.setBody((Object)new Ps03006RspDto("0", PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg()));
            if (!"1".equals(((Ps03006RspDto)resultDto.getBody()).getStatus())) {
                head.setResponseCode(((Ps03006RspDto)resultDto.getBody()).getErrcode());
                head.setResponseMsg(((Ps03006RspDto)resultDto.getBody()).getErrmsg());
            }
            resultDto.setHead(head);
            return resultDto;
        }
        LocalTime time = LocalTime.now();
        DateTimeFormatter formater = DateTimeFormatter.ofPattern("HHmmss");
        PsBCtypostcaljnlVo postcalVo = new PsBCtypostcaljnlVo();
        postcalVo.setWorkdate(workdate);
        if (!DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT).equals(workdate)) {
            postcalVo = this.ps03006Repo.getdataOne(workdate, brNo);
        } else {
            postcalVo.setWorkseqid(SequenceUtils.getSequence((String)"bankseqno"));
            postcalVo.setWorktime(time.format(formater));
            postcalVo.setSysid("PS");
            postcalVo.setAppid("PS");
            postcalVo.setBrno(brNo);
            postcalVo.setCurcode("01");
            PsDBankaccbookVo psDBankaccbookVo = new PsDBankaccbookVo();
            psDBankaccbookVo.setClearbrno(brNo);
            psDBankaccbookVo.setAcctype("01");
            psDBankaccbookVo.setStatus("1");
            List list = this.psDBankaccbookRepo.getAllByBean(psDBankaccbookVo);
            if (list.size() == 0) {
                resultDto.setBody((Object)new Ps03006RspDto("0", PSErrorMsg.PS030004.getErrCode(), PSErrorMsg.PS030004.getErrMsg()));
                head.setResponseCode(((Ps03006RspDto)resultDto.getBody()).getErrcode());
                head.setResponseMsg(((Ps03006RspDto)resultDto.getBody()).getErrmsg());
                resultDto.setHead(head);
                return resultDto;
            }
            PsDBankaccbookVo accVo = (PsDBankaccbookVo)list.get(0);
            postcalVo.setPostaccno(accVo.getPostaccno());
            Map map = this.psBPostpredbookRepo.getPostpredSum(workdate, brNo);
            postcalVo.setProvpred((BigDecimal)map.get("predAmt"));
            postcalVo.setProvwrtoff(((BigDecimal)map.get("predAmt")).subtract((BigDecimal)map.get("wrtoffbal")));
            pre = (BigDecimal)map.get("wrtoffbal");
            PsBCtyspecbookVo psBCtyspecbookVo = new PsBCtyspecbookVo();
            psBCtyspecbookVo.setBrno(brNo);
            psBCtyspecbookVo.setWorkdate(workdate);
            PsBCtyspecbookVo specbookVo = this.psBCtyspecbookRepo.doQuery(psBCtyspecbookVo);
            if (specbookVo == null) {
                resultDto.setBody((Object)new Ps03006RspDto("0", PSErrorMsg.PS030003.getErrCode(), PSErrorMsg.PS030003.getErrMsg()));
                head.setResponseCode(((Ps03006RspDto)resultDto.getBody()).getErrcode());
                head.setResponseMsg(((Ps03006RspDto)resultDto.getBody()).getErrmsg());
                resultDto.setHead(head);
                return resultDto;
            }
            postcalVo.setPredadjamt(specbookVo.getPredadjamt());
            postcalVo.setFinanceadjamt(specbookVo.getFinanceadjamt());
            postcalVo.setFinancepaycoll(specbookVo.getFinancepaycoll());
            postcalVo.setCashpaycoll(specbookVo.getCashpaycoll());
            postcalVo.setLoanenjapay(specbookVo.getLoanenjapay());
            postcalVo.setTrealibtax(specbookVo.getTrealibtax());
            postcalVo.setBankrefin(specbookVo.getBankrefin());
            postcalVo.setTagliqu(specbookVo.getTagliqu());
            postcalVo.setPredplanres(specbookVo.getPredplanres());
            BigDecimal todayamtgap = postcalVo.getProvbal().subtract(postcalVo.getPredadjamt()).subtract(postcalVo.getFinanceadjamt()).subtract(postcalVo.getFinancepaycoll()).subtract(postcalVo.getCashpaycoll()).subtract(postcalVo.getLoanenjapay()).subtract(pre).subtract(postcalVo.getTrealibtax()).add(postcalVo.getBankrefin()).subtract(postcalVo.getTagliqu());
            postcalVo.setTodayamtgap(todayamtgap);
            this.ps03006Repo.save(postcalVo);
        }
        Ps03006DtelRspDto ps03006DtelRspDto = new Ps03006DtelRspDto();
        ArrayList<Ps03006DtelRspDto> rspDtoList = new ArrayList<Ps03006DtelRspDto>();
        if (postcalVo != null) {
            BeanUtils.beanCopy((Object)postcalVo, (Object)ps03006DtelRspDto);
            rspDtoList.add(ps03006DtelRspDto);
            head.setTotalSize(1L);
        }
        Ps03006RspDto ps03006RspDto = new Ps03006RspDto("1", "", "");
        ps03006RspDto.setList(rspDtoList);
        resultDto.setBody((Object)ps03006RspDto);
        if (!"1".equals(((Ps03006RspDto)resultDto.getBody()).getStatus())) {
            head.setResponseCode(((Ps03006RspDto)resultDto.getBody()).getErrcode());
            head.setResponseMsg(((Ps03006RspDto)resultDto.getBody()).getErrmsg());
        }
        resultDto.setHead(head);
        return resultDto;
    }
}

