/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps10101.Ps10101ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps10101.Ps10101RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS10101Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS10001"})
@RestController
public class PS10101Resource {
    @Autowired
    private PS10101Service pS10101Service;

    @ApiOperation(value="\u7cfb\u7edf\u53c2\u6570\u65b0\u589e")
    @PostMapping(value={"/api/payment/ps/ps10101"})
    public YuinResultDto<Ps10101RspDto> ps10101(@RequestBody @Validated YuinRequestDto<Ps10101ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS10101Service.ps10001(yuinRequestDto);
        }
        catch (Exception e) {
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps10101ReqDto> yuinRequestDto) {
        boolean isnul;
        Ps10101ReqDto ps10101ReqDto = (Ps10101ReqDto)yuinRequestDto.getBody();
        try {
            ValidatorUtils.validate((Object)ps10101ReqDto, (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        boolean bl = isnul = StringUtils.isBlank((CharSequence)ps10101ReqDto.getParamcode()) || StringUtils.isBlank((CharSequence)ps10101ReqDto.getParaname()) || StringUtils.isBlank((CharSequence)ps10101ReqDto.getParavalue()) || StringUtils.isBlank((CharSequence)ps10101ReqDto.getDescribed()) || StringUtils.isBlank((CharSequence)ps10101ReqDto.getTrandcode()) || StringUtils.isBlank((CharSequence)ps10101ReqDto.getEffectflag()) || StringUtils.isBlank((CharSequence)ps10101ReqDto.getDelflag());
        if (isnul) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
    }

    @ApiOperation(value="\u7cfb\u7edf\u53c2\u6570\u4fee\u6539")
    @PostMapping(value={"/api/payment/ps/ps10102"})
    public YuinResultDto<Ps10101RspDto> ps10102(@RequestBody @Validated YuinRequestDto<Ps10101ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS10101Service.ps10002(yuinRequestDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    @ApiOperation(value="\u7cfb\u7edf\u53c2\u6570\u5220\u9664")
    @PostMapping(value={"/api/payment/ps/ps10103"})
    public YuinResultDto<Ps10101RspDto> ps10103(@RequestBody @Validated YuinRequestDto<Ps10101ReqDto> yuinRequestDto) {
        try {
            this.validateps10103RequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS10101Service.ps10003(yuinRequestDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateps10103RequestDto(YuinRequestDto<Ps10101ReqDto> yuinRequestDto) {
        Ps10101ReqDto ps10101ReqDto = (Ps10101ReqDto)yuinRequestDto.getBody();
        try {
            ValidatorUtils.validate((Object)ps10101ReqDto, (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        boolean isnul = StringUtils.isBlank((CharSequence)ps10101ReqDto.getParamcode());
        if (isnul) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
    }

    @ApiOperation(value="\u7cfb\u7edf\u53c2\u6570\u67e5\u8be2")
    @PostMapping(value={"/api/payment/ps/ps10104"})
    public YuinResultDto<Ps10101RspDto> ps10104(@RequestBody @Validated YuinRequestDto<Ps10101ReqDto> yuinRequestDto) {
        try {
            ValidatorUtils.validate((Object)yuinRequestDto.getBody(), (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS10101Service.ps10004(yuinRequestDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private YuinResultDto handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        Ps10101RspDto rspDto = new Ps10101RspDto("0", errCode, errMsg);
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        yuinResultDto.setHead(head);
        yuinResultDto.setBody((Object)rspDto);
        return yuinResultDto;
    }
}

