/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.outcenter.service;

import cn.com.yusys.yusp.bsp.communication.BspTemplate;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.commons.exception.PlatformException;
import cn.com.yusys.yusp.pay.common.base.util.RedisUtil;
import cn.com.yusys.yusp.pay.common.outcenter.code.EComType;
import cn.com.yusys.yusp.pay.common.outcenter.domain.repo.OutDataFormatRepo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.repo.OutDealRepo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.repo.SaveCostjnlRepo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.repo.UoPExpandmapRepo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.repo.UoPOuttradeMapRepo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.repo.UoPmoduleRepo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.vo.UoPExpandmapVo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.vo.UoPModuleinfoVo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.vo.UoPOuttrademapVo;
import cn.com.yusys.yusp.pay.common.outcenter.expand.SchemaValidatorComm;
import cn.com.yusys.yusp.pay.common.outcenter.util.LoggerUtil;
import com.alibaba.fastjson.JSON;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public abstract class OutService {
    public static final Logger logger = LoggerFactory.getLogger(OutService.class);
    public String modulecode = "out";
    public String outDataFormatName = "outDataFormatRepo";
    public String outDealName = "outDealRepo";
    @Autowired
    public ApplicationContext applicationContext;
    @Autowired
    public UoPmoduleRepo uoPmoduleRepo;
    @Autowired
    public UoPOuttradeMapRepo uUoPOuttradeMapRepo;
    @Autowired
    public UoPExpandmapRepo uoPExpandmapRepo;
    @Autowired
    public SaveCostjnlRepo saveCostjnlRepo;
    @Autowired
    public RedisUtil redisUtil;
    @Value(value="${payment.msgidname:msgid}")
    public String msgidname;
    @Value(value="${UPP.appid}")
    private String appid;

    public OutService(String modulecode, String outDataFormatName, String outDealName) {
        this.modulecode = modulecode;
        this.outDataFormatName = outDataFormatName;
        this.outDealName = outDealName;
    }

    public void outService(Map<String, Object> request) throws Exception {
        request.put(EComType.MODULE_CODE.getCode(), this.modulecode);
        LoggerUtil.logger(request, EComType.ATTR_REQUEST_DATA.getName() + ":" + JSON.toJSONString(request));
        LoggerUtil.logger(request, EComType.MODULE_OUT_NAME.getCode() + EComType.START.getName());
        OutDataFormatRepo outDataFormatRepo = (OutDataFormatRepo)this.applicationContext.getBean(this.outDataFormatName);
        OutDealRepo outDealRepo = (OutDealRepo)this.applicationContext.getBean(this.outDealName);
        try {
            LocalDateTime startTime = LocalDateTime.now();
            request.put(EComType.APP_ID.getCode(), this.appid);
            request.put(EComType.SYS_ID.getCode(), EComType.UPP.getCode());
            LoggerUtil.logger(request, "sysid:" + EComType.UPP.getCode());
            LoggerUtil.logger(request, "appid:" + this.appid);
            LoggerUtil.logger(request, EComType.MODULE_MESSAGE.getName());
            UoPModuleinfoVo uoPModuleinfoVo = this.uoPmoduleRepo.getModuleInfo(this.modulecode, request.get(EComType.SYS_ID.getCode()).toString(), request.get(EComType.APP_ID.getCode()).toString());
            String errmsg = null;
            if (uoPModuleinfoVo == null) {
                errmsg = EComType.ERR_MODULE_STATUS.getName();
                throw new Exception(errmsg);
            }
            outDealRepo.chkModule(uoPModuleinfoVo);
            LoggerUtil.logger(request, EComType.TRADE_MAP.getName());
            String msgtype = request.getOrDefault(EComType.MSG_TYPD.getCode(), "").toString();
            LoggerUtil.logger(request, "msgtype:" + msgtype);
            UoPOuttrademapVo uoPOuttrademapVo = this.uUoPOuttradeMapRepo.getUoPIntrademap(this.modulecode, msgtype, request.get(EComType.SYS_ID.getCode()).toString(), request.get(EComType.APP_ID.getCode()).toString());
            if (uoPOuttrademapVo == null) {
                errmsg = EComType.ERR_MODULE_STATUS.getName();
                throw new Exception(errmsg);
            }
            request.put(EComType.TREAD_CODE.getCode(), uoPOuttrademapVo.getReqtradecode());
            request.put(EComType.TREAD_NAME.getCode(), uoPOuttrademapVo.getReqtradename());
            boolean flag = outDealRepo.chktradestatus(uoPOuttrademapVo);
            if (!flag) {
                errmsg = EComType.ERR_OUT_DISABLED.getName();
                throw new Exception(errmsg);
            }
            Session session = (Session)request.get(EComType.T_SESSION.getCode());
            String startWithCommOut = EComType.COMM_OUT.getCode() + this.modulecode;
            if (session == null) {
                session = new Session();
                session.setModuleName(startWithCommOut);
                session.setContext(request);
                session.getContext().put(EComType.T_SESSION.getCode(), session);
            }
            outDealRepo.chkSignature(request, uoPOuttrademapVo);
            LoggerUtil.logger(request, EComType.EXPAND.getName());
            UoPExpandmapVo uoPExpandmap = this.uoPExpandmapRepo.getUoPExpandmap(this.modulecode, msgtype, request.get(EComType.SYS_ID.getCode()).toString(), request.get(EComType.APP_ID.getCode()).toString());
            if (uoPExpandmap != null) {
                String xmlns = uoPExpandmap.getXmlns();
                LoggerUtil.logger(request, "xmlns:" + xmlns);
                String xsivalue = uoPExpandmap.getXsivalue();
                LoggerUtil.logger(request, "xsivalue:" + xsivalue);
                String schemalocation = uoPExpandmap.getSchemalocation();
                LoggerUtil.logger(request, "schemalocation:" + schemalocation);
                String xsdfilename = uoPExpandmap.getXsdfilename();
                LoggerUtil.logger(request, "xsdfilename:" + xsdfilename);
                if (StringUtils.isNotEmpty((CharSequence)xmlns)) {
                    request.put(EComType.XML_NS.getCode(), xmlns);
                }
                if (StringUtils.isNotEmpty((CharSequence)xsivalue)) {
                    request.put(EComType.XSI_VALUE.getCode(), xsivalue);
                }
                if (StringUtils.isNotEmpty((CharSequence)schemalocation)) {
                    request.put(EComType.SCHEMA_LOCATION.getCode(), schemalocation);
                }
                if (StringUtils.isNotEmpty((CharSequence)xsdfilename)) {
                    request.put(EComType.XSD_FILE_NAME.getCode(), xsdfilename);
                }
            }
            outDataFormatRepo.packMsg(request, uoPOuttrademapVo.getReqmsgtype());
            String msgchkflag = uoPOuttrademapVo.getMsgchkflag();
            LoggerUtil.logger(request, "msgchkflag:" + msgchkflag);
            if (EComType.MSG_CHK_FLAG.getCode().equals(msgchkflag)) {
                LoggerUtil.logger(request, EComType.MSG_CHK_FLAG.getName());
                SchemaValidatorComm schemaValidatorComm = new SchemaValidatorComm();
                byte[] data = (byte[])request.get(EComType.ATTR_RESPONSE_DATA.getCode());
                flag = schemaValidatorComm.executeComponent(data, msgtype, request);
                if (!flag) {
                    errmsg = EComType.ERR_SCHEMA.getName();
                    throw new Exception(errmsg);
                }
            }
            request.remove(request.get(EComType.T_SESSION.getCode()));
            outDealRepo.saveContent(uoPModuleinfoVo, request);
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put(EComType.ATTR_RESPONSE_DATA.getCode(), request.get(EComType.ATTR_RESPONSE_DATA.getCode()));
            info.put(EComType.SERVICE_CODE.getCode(), request.get(EComType.SERVICE_CODE.getCode()));
            if (EComType.COST_FLAG.getCode().equals(uoPModuleinfoVo.getCostflag())) {
                LoggerUtil.logger(request, EComType.COST_FLAG.getName());
                LocalDateTime endTime = LocalDateTime.now();
                this.saveCostjnlRepo.saveCostjnl(startTime, endTime, request.getOrDefault(EComType.COMMO_SGID.getCode(), "").toString(), request.getOrDefault(EComType.ORIG_RECV_ID.getCode(), "").toString());
            }
            outDealRepo.sendMsg(request, info);
        }
        catch (Exception e) {
            String errmsg = e.getMessage();
            if (errmsg.contains("New resource exception, resource type")) {
                LoggerUtil.logger(request, EComType.ERR_NO_FILE.getName());
                LoggerUtil.logger(request, this.modulecode + EComType.END.getName());
            }
            e.printStackTrace();
            outDealRepo.returnError(request, errmsg);
            LoggerUtil.logger(request, EComType.ERR_OUT.getName() + ":" + errmsg);
        }
        LoggerUtil.logger(request, EComType.MODULE_OUT_NAME.getCode() + EComType.END.getName());
    }

    public void outRspService(Map<String, Object> request) throws Exception {
        try {
            LocalDateTime startTime = LocalDateTime.now();
            OutDataFormatRepo outDataFormatRepo = (OutDataFormatRepo)this.applicationContext.getBean(this.outDataFormatName);
            OutDealRepo outDealRepo = (OutDealRepo)this.applicationContext.getBean(this.outDealName);
            UoPModuleinfoVo uoPModuleinfoVo = this.uoPmoduleRepo.getModuleInfo(this.modulecode, request.get(EComType.SYS_ID.getCode()).toString(), request.get(EComType.APP_ID.getCode()).toString());
            String errmsg = null;
            if (uoPModuleinfoVo == null) {
                errmsg = EComType.ERR_MODULE_STATUS.getName();
                outDealRepo.returnError(request, errmsg);
                throw new Exception(errmsg);
            }
            outDealRepo.chkModule(uoPModuleinfoVo);
            String msgtype = request.getOrDefault(EComType.MSG_TYPD.getCode(), "").toString();
            UoPOuttrademapVo uoPOuttrademapVo = this.uUoPOuttradeMapRepo.getUoPIntrademap(this.modulecode, msgtype, request.get(EComType.SYS_ID.getCode()).toString(), request.get(EComType.APP_ID.getCode()).toString());
            if (uoPOuttrademapVo == null) {
                errmsg = EComType.ERR_MODULE_STATUS.getName();
                outDealRepo.returnError(request, errmsg);
                throw new Exception(errmsg);
            }
            boolean flag = outDealRepo.chktradestatus(uoPOuttrademapVo);
            if (!flag) {
                errmsg = EComType.ERR_OUT_DISABLED.getName();
                outDealRepo.returnError(request, errmsg);
                throw new Exception(errmsg);
            }
            Session session = (Session)request.get(EComType.T_SESSION.getCode());
            String startWithCommOut = EComType.COMM_OUT.getCode() + this.modulecode;
            if (session == null) {
                session = new Session();
                session.setModuleName(startWithCommOut);
                session.setContext(request);
                session.getContext().put(EComType.T_SESSION.getCode(), session);
            }
            outDealRepo.chkSignature(request, uoPOuttrademapVo);
            UoPExpandmapVo uoPExpandmap = this.uoPExpandmapRepo.getUoPExpandmap(this.modulecode, msgtype, request.get(EComType.SYS_ID.getCode()).toString(), request.get(EComType.APP_ID.getCode()).toString());
            if (uoPExpandmap != null) {
                String xmlns = uoPExpandmap.getXmlns();
                String xsivalue = uoPExpandmap.getXsivalue();
                String schemalocation = uoPExpandmap.getSchemalocation();
                String xsdfilename = uoPExpandmap.getXsdfilename();
                if (StringUtils.isNotEmpty((CharSequence)xmlns)) {
                    request.put(EComType.XML_NS.getCode(), xmlns);
                }
                if (StringUtils.isNotEmpty((CharSequence)xsivalue)) {
                    request.put(EComType.XSI_VALUE.getCode(), xsivalue);
                }
                if (StringUtils.isNotEmpty((CharSequence)schemalocation)) {
                    request.put(EComType.SCHEMA_LOCATION.getCode(), schemalocation);
                }
                if (StringUtils.isNotEmpty((CharSequence)xsdfilename)) {
                    request.put(EComType.XSD_FILE_NAME.getCode(), xsdfilename);
                }
            }
            outDataFormatRepo.packMsg(request, uoPOuttrademapVo.getReqmsgtype());
            request.remove(request.get(EComType.T_SESSION.getCode()));
            outDealRepo.saveContent(uoPModuleinfoVo, request);
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put(EComType.ATTR_RESPONSE_DATA.getCode(), request.get(EComType.ATTR_RESPONSE_DATA.getCode()));
            info.put(EComType.SERVICE_CODE.getCode(), request.get(EComType.SERVICE_CODE.getCode()));
            if (EComType.COST_FLAG.getCode().equals(uoPModuleinfoVo.getCostflag())) {
                LocalDateTime endTime = LocalDateTime.now();
                this.saveCostjnlRepo.saveCostjnl(startTime, endTime, request.getOrDefault(EComType.COMMO_SGID.getCode(), "").toString(), request.getOrDefault(EComType.ORIG_RECV_ID.getCode(), "").toString());
            }
            Map objectMap = BspTemplate.exchange((String)uoPOuttrademapVo.getSvctradecode(), null, info);
            outDataFormatRepo.unpackMsg(objectMap);
            outDealRepo.returnMsg(objectMap, uoPOuttrademapVo.getRspmsgtype());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PlatformException(e.getMessage());
        }
    }

    public void grayproc(Map<String, Object> request) {
        String msgid;
        ServletRequestAttributes servletRequestAttributes;
        String grayFlag;
        if (!ObjectUtils.isEmpty((Object)RequestContextHolder.getRequestAttributes()) && StringUtils.isNotEmpty((CharSequence)(grayFlag = (servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getHeader(EComType.GRAY_FLAG.getCode()))) && StringUtils.isNotEmpty((CharSequence)(msgid = request.getOrDefault(this.msgidname, "").toString()))) {
            this.redisUtil.set(msgid, (Object)msgid, Duration.ofSeconds(300L));
        }
    }
}

