/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.outcenter.service;

import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.outcenter.code.EComType;
import cn.com.yusys.yusp.pay.common.outcenter.domain.repo.InDataFormatRepo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.repo.InDealRepo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.repo.SaveCostjnlRepo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.repo.UoPIntradeMapRepo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.repo.UoPmoduleRepo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.vo.UoPIntrademapVo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.vo.UoPModuleinfoVo;
import cn.com.yusys.yusp.pay.common.outcenter.util.LoggerUtil;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public abstract class InService {
    public String modulecode = "In";
    public String inDataFormatName = "inDataFormatRepo";
    public String inDealName = "inDealRepo";
    public String event = "*.pay.Request}";
    @Autowired
    public ApplicationContext applicationContext;
    @Autowired
    public UoPIntradeMapRepo uoPIntradeMapRepo;
    @Autowired
    public UoPmoduleRepo uoPmoduleRepo;
    @Autowired
    public SaveCostjnlRepo saveCostjnlRepo;
    @Value(value="${UPP.appid}")
    private String appid;

    public InService(String modulecode, String event, String inDataFormatName, String inDealName) {
        this.modulecode = modulecode;
        this.event = event;
        this.inDataFormatName = inDataFormatName;
        this.inDealName = inDealName;
    }

    public YuinResult inService(Map<String, Object> request) throws Exception {
        try {
            request.put(EComType.MODULE_CODE.getCode(), this.modulecode);
            LoggerUtil.logger(request, EComType.MODULE_IN_NAME.getCode() + EComType.START.getName());
            LocalDateTime startTime = LocalDateTime.now();
            InDataFormatRepo inDataFormatRepo = (InDataFormatRepo)this.applicationContext.getBean(this.inDataFormatName);
            InDealRepo inDealRepo = (InDealRepo)this.applicationContext.getBean(this.inDealName);
            request.put(EComType.APP_ID.getCode(), this.appid);
            request.put(EComType.SYS_ID.getCode(), EComType.UPP.getCode());
            LoggerUtil.logger(request, "sysid:" + EComType.UPP.getCode());
            LoggerUtil.logger(request, "appid:" + this.appid);
            LoggerUtil.logger(request, EComType.MODULE_MESSAGE.getName());
            UoPModuleinfoVo uoPModuleinfoVo = this.uoPmoduleRepo.getModuleInfo(this.modulecode, request.get(EComType.SYS_ID.getCode()).toString(), request.get(EComType.APP_ID.getCode()).toString());
            if (uoPModuleinfoVo == null) {
                LoggerUtil.logger(request, EComType.ERR_MODULE_STATUS.getName() + this.modulecode);
                request.put(EComType.ERR_CODE.getCode(), this.modulecode + EComType.ERR_MODULE_STATUS.getCode());
                request.put(EComType.ERR_MSG.getCode(), this.modulecode + EComType.ERR_MODULE_STATUS.getName());
                inDealRepo.stopRecvListen(this.modulecode);
                return YuinResult.newFailureResult((String)EComType.ERR_MODULE_STATUS.getCode(), (String)(this.modulecode + EComType.ERR_MODULE_STATUS.getName()));
            }
            inDealRepo.chkModule(uoPModuleinfoVo);
            inDataFormatRepo.unpackMsg(request);
            inDataFormatRepo.fieldset(request);
            LoggerUtil.logger(request, EComType.TRADE_MAP.getName());
            String msgcd = request.getOrDefault(EComType.MSG_CD.getCode(), "").toString();
            LoggerUtil.logger(request, "msgcd" + msgcd);
            UoPIntrademapVo uoPIntrademapVo = this.uoPIntradeMapRepo.getUoPIntrademap(this.modulecode, msgcd, request.get(EComType.SYS_ID.getCode()).toString(), request.get(EComType.APP_ID.getCode()).toString());
            if (uoPIntrademapVo == null) {
                LoggerUtil.logger(request, EComType.ERR_NO_OUT_TRADE.getCode());
                return YuinResult.newFailureResult((String)EComType.ERR_NO_OUT_TRADE.getCode(), (String)(msgcd + EComType.ERR_NO_OUT_TRADE.getName()));
            }
            request.put(EComType.TREAD_CODE.getCode(), uoPIntrademapVo.getReqtradecode());
            request.put(EComType.TREAD_NAME.getCode(), uoPIntrademapVo.getReqtradename());
            if (!inDealRepo.chktradestatus(uoPIntrademapVo)) {
                inDealRepo.returnError(request);
            }
            Session session = (Session)request.get(EComType.T_SESSION.getCode());
            String startWithCommOut = EComType.COMM_IN.getCode() + this.modulecode;
            if (session == null) {
                session = new Session();
                session.setModuleName(startWithCommOut);
                session.setContext(request);
                session.getContext().put(EComType.T_SESSION.getCode(), session);
            }
            LoggerUtil.logger(request, EComType.RETURN_990.getName());
            if (EComType.IS_RSP.getCode().equals(uoPIntrademapVo.getRspflag())) {
                inDealRepo.returnMsg(request, EComType.RET_PACK_NAME.getCode());
            }
            inDealRepo.saveContent(uoPModuleinfoVo, request);
            inDealRepo.chkSignature(request, uoPIntrademapVo);
            request.put(EComType.TREAD_CODE.getCode(), uoPIntrademapVo.getSvctradecode());
            inDataFormatRepo.packMsg(request, uoPIntrademapVo.getMapmsgtype());
            HashMap mapBod = (HashMap)request.get(EComType.MAP_PACK_NAME.getCode());
            mapBod.put(EComType.TREAD_CODE.getCode(), uoPIntrademapVo.getSvctradecode());
            String comtype = uoPIntrademapVo.getComtype();
            if (EComType.TOP_TYPE_RESTFUL.getCode().equals(comtype)) {
                inDataFormatRepo.packHttpReq(request, EComType.PACK_HTTP_REQ.getCode());
                HashMap mapReq = (HashMap)request.get(EComType.MAP_PACK_HTTP_NAME.getCode());
                mapReq.put(EComType.BODY.getCode(), mapBod);
                inDealRepo.exchangeOutHttpAdapter(mapBod, uoPIntrademapVo);
            } else if (!EComType.TOP_TYPE_SOCKET.getCode().equals(comtype)) {
                LoggerUtil.logger(request, EComType.MODULE_IN_NAME.getCode() + EComType.TOP_TYPE_MQ.getName() + EComType.START.getName());
                LoggerUtil.logger(request, EComType.MODULE_IN_NAME.getCode() + EComType.TOP_TYPE_MQ.getName() + EComType.END.getName());
            }
            String statusCode = mapBod.getOrDefault(EComType.STATUS_CODE.getCode(), "").toString();
            if (StringUtils.nonEmpty((CharSequence)statusCode)) {
                inDealRepo.resturnLimitationMsg(mapBod, uoPIntrademapVo.getSvctradetype());
            }
            if (EComType.COST_FLAG.getCode().equals(uoPModuleinfoVo.getCostflag())) {
                LoggerUtil.logger(request, EComType.COST_FLAG.getName());
                LocalDateTime endTime = LocalDateTime.now();
                this.saveCostjnlRepo.saveCostjnl(startTime, endTime, request.getOrDefault(EComType.COMMO_SGID.getCode(), "").toString(), request.getOrDefault(EComType.ORIG_RECV_ID.getCode(), "").toString());
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("New resource exception, resource type")) {
                LoggerUtil.logger(request, EComType.ERR_NO_FILE.getName());
                LoggerUtil.logger(request, this.modulecode + EComType.END.getName());
                return YuinResult.newFailureResult((String)EComType.ERR_OUT.getCode(), (Throwable)e);
            }
            LoggerUtil.logger(request, EComType.ERR_OUT.getName() + ":" + e);
            LoggerUtil.logger(request, EComType.MODULE_IN_NAME.getCode() + EComType.END.getName());
            return YuinResult.newFailureResult((String)EComType.ERR_OUT.getCode(), (Throwable)e);
        }
        LoggerUtil.logger(request, EComType.MODULE_IN_NAME.getCode() + EComType.END.getName());
        return YuinResult.newSuccessResult(null);
    }
}

