/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.outcenter.domain.repo;

import cn.com.yusys.yusp.bsp.communication.BspTemplate;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.resources.BspAppContext;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.pay.common.base.util.RedisUtil;
import cn.com.yusys.yusp.pay.common.base.util.YuinLogUtils;
import cn.com.yusys.yusp.pay.common.outcenter.code.EComType;
import cn.com.yusys.yusp.pay.common.outcenter.domain.repo.OutDataFormatRepo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.repo.UoMOuttranjnlRepo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.vo.UoMOuttranjnlVo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.vo.UoPModuleinfoVo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.vo.UoPOuttrademapVo;
import cn.com.yusys.yusp.pay.common.outcenter.util.LoggerUtil;
import cn.com.yusys.yusp.pay.common.outcenter.util.OutUtil;
import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public abstract class OutDealRepo {
    public static final String ATTR_SEND_DATA = "send";
    public String outDataFormatName = "outDataFormatRepo";
    public String serviceName = "out";
    public String syscd = "out";
    @Autowired
    public UoMOuttranjnlRepo uoMOuttranjnlRepo;
    @Autowired
    public ApplicationContext applicationContext;
    @Autowired
    public RedisUtil redisUtil;

    public OutDealRepo(String outDataFormatName, String syscd, String serviceName) {
        this.outDataFormatName = outDataFormatName;
        this.syscd = syscd;
        this.serviceName = serviceName;
    }

    public void stopRecvListen(String modulecode) throws Exception {
        BspAppContext context = (BspAppContext)ResourcePortal.getInstance().getSpringContextRegistry().getContextMap().get(modulecode);
        if (context == null) {
            YuinLogUtils.getInst((Object)this).error("Module [" + modulecode + "] in microservice [" + modulecode + "] is no fund !");
            throw new Exception("Module [" + modulecode + "] in microservice [" + modulecode + "] is no fund !");
        }
        AbstractInAdapter inAdapter = (AbstractInAdapter)context.getBean(AbstractInAdapter.class);
        inAdapter.stop();
    }

    public boolean chkModule(UoPModuleinfoVo uoPModuleinfoVo) throws Exception {
        return !EComType.DISABLED_CODE.getCode().equals(uoPModuleinfoVo.getDisabled()) && !EComType.STATUS.getCode().equals(uoPModuleinfoVo.getModulestatus());
    }

    @Async(value="taskExecutor")
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void saveContent(UoPModuleinfoVo uoPModuleinfoVo, Map<String, Object> request) throws Exception {
        if (EComType.IS_SAVE.getCode().equals(uoPModuleinfoVo.getSaveflag())) {
            LoggerUtil.logger(request, "\u62a5\u6587\u767b\u8bb0");
            String send = new String((byte[])request.get(EComType.ATTR_RESPONSE_DATA.getCode()));
            if (EComType.IS_SECRET.getCode().equals(uoPModuleinfoVo.getEncodeflag())) {
                send = new String((byte[])request.get(EComType.ATTR_RESPONSE_DATA.getCode()));
            }
            UoMOuttranjnlVo uoMOuttranjnlVo = new UoMOuttranjnlVo();
            String globalseq = request.getOrDefault(EComType.GLOBLE_SEQ.getCode(), "").toString();
            uoMOuttranjnlVo.setBusidate(request.getOrDefault("origsenddate", "").toString());
            uoMOuttranjnlVo.setBusiseqno(request.getOrDefault("commsgid", "").toString());
            uoMOuttranjnlVo.setMsgtype(request.getOrDefault("tmsgtype", "").toString());
            uoMOuttranjnlVo.setOrigbusiseqno(request.getOrDefault("origrecvid", "").toString());
            uoMOuttranjnlVo.setGlobalseq(globalseq);
            uoMOuttranjnlVo.setSyscd(this.syscd);
            uoMOuttranjnlVo.setReqmsg(send);
            uoMOuttranjnlVo.setSendbankno(request.getOrDefault("origsendid", "").toString());
            uoMOuttranjnlVo.setSendstatus("0");
            uoMOuttranjnlVo.setUpdtime(LocalDateTime.now());
            this.uoMOuttranjnlRepo.save(uoMOuttranjnlVo);
        }
    }

    public boolean chktradestatus(UoPOuttrademapVo uoPOuttrademapVo) throws Exception {
        return !EComType.STATUS.getCode().equals(uoPOuttrademapVo.getSvcstatus()) && !EComType.DISABLED_CODE.getCode().equals(uoPOuttrademapVo.getDisabled());
    }

    public void returnError(Map<String, Object> request, String errmsg) throws Exception {
        LoggerUtil.logger(request, "\u9519\u8bef\u5e94\u7b54\u5904\u7406");
        LoggerUtil.logger(request, "\u9519\u8bef\u5e94\u7b54\u7ed3\u675f");
    }

    public void chkSignature(Map<String, Object> request, UoPOuttrademapVo uoPOuttrademapVo) throws Exception {
        if (EComType.VALID_FLA.getCode().equals(uoPOuttrademapVo.getValidflag())) {
            LoggerUtil.logger(request, "\u52a0\u7b7e\u5f00\u59cb");
            OutDataFormatRepo outDataFormatRepo = (OutDataFormatRepo)this.applicationContext.getBean(this.outDataFormatName);
            outDataFormatRepo.packSign(request, uoPOuttrademapVo.getSignmsgtype());
            String sginSrc = new String((byte[])request.get(EComType.ATTR_SING_DATA.getCode()), EComType.PARA_ENCODING.getCode());
            LoggerUtil.logger(request, "\u52a0\u7b7e\u7ed3\u675f");
        }
    }

    public void returnMsg(Map<String, Object> request, String retpackname) throws Exception {
        LoggerUtil.logger(request, "\u901a\u8baf\u7ea7\u5e94\u7b54\u5904\u7406\u5f00\u59cb");
        OutDataFormatRepo outDataFormatRepo = (OutDataFormatRepo)this.applicationContext.getBean(this.outDataFormatName);
        outDataFormatRepo.packReturnMsg(request, retpackname);
        Map message = (Map)request.get(EComType.MAP_PACK_NAME.getCode());
        HashMap<String, byte[]> info = new HashMap<String, byte[]>();
        info.put(EComType.ATTR_RESPONSE_DATA.getCode(), JSON.toJSONString((Object)message).getBytes());
        String serviceName = OutUtil.getServiceName();
        if (StringUtils.isEmpty((String)serviceName)) {
            throw new Exception("\u6ca1\u6709\u53ef\u7528mq\u961f\u5217");
        }
        LoggerUtil.logger(request, EComType.MODULE_OUT_NAME.getCode() + "." + serviceName + ":" + EComType.TOP_TYPE_MQ.getName() + EComType.START.getName());
        BspTemplate.exchange((String)serviceName, null, info);
        LoggerUtil.logger(request, EComType.MODULE_OUT_NAME.getCode() + "." + serviceName + ":" + EComType.TOP_TYPE_MQ.getName() + EComType.END.getName());
        LoggerUtil.logger(request, "\u901a\u8baf\u7ea7\u5e94\u7b54\u5904\u7406\u7ed3\u675f");
    }

    public void returnErrMsg(Map<String, Object> request) throws Exception {
        LoggerUtil.logger(request, "\u9519\u8bef\u5e94\u7b54\u5904\u7406\u5f00\u59cb");
        OutDataFormatRepo outDataFormatRepo = (OutDataFormatRepo)this.applicationContext.getBean(this.outDataFormatName);
        outDataFormatRepo.packErrmsg(request);
        Map message = (Map)request.get(EComType.MAP_PACK_NAME.getCode());
        HashMap<String, byte[]> info = new HashMap<String, byte[]>();
        info.put(EComType.ATTR_RESPONSE_DATA.getCode(), JSON.toJSONString((Object)message).getBytes());
        String serviceName = OutUtil.getServiceName();
        if (StringUtils.isEmpty((String)serviceName)) {
            throw new Exception("\u6ca1\u6709\u53ef\u7528mq\u961f\u5217");
        }
        LoggerUtil.logger(request, EComType.MODULE_OUT_NAME.getCode() + "." + serviceName + ":" + EComType.TOP_TYPE_MQ.getName() + EComType.START.getName());
        BspTemplate.exchange((String)serviceName, null, info);
        LoggerUtil.logger(request, EComType.MODULE_OUT_NAME.getCode() + "." + serviceName + ":" + EComType.TOP_TYPE_MQ.getName() + EComType.END.getName());
        LoggerUtil.logger(request, "\u9519\u8bef\u5e94\u7b54\u5904\u7406\u7ed3\u675f");
    }

    public void sendMsg(Map<String, Object> request, Map<String, Object> messsge) throws Exception {
        LoggerUtil.logger(request, EComType.MODULE_OUT_NAME.getCode() + "." + this.serviceName + ":" + EComType.TOP_TYPE_MQ.getName() + EComType.START.getName());
        String serviceName = OutUtil.getServiceName();
        if (StringUtils.isEmpty((String)serviceName)) {
            throw new Exception("\u6ca1\u6709\u53ef\u7528mq\u961f\u5217");
        }
        BspTemplate.exchange((String)serviceName, null, messsge);
        LoggerUtil.logger(request, EComType.MODULE_OUT_NAME.getCode() + "." + serviceName + ":" + EComType.TOP_TYPE_MQ.getName() + EComType.END.getName());
    }
}

