/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.outcenter.domain.repo;

import cn.com.yusys.yusp.bsp.communication.BspTemplate;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.resources.BspAppContext;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.pay.common.base.util.RedisUtil;
import cn.com.yusys.yusp.pay.common.base.util.YuinLogUtils;
import cn.com.yusys.yusp.pay.common.outcenter.code.EComType;
import cn.com.yusys.yusp.pay.common.outcenter.dao.mapper.UoMIntranjnlMapper;
import cn.com.yusys.yusp.pay.common.outcenter.dao.po.UoMIntranjnlPo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.repo.InDataFormatRepo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.vo.UoPIntrademapVo;
import cn.com.yusys.yusp.pay.common.outcenter.domain.vo.UoPModuleinfoVo;
import cn.com.yusys.yusp.pay.common.outcenter.util.LoggerUtil;
import cn.com.yusys.yusp.pay.common.outcenter.util.MapUtil;
import cn.com.yusys.yusp.pay.common.outcenter.util.OutUtil;
import cn.com.yusys.yusp.pay.common.outcenter.util.TradeMapConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Base64Utils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public abstract class InDealRepo {
    public String inDataFormatName = "inDataFormatRepo";
    public String serviceName = "out";
    public String syscd = "in";
    @Autowired
    public ApplicationContext applicationContext;
    @Autowired
    public UoMIntranjnlMapper uoMIntranjnlMapper;
    @Autowired
    public RedisUtil redisUtil;
    @Autowired
    public RestTemplate restTemplate;
    @Value(value="${payment.grayflag:false}")
    private String grayFlag;
    @Value(value="${payment.refcommsgidname:refcommsgid}")
    private String refcommsgidname;
    @Autowired
    private TradeMapConfig tradeMapConfig;

    public InDealRepo(String inDataFormatName, String serviceName, String syscd) {
        this.inDataFormatName = inDataFormatName;
        this.serviceName = serviceName;
        this.syscd = syscd;
    }

    public void stopRecvListen(String modulecode) throws Exception {
        BspAppContext context = (BspAppContext)ResourcePortal.getInstance().getSpringContextRegistry().getContextMap().get(modulecode);
        if (context == null) {
            YuinLogUtils.getInst((Object)this).error("Module [" + modulecode + "] in microservice [" + modulecode + "] is no fund !");
            throw new Exception("Module [" + modulecode + "] in microservice [" + modulecode + "] is no fund !");
        }
        AbstractInAdapter inAdapter = (AbstractInAdapter)context.getBean(AbstractInAdapter.class);
        inAdapter.stop();
    }

    public void chkModule(UoPModuleinfoVo uoPModuleinfoVo) throws Exception {
        if (EComType.DISABLED_CODE.getCode().equals(uoPModuleinfoVo.getDisabled()) || EComType.STATUS.getCode().equals(uoPModuleinfoVo.getModulestatus())) {
            this.stopRecvListen(uoPModuleinfoVo.getModulecode());
        }
    }

    @Async(value="taskExecutor")
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void saveContent(UoPModuleinfoVo uoPModuleinfoVo, Map<String, Object> request) throws Exception {
        if (EComType.IS_SAVE.getCode().equals(uoPModuleinfoVo.getSaveflag())) {
            LoggerUtil.logger(request, "\u62a5\u6587\u767b\u8bb0");
            byte[] recv = (byte[])request.get(EComType.ATTR_REQUEST_DATA.getCode());
            String str = new String(recv);
            if (EComType.IS_SECRET.getCode().equals(uoPModuleinfoVo.getEncodeflag())) {
                str = Base64Utils.encodeToUrlSafeString((byte[])recv);
            }
            UoMIntranjnlPo uoMIntranjnlPo = new UoMIntranjnlPo();
            this.uoMIntranjnlMapper.insert(uoMIntranjnlPo);
        }
    }

    public boolean chktradestatus(UoPIntrademapVo uoPIntrademapVo) throws Exception {
        return EComType.SVC_STATUS.getCode().equals(uoPIntrademapVo.getSvcstatus());
    }

    public void returnMsg(Map<String, Object> request, String name) throws Exception {
        LoggerUtil.logger(request, "\u901a\u8baf\u7ea7\u5e94\u7b54\u5904\u7406\u5f00\u59cb");
        InDataFormatRepo inDataFormatRepo = (InDataFormatRepo)this.applicationContext.getBean(this.inDataFormatName);
        inDataFormatRepo.packReturnMsg(request, name);
        HashMap<String, byte[]> info = new HashMap<String, byte[]>();
        byte[] send = (byte[])request.get(EComType.ATTR_RESPONSE_DATA.getCode());
        LoggerUtil.logger(request, this.serviceName + ":" + new String(send));
        info.put(EComType.ATTR_RESPONSE_DATA.getCode(), send);
        String serviceName = OutUtil.getServiceName();
        if (StringUtils.isEmpty((String)serviceName)) {
            throw new Exception("\u6ca1\u6709\u53ef\u7528mq\u961f\u5217");
        }
        LoggerUtil.logger(request, EComType.MODULE_OUT_NAME.getCode() + "." + serviceName + ":" + EComType.TOP_TYPE_MQ.getName() + EComType.START.getName());
        BspTemplate.exchange((String)serviceName, null, info);
        LoggerUtil.logger(request, EComType.MODULE_OUT_NAME.getCode() + "." + serviceName + ":" + EComType.TOP_TYPE_MQ.getName() + EComType.END.getName());
        LoggerUtil.logger(request, "\u901a\u8baf\u7ea7\u5e94\u7b54\u5904\u7406\u7ed3\u675f");
    }

    public void returnError(Map<String, Object> request) throws Exception {
        LoggerUtil.logger(request, "\u9519\u8bef\u5e94\u7b54\u5904\u7406");
        InDataFormatRepo inDataFormatRepo = (InDataFormatRepo)this.applicationContext.getBean(this.inDataFormatName);
        inDataFormatRepo.packErrmsg(request);
        HashMap<String, byte[]> info = new HashMap<String, byte[]>();
        byte[] send = (byte[])request.get(EComType.ATTR_RESPONSE_DATA.getCode());
        info.put(EComType.ATTR_RESPONSE_DATA.getCode(), send);
        LoggerUtil.logger(request, this.serviceName + ":" + new String(send));
        String serviceName = OutUtil.getServiceName();
        if (StringUtils.isEmpty((String)serviceName)) {
            throw new Exception("\u6ca1\u6709\u53ef\u7528mq\u961f\u5217");
        }
        LoggerUtil.logger(request, EComType.MODULE_OUT_NAME.getCode() + "." + serviceName + ":" + EComType.TOP_TYPE_MQ.getName() + EComType.START.getName());
        BspTemplate.exchange((String)serviceName, null, info);
        LoggerUtil.logger(request, EComType.MODULE_OUT_NAME.getCode() + "." + serviceName + ":" + EComType.TOP_TYPE_MQ.getName() + EComType.END.getName());
        LoggerUtil.logger(request, "\u9519\u8bef\u5e94\u7b54\u5904\u7406\u7ed3\u675f");
    }

    public void chkSignature(Map<String, Object> request, UoPIntrademapVo uoPIntrademapVo) throws Exception {
        if (EComType.VALID_FLA.getCode().equals(uoPIntrademapVo.getValidflag())) {
            LoggerUtil.logger(request, "\u9a8c\u7b7e\u5f00\u59cb");
            InDataFormatRepo inDataFormatRepo = (InDataFormatRepo)this.applicationContext.getBean(this.inDataFormatName);
            inDataFormatRepo.packSign(request, uoPIntrademapVo.getSignmsgtype());
            String sginSrc = new String((byte[])request.get(EComType.ATTR_SING_DATA.getCode()), EComType.PARA_ENCODING.getCode());
            LoggerUtil.logger(request, "\u9a8c\u7b7e\u7ed3\u675f");
        }
    }

    public void exchangeOutHttpAdapter(Map<String, Object> requestMap, UoPIntrademapVo uoPIntrademapVo) throws Exception {
        String oldRawPath = "";
        oldRawPath = "HVPS".equals(requestMap.get("appid")) || "BEPS".equals(requestMap.get("appid")) ? ("HVPS".equals(requestMap.get("appid")) ? "pay-center-hvps/api/" + uoPIntrademapVo.getSvctradecode() : "pay-center-beps/api/" + uoPIntrademapVo.getSvctradecode()) : uoPIntrademapVo.getSvcurl();
        String ctrlflag = uoPIntrademapVo.getCtrlflag();
        String newPath = this.getGrayPath(ctrlflag, oldRawPath, requestMap);
        String requestUrl = "http://" + newPath;
        try {
            String send = JSON.toJSONString(requestMap);
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.setContentType(MediaType.APPLICATION_JSON);
            String globalseq = requestMap.getOrDefault(EComType.GLOBLE_SEQ.getCode(), "").toString();
            httpHeaders.add(EComType.GLOBLE_SEQ.getCode(), globalseq);
            HttpEntity requestEntity = new HttpEntity((Object)send, (MultiValueMap)httpHeaders);
            LoggerUtil.logger(requestMap, EComType.TOP_TYPE_RESTFUL.getName() + ":" + requestUrl);
            LoggerUtil.logger(requestMap, EComType.MODULE_IN_NAME.getCode() + send);
            LoggerUtil.logger(requestMap, "restTemplate:" + this.restTemplate);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(requestUrl, (Object)requestEntity, JSONObject.class, new Object[0]);
            LoggerUtil.logger(requestMap, EComType.TOP_TYPE_RESTFUL.getName() + EComType.END.getName());
            int code = responseEntity.getStatusCode().value();
            String statusCode = Integer.toString(code);
            if (EComType.ERR_CODE_429.equals(Integer.toString(code))) {
                LoggerUtil.logger(requestMap, EComType.ERR_CODE_429.getName());
                requestMap.put(EComType.STATUS_CODE.getCode(), statusCode);
            }
            LoggerUtil.logger(requestMap, EComType.TOP_TYPE_RESTFUL.getName() + EComType.END.getName());
        }
        catch (HttpClientErrorException e) {
            HttpStatus statusCode = e.getStatusCode();
            if (statusCode == HttpStatus.NOT_FOUND) {
                LoggerUtil.logger(requestMap, "not found" + requestUrl + e.getMessage());
            } else if (statusCode == HttpStatus.REQUEST_TIMEOUT || statusCode == HttpStatus.GATEWAY_TIMEOUT) {
                LoggerUtil.logger(requestMap, "timeout" + requestUrl + e.getMessage());
            }
        }
        catch (Exception e) {
            LoggerUtil.logger(requestMap, "restRrror:" + e.getMessage());
        }
    }

    public void resturnLimitationMsg(Map<String, Object> request, String name) throws Exception {
        LoggerUtil.logger(request, "\u9650\u6d41\u5e94\u7b54\u5904\u7406\u5f00\u59cb");
        this.returnMsg(request, name);
        LoggerUtil.logger(request, "\u9650\u6d41\u5e94\u7b54\u5904\u7406\u7ed3\u675f");
    }

    public void getServiceName(Map<String, Object> request) {
        Map Document = (Map)request.get("Document");
        Map ChckRspn = (Map)Document.get("ChckRspn");
        Map ChckRspnInf = (Map)ChckRspn.get("ChckRspnInf");
        Map OrigSndNd = (Map)ChckRspnInf.get("OrigSndNd");
        String serviceName = OrigSndNd.getOrDefault("value", "").toString();
        if (cn.com.yusys.yusp.commons.util.StringUtils.nonEmpty((CharSequence)serviceName)) {
            OutUtil.setSucess(serviceName);
        }
    }

    public String getGrayPath(String ctrlflag, String oldRawPath, Map<String, Object> requestMap) {
        if ("true".equals(this.grayFlag)) {
            String rspflag = "0";
            rspflag = ctrlflag.length() > 1 ? ctrlflag.substring(0, 1) : ctrlflag;
            if ("1".equals(rspflag)) {
                String refcommmsgid = requestMap.getOrDefault(this.refcommsgidname, "").toString();
                if (StringUtils.isNotEmpty((String)refcommmsgid) && this.redisUtil.hasKey(refcommmsgid)) {
                    return oldRawPath.substring(0, 1) + "gray-" + oldRawPath.substring(1);
                }
            } else {
                Map<String, Object> tradeParamMap = this.tradeMapConfig.getTradeparam();
                Map<String, Map<String, String>> interfaceMap = this.tradeMapConfig.getInferfacemap();
                if (interfaceMap == null) {
                    return oldRawPath;
                }
                if (interfaceMap.containsKey(oldRawPath)) {
                    Map<String, String> routeKey = interfaceMap.get(oldRawPath);
                    boolean isHit = false;
                    for (String key : routeKey.keySet()) {
                        Object packageValue = MapUtil.getValue(requestMap, key);
                        String grayValue = MapUtil.getValue(tradeParamMap, key).toString();
                        if (!ObjectUtils.isNotEmpty((Object)packageValue)) continue;
                        if (grayValue.contains(",")) {
                            Object[] grays = grayValue.split(",");
                            if (!ArrayUtils.contains((Object[])grays, (Object)packageValue)) continue;
                            isHit = true;
                            continue;
                        }
                        if (!grayValue.equals(packageValue.toString())) continue;
                        isHit = true;
                    }
                    if (isHit) {
                        return oldRawPath.substring(0, 1) + "gray-" + oldRawPath.substring(1);
                    }
                }
            }
        }
        return oldRawPath;
    }
}

