/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.outcenter.expand;

import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.pay.common.outcenter.util.LoggerUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5CheckSumGen {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String unitId = null;
    protected String unitName = null;
    private static final long serialVersionUID = 268727502928295591L;
    private static final String FILE = "File";
    private static final String VAR = "Var";
    private static final String FORMAT_NONE = "NONE";
    private static final String FORMAT_HEXUPPER = "HEX(UPPER)";
    private static final String FORMAT_HEXLOWER = "HEX(LOWER)";

    public String executeComponent(Map<String, Object> request, String srcType, String varSrc, String fileSrc, String reWay) throws Exception {
        LoggerUtil.logger(request, "md5\u751f\u6210\u5f00\u59cb");
        LoggerUtil.logger(request, "\u5165\u53c2srcType:" + srcType);
        LoggerUtil.logger(request, "\u5165\u53c2varSrc:" + varSrc);
        LoggerUtil.logger(request, "\u5165\u53c2fileSrc:" + fileSrc);
        LoggerUtil.logger(request, "\u5165\u53c2reWay:" + reWay);
        byte[] result = null;
        String tmpSrc = null;
        if (VAR.equals(srcType)) {
            LoggerUtil.logger(request, "\u6839\u636e\u5b57\u7b26\u4e32\u751f\u6210md5");
            result = this.strMD5(varSrc);
            LoggerUtil.logger(request, "\u6839\u636e\u5b57\u7b26\u4e32\u751f\u6210md5:" + new String(result));
        } else if (FILE.equals(srcType)) {
            LoggerUtil.logger(request, "\u6839\u636e\u6587\u4ef6\u751f\u6210md5");
            result = this.fileMD5(fileSrc);
            LoggerUtil.logger(request, "\u6839\u636e\u6587\u4ef6\u751f\u6210md5:" + new String(result));
        }
        LoggerUtil.logger(request, "md5\u5b57\u8282\u5904\u7406:" + new String(result));
        if (FORMAT_NONE.equals(reWay)) {
            tmpSrc = new String(result);
            LoggerUtil.logger(request, "\u8fd4\u56de\u7ed3\u679c:" + tmpSrc);
        } else if (FORMAT_HEXUPPER.equals(reWay)) {
            tmpSrc = StringTools.toHexString((byte[])result);
            LoggerUtil.logger(request, "\u8fd4\u56de\u7ed3\u679c:" + tmpSrc);
        } else if (FORMAT_HEXLOWER.equals(reWay)) {
            tmpSrc = StringTools.toHexString((byte[])result);
            tmpSrc = StringUtils.lowerCase((String)tmpSrc);
            LoggerUtil.logger(request, "\u8fd4\u56de\u7ed3\u679c:" + tmpSrc);
        }
        LoggerUtil.logger(request, "md5\u751f\u6210\u7ed3\u675f");
        return tmpSrc;
    }

    public byte[] fileMD5(String fileSrc) throws Exception {
        byte[] result = null;
        String path = StringTools.getString((Object)fileSrc);
        if (StringUtils.isBlank((String)path)) {
            throw new Exception("\u6570\u636e\u6e90\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a", null);
        }
        File srcFile = new File(path);
        if (srcFile.exists()) {
            BufferedInputStream bis = null;
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                bis = new BufferedInputStream(new FileInputStream(srcFile));
                byte[] buf = new byte[1024];
                int count = -1;
                while ((count = bis.read(buf)) != -1) {
                    digest.update(buf, 0, count);
                }
                result = digest.digest();
            }
            catch (Exception e) {
                throw new Exception("\u83b7\u53d6\u6587\u4ef6MD5\u6458\u8981\u5931\u8d25:", e);
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception e) {
                        throw new Exception("\u5173\u95ed\u6570\u636e\u6e90\u5931\u8d25:", e);
                    }
                }
            }
        }
        throw new Exception("\u6570\u636e\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728:" + path, null);
        return result;
    }

    public byte[] strMD5(String varSrc) throws Exception {
        byte[] result = null;
        byte[] dataSrc = ByteTools.getBytes((Object)varSrc);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}@\u6e90\u6570\u636e\uff1a\n{}", (Object)"srcType", (Object)StringTools.toHexString((byte[])dataSrc));
        }
        if (dataSrc == null && dataSrc.length == 0) {
            throw new Exception("\u6570\u636e\u6e90\u4e3a\u7a7a", null);
        }
        result = DigestUtils.md5((byte[])dataSrc);
        return result;
    }
}

