/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.outcenter.expand;

import cn.com.yusys.yusp.bsp.toolkit.common.FileChecker;
import cn.com.yusys.yusp.pay.common.outcenter.util.LoggerUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SchemaValidatorComm {
    private static final long serialVersionUID = -784018799363999256L;
    public static ConcurrentHashMap<String, byte[]> XSD_DATA_MAP = new ConcurrentHashMap();
    public Object muteLock = new Object();
    private String XSD_PATH = "classpath:config/schema/";

    public static byte[] toByte(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            int n;
            byte[] buffer = new byte[4096];
            long var3 = 0L;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                var3 += (long)n;
            }
            output.close();
        }
        catch (Throwable var9) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable var6) {
                    var9.addSuppressed(var6);
                }
            }
            throw var9;
        }
        return output.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeComponent(byte[] data, String xsdFileName, Map<String, Object> request) throws Exception {
        LoggerUtil.logger(request, "schema\u6821\u9a8c\u5f00\u59cb");
        boolean result = true;
        try {
            String xsdPath = this.XSD_PATH + xsdFileName + ".xsd";
            LoggerUtil.logger(request, "\u5165\u53c2xsdFileName:" + xsdFileName);
            LoggerUtil.logger(request, "\u5165\u53c2data:" + new String(data));
            LoggerUtil.logger(request, "xsdPath:" + xsdPath);
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resolver.getResources(xsdPath);
            Resource resource = resources[0];
            if (!resource.exists()) {
                LoggerUtil.logger(request, "\u672a\u627e\u5230:" + xsdPath);
                LoggerUtil.logger(request, "schema\u6821\u9a8c\u7ed3\u675f");
                return result;
            }
            LoggerUtil.logger(request, "filename:" + resource.getFilename());
            InputStream inputStream = resource.getInputStream();
            byte[] xsdData = XSD_DATA_MAP.get(xsdPath);
            boolean flag = FileChecker.getDefaultInstance().isChanged(resource.getFilename());
            if (xsdData == null || flag) {
                Object object = this.muteLock;
                synchronized (object) {
                    xsdData = XSD_DATA_MAP.get(xsdPath);
                    if (xsdData == null || flag) {
                        LoggerUtil.logger(request, "\u83b7\u53d6\u5b57\u8282");
                        xsdData = SchemaValidatorComm.toByte(inputStream);
                        if (xsdData.length > 0) {
                            XSD_DATA_MAP.put(xsdPath, xsdData);
                        }
                    }
                }
            }
            ByteArrayInputStream xsdBais = new ByteArrayInputStream(xsdData);
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(new StreamSource(xsdBais));
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            Validator validator = schema.newValidator();
            StreamSource xmlStreamSource = new StreamSource(bis);
            validator.validate(xmlStreamSource);
            LoggerUtil.logger(request, "{" + xsdFileName + "} @ schema\u6821\u9a8c\u6210\u529f!");
        }
        catch (Exception e) {
            result = false;
            LoggerUtil.logger(request, "schema\u6587\u4ef6\u6821\u9a8c\u9519\u8bef:" + e);
        }
        LoggerUtil.logger(request, "schema\u6821\u9a8c\u7ed3\u679c:" + result);
        LoggerUtil.logger(request, "schema\u6821\u9a8c\u7ed3\u675f");
        return result;
    }
}

