/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.busideal.component.parm.domain.repo;

import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.common.base.component.dboper.dao.mapper.DynamicSqlMapper;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.domain.vo.PlatDateInfo;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class InitFlatDateRepo {
    @Autowired
    private DynamicSqlMapper dynamicSqlMapper;
    @Value(value="${front.datatype}")
    private String datatype;

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public PlatDateInfo getDateTime() {
        String sql = "";
        String workdate = "";
        String worktime = "";
        String worktimes = "";
        String strIsoDateTime = "";
        String strtimesp = "";
        Locale.setDefault(Locale.ENGLISH);
        if ("mysql".equals(this.datatype.toLowerCase())) {
            sql = "select date_format(current_timestamp,'%Y-%m-%d %T') as sysdate,date_format(current_timestamp(3),'%Y-%m-%dT%T:%f') as timesp";
            Map result = this.dynamicSqlMapper.executeQueryMap(sql);
            Date date = DateUtils.parseDate((String)result.get("sysdate").toString().replace("T", " "), (String)"yyyy-MM-dd HH:mm:ss");
            workdate = DateUtils.formatDate((Date)date, (String)"yyyyMMdd");
            worktime = DateUtils.formatDate((Date)date, (String)"HHmmss");
            strIsoDateTime = DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd") + "T" + DateUtils.formatDate((Date)date, (String)"HH:mm:ss");
            strtimesp = result.get("timesp").toString();
            worktimes = worktime + strtimesp.substring(strtimesp.length() - 6);
        } else if ("oracle".equals(this.datatype.toLowerCase())) {
            sql = "select sysdate,to_char(systimestamp,'yyyy-mm-dd hh24:mi:ssxff') as timesp from dual";
            Map result = this.dynamicSqlMapper.executeQueryMap(sql);
            Date date = DateUtils.parseDate((String)result.get("sysdate").toString(), (String)"yyyy-MM-dd HH:mm:ss");
            workdate = DateUtils.formatDate((Date)date, (String)"yyyyMMdd");
            worktime = DateUtils.formatDate((Date)date, (String)"HHmmss");
            strtimesp = result.get("timesp").toString();
            strIsoDateTime = DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd") + "T" + DateUtils.formatDate((Date)date, (String)"HH:mm:ss");
            worktimes = worktime + strtimesp.substring(strtimesp.length() - 6);
        } else if ("db2".equals(this.datatype.toLowerCase())) {
            sql = "select CURRENT DATE as date,CURRENT TIME as time,current timestamp as timesp from SYSIBM.SYSDUMMY1";
            Map result = this.dynamicSqlMapper.executeQueryMap(sql);
            workdate = result.get("date").toString().replace("-", "");
            worktime = result.get("time").toString().replace(":", "");
            strtimesp = result.get("timesp").toString();
            strIsoDateTime = result.get("date").toString() + "T" + result.get("time").toString();
            worktimes = worktime + strtimesp.substring(strtimesp.length() - 6);
        } else {
            Date date = new Date();
            workdate = DateUtils.formatDate((Date)date, (String)"yyyyMMdd");
            worktime = DateUtils.formatDate((Date)date, (String)"HHmmss");
            worktimes = DateUtils.formatDate((Date)date, (String)"HHmmssffffff");
            strtimesp = DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
            strIsoDateTime = DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd") + "T" + DateUtils.formatDate((Date)new Date(), (String)"HH:mm:ss");
        }
        return new PlatDateInfo(workdate, worktime, worktimes, strIsoDateTime, strtimesp);
    }
}

