/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.busideal.component.file.service.impl;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JcraftSFtpUtil {
    private static final Logger LOG = LogManager.getLogger(JcraftSFtpUtil.class);
    private static ChannelSftp sftp;
    private static JcraftSFtpUtil instance;

    private JcraftSFtpUtil() {
    }

    public static JcraftSFtpUtil getInstance(String host, int port, String username, String password, boolean isPwd) {
        if (instance == null && instance == null) {
            LOG.info("\u8c03\u7528jsch\u751f\u6210instance");
            instance = new JcraftSFtpUtil();
            sftp = instance.connect(host, port, username, password, isPwd);
        }
        LOG.info("\u8fdb\u5165jcraftsftputil\u65b9\u6cd5\u83b7\u53d6\u8fde\u63a5\u6210\u529f");
        return instance;
    }

    public static void logout() {
        try {
            if (sftp.getSession() != null && sftp.getSession().isConnected()) {
                sftp.getSession().disconnect();
                instance = null;
                LOG.info("\u5173\u95edsftp.getSession()\u6210\u529f");
            }
        }
        catch (JSchException e) {
            LOG.error("\u5173\u95edsftp.getSession()\u5f02\u5e38!" + (Object)((Object)e));
        }
        if (sftp != null && sftp.isConnected()) {
            sftp.disconnect();
            LOG.info("\u5173\u95edsftp");
        }
    }

    public ChannelSftp connect(String host, int port, String username, String password, boolean isPwd) {
        ChannelSftp sftp = null;
        try {
            JSch jsch = new JSch();
            jsch.getSession(username, host, port);
            Session sshSession = jsch.getSession(username, host, port);
            if (isPwd) {
                sshSession.setPassword(password);
            } else {
                jsch.addIdentity(password, "");
            }
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            sshSession.setConfig(sshConfig);
            sshSession.connect();
            LOG.info("SFTP Session connected.");
            Channel channel = sshSession.openChannel("sftp");
            channel.connect();
            sftp = (ChannelSftp)channel;
            LOG.info("Connected to " + host);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        return sftp;
    }

    public File upload(String downloadFilePath, String saveFile) {
        LOG.info("\u4e0a\u4f20\u8def\u5f84:" + saveFile);
        LOG.info("\u63a5\u6536\u8def\u5f84:" + downloadFilePath);
        try {
            int i = downloadFilePath.lastIndexOf(47);
            if (i == -1) {
                return null;
            }
            try {
                sftp.cd(downloadFilePath.substring(0, i));
            }
            catch (SftpException e) {
                LOG.warn("directory is not exist,start create folder");
                String[] dirs = downloadFilePath.substring(0, i).split("/");
                this.mkdirDir(dirs, "", dirs.length, 0);
            }
            File file = new File(saveFile);
            LOG.info("\u8c03\u7528sftp.put(src,dst)," + saveFile + ";" + downloadFilePath);
            sftp.put(saveFile, downloadFilePath);
            LOG.info("\u4e0a\u4f20\u6587\u4ef6\uff1aupload\u6210\u529f");
            return file;
        }
        catch (Exception e) {
            LOG.error("\u4e0a\u4f20\u6587\u4ef6\uff1aupload\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public File download(String directory, String downloadFile, String saveFile) {
        try {
            sftp.cd(directory);
            File file = new File(saveFile);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            sftp.get(downloadFile, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            return file;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return null;
        }
    }

    public File download(String downloadFilePath, String saveFile) {
        LOG.info("\u4e0b\u8f7d\u7684\u6587\u4ef6\u8def\u5f84\u4ee5\u53ca\u672c\u5730\u8def\u5f84 : " + downloadFilePath + ";" + saveFile);
        try {
            int i = downloadFilePath.lastIndexOf(47);
            if (i == -1) {
                return null;
            }
            File file = new File(saveFile);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            LOG.info("\u8c03\u7528sftp.get(src,dst)," + downloadFilePath.substring(0, i) + "/" + downloadFilePath.substring(i + 1));
            sftp.get(downloadFilePath.substring(0, i) + "/" + downloadFilePath.substring(i + 1), (OutputStream)fileOutputStream);
            fileOutputStream.close();
            LOG.info("\u4e0b\u8f7d\u6587\u4ef6\uff1adownload\u6210\u529f");
            return file;
        }
        catch (Exception e) {
            LOG.error("\u4e0b\u8f7d\u6587\u4ef6\uff1adownload\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public void delete(String directory, String deleteFile) {
        try {
            sftp.cd(directory);
            sftp.rm(deleteFile);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }

    public void disconnect() {
        try {
            sftp.getSession().disconnect();
        }
        catch (JSchException e) {
            LOG.error(e.getMessage());
        }
        sftp.quit();
        sftp.disconnect();
    }

    public Vector<ChannelSftp.LsEntry> listFiles(String directory) throws SftpException {
        return sftp.ls(directory);
    }

    public void mkdirDir(String[] dirs, String tempPath, int length, int index) {
        if (++index < length) {
            tempPath = tempPath + "/" + dirs[index];
        }
        try {
            LOG.info("\u68c0\u6d4b\u76ee\u5f55[" + tempPath + "]");
            sftp.cd(tempPath);
            if (index < length) {
                this.mkdirDir(dirs, tempPath, length, index);
            }
        }
        catch (SftpException ex) {
            LOG.warn("\u521b\u5efa\u76ee\u5f55[" + tempPath + "]");
            try {
                sftp.mkdir(tempPath);
                sftp.cd(tempPath);
            }
            catch (SftpException e) {
                e.printStackTrace();
                LOG.error("\u521b\u5efa\u76ee\u5f55[" + tempPath + "]\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f[" + e.getMessage() + "]");
            }
            LOG.info("\u8fdb\u5165\u76ee\u5f55[" + tempPath + "]");
            this.mkdirDir(dirs, tempPath, length, index);
        }
    }

    static {
        instance = null;
    }
}

