/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.busideal.component.file.service.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class FileHttpUpAndDownLoad {
    public void main(String[] args) throws Exception {
        FileHttpUpAndDownLoad.upLoad("http://localhost:8080/projectName/path", "F:/a.mp3");
    }

    public static void upLoad(String address, String fileName) throws Exception {
        if (null == address) {
            throw new NullPointerException("address is null .");
        }
        if (null == fileName) {
            throw new NullPointerException("FileName is null.");
        }
        FileHttpUpAndDownLoad.upLoad(address, new File(fileName));
    }

    public static void upLoad(String address, File file) throws Exception {
        if (file == null) {
            throw new NullPointerException("File is null.");
        }
        if (file.isDirectory()) {
            throw new Exception("File is directory .");
        }
        URL url = new URL(address);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.addRequestProperty("FileName", file.getName());
        connection.setRequestProperty("content-type", "text/html");
        BufferedOutputStream out = new BufferedOutputStream(connection.getOutputStream());
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] bytes = new byte[1024];
        int numReadByte = 0;
        while ((numReadByte = fileInputStream.read(bytes, 0, 1024)) > 0) {
            out.write(bytes, 0, numReadByte);
        }
        out.flush();
        fileInputStream.close();
    }

    public static void downLoad(String remotePath, String localPath, String localName) throws IOException {
        int nRead;
        URL url = new URL(remotePath);
        File file = new File(localPath, localName);
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setRequestProperty("User-Agent", "NetFox");
        InputStream inputStream = httpURLConnection.getInputStream();
        FileOutputStream outputStream = new FileOutputStream(file);
        byte[] b = new byte[1024];
        while ((nRead = inputStream.read(b, 0, 1024)) > 0) {
            outputStream.write(b, 0, nRead);
        }
        System.out.println("\u4e0b\u5b8c\u4e86\uff01");
        inputStream.close();
        outputStream.close();
    }
}

