/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.busideal.component.cron;

import cn.com.yusys.yusp.commons.util.IdUtils;
import cn.com.yusys.yusp.pay.common.base.component.dboper.dao.mapper.DynamicSqlMapper;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.busideal.component.cron.dao.mapper.UpMCronMapper;
import cn.com.yusys.yusp.pay.common.busideal.component.cron.dao.po.UpMCronPo;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.domain.repo.InitFlatDateRepo;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.domain.vo.PlatDateInfo;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPInitadmService;
import com.alibaba.fastjson.JSONObject;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CronControl {
    private static final Logger log = LoggerFactory.getLogger(CronControl.class);
    private final int DEFAULT_LIMIT_SIZE = 999;
    @Resource
    private DynamicSqlMapper dynamicSqlMapper;
    @Resource
    private InitFlatDateRepo initFlatDateRepo;
    @Resource
    private UpPInitadmService upPInitadmService;
    @Autowired
    private UpMCronMapper upMCronMapper;
    @Autowired
    public RestTemplate restTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(JavaDict request) throws UnknownHostException, ParseException {
        log.info("==========\u5b9a\u65f6\u603b\u63a7-\u5904\u7406\u5f00\u59cb==========");
        String sysid = request.getString("sysid");
        String appid = request.getString("appid");
        String tradecode = request.getString("tradecode");
        String servername = InetAddress.getLocalHost().getHostName();
        String serverip = InetAddress.getLocalHost().getHostAddress();
        request.set("servername", (Object)servername);
        request.set("serverip", (Object)serverip);
        log.info("====1-\u5b9a\u65f6\u603b\u63a7-\u83b7\u53d6\u4e3b\u673a\u540d\u79f0[{}] IP\u5730\u5740[{}]===", (Object)servername, (Object)serverip);
        log.info("====2-\u5b9a\u65f6\u603b\u63a7-\u83b7\u53d6\u5f53\u524d\u65e5\u671f\u65f6\u95f4===");
        PlatDateInfo dateTime = this.initFlatDateRepo.getDateTime();
        String curdate = dateTime.getWorkdate();
        String curtime = dateTime.getWorktime();
        String curdatetime = curdate + " " + curtime;
        String curdweek = this.getWeekDay(new SimpleDateFormat("yyyyMMdd").parse(curdate)) + "";
        request.set("curdate", (Object)curdate);
        request.set("curtime", (Object)curtime);
        request.set("curdweek", (Object)curdweek);
        request.set("curdatetime", (Object)curdatetime);
        log.info("\u5f53\u524d\u65e5\u671f\u65f6\u95f4\u51fa\u53c2[curdate:[{}], curtime:[{}], curdweek:[{}], curdatetime:[{}]]", new Object[]{curdate, curtime, curdweek, curdatetime});
        log.info("====3-\u5b9a\u65f6\u603b\u63a7-\u83b7\u53d6\u6267\u884c\u6761\u6570\u9650\u5236\u53c2\u6570====");
        int limitNum = this.getLimitNum(sysid, appid, tradecode);
        log.info("\u6267\u884c\u6761\u6570\u9650\u5236\u53c2\u6570\u503c[{}]", (Object)limitNum);
        String limitStr = limitNum == -1 ? "" : " limit " + limitNum;
        String uuid = IdUtils.getId();
        log.info("====4-\u5b9a\u65f6\u603b\u63a7-\u83b7\u53d6uuid\u503c[{}]====", (Object)uuid);
        log.info("====5-\u5b9a\u65f6\u603b\u63a7-\u66f4\u65b0\u4efb\u52a1\u5217\u8868uuid\u503c====");
        String updateSql = "update up_p_cron set uuid = '%s' where sysid = '%s' and appid = '%s' and status = '1' and (uuid is null or uuid='')" + limitStr;
        int i = this.dynamicSqlMapper.handworkUpdate(String.format(updateSql, uuid, sysid, appid));
        log.info("====6-\u5b9a\u65f6\u603b\u63a7-\u83b7\u53d6\u4efb\u52a1\u5217\u8868====");
        String selectsql = "select sysid,appid,crontype,cronname,seqid,mutexflag,tradecode,commip,commport,req,year,month,dayweek,starttime,endtime,intercycle,uuid,status,remark,reserved1,reserved2,reserved3,url,countnum from up_p_cron where sysid = '%s' and appid = '%s' and status = '1' and uuid = '%s'";
        List list = this.dynamicSqlMapper.handworkSelect(String.format(selectsql, sysid, appid, uuid));
        log.info("\u5f85\u6267\u884c\u4efb\u52a1\u5217\u8868\u6570[{}]", (Object)list.size());
        if (null == list || list.size() == 0) {
            log.info("==========\u5b9a\u65f6\u603b\u63a7-\u5904\u7406\u7ed3\u675f==========");
            return;
        }
        try {
            log.info("====7-\u5b9a\u65f6\u603b\u63a7-\u8f6e\u8be2\u5904\u7406\u5b9a\u65f6\u4efb\u52a1====");
            for (Map map : list) {
                JavaDict crondict = new JavaDict();
                crondict.setMap(map);
                if (!this.checkContrl(request, crondict)) continue;
                this.sendReq(request, crondict);
            }
            log.info("-------\u4efb-\u52a1-\u5206-\u5272-\u7ebf--------");
            log.info("\u8f6e\u8be2\u5904\u7406\u7ed3\u675f");
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                log.error("\u5b9a\u65f6\u603b\u63a7-\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38[{}]", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                log.info("====8-\u5b9a\u65f6\u603b\u63a7-\u521d\u59cb\u5316\u914d\u7f6e\u8868uuid====");
                String updateUUIDNull = "update up_p_cron set uuid = '' where sysid = '%s' and appid = '%s' and uuid = '%s'";
                this.dynamicSqlMapper.handworkUpdate(String.format(updateUUIDNull, sysid, appid, uuid));
                throw throwable;
            }
            log.info("====8-\u5b9a\u65f6\u603b\u63a7-\u521d\u59cb\u5316\u914d\u7f6e\u8868uuid====");
            String updateUUIDNull = "update up_p_cron set uuid = '' where sysid = '%s' and appid = '%s' and uuid = '%s'";
            this.dynamicSqlMapper.handworkUpdate(String.format(updateUUIDNull, sysid, appid, uuid));
        }
        log.info("====8-\u5b9a\u65f6\u603b\u63a7-\u521d\u59cb\u5316\u914d\u7f6e\u8868uuid====");
        String updateUUIDNull = "update up_p_cron set uuid = '' where sysid = '%s' and appid = '%s' and uuid = '%s'";
        this.dynamicSqlMapper.handworkUpdate(String.format(updateUUIDNull, sysid, appid, uuid));
        log.info("==========\u5b9a\u65f6\u603b\u63a7-\u5904\u7406\u7ed3\u675f==========");
    }

    private int getWeekDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7) - 1;
    }

    @Async(value="scheduleSend")
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void sendReq(JavaDict request, JavaDict crondict) {
        String[] reqlist;
        log.info("\u5f53\u524d\u4efb\u52a1[{}-{}] \u89e6\u53d1\u5904\u7406", (Object)crondict.getString("tradecode"), (Object)crondict.getString("cronname"));
        HashMap<String, String> senderMap = new HashMap<String, String>();
        senderMap.put("sysid", crondict.getString("sysid"));
        senderMap.put("appid", crondict.getString("appid"));
        senderMap.put("tradecode", crondict.getString("tradecode"));
        senderMap.put("tradename", crondict.getString("cronname"));
        senderMap.put("url", crondict.getString("url"));
        String req = crondict.getString("req");
        for (String reqstr : reqlist = req.split("\\|")) {
            String[] reqkeyvalue = reqstr.split(":");
            if (reqkeyvalue.length <= 1) continue;
            senderMap.put(reqkeyvalue[0], reqkeyvalue[1]);
        }
        String requestUrl = "http://" + crondict.getString("commip");
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        String send = JSONObject.toJSONString(senderMap);
        HttpEntity requestEntity = new HttpEntity((Object)send, (MultiValueMap)httpHeaders);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(requestUrl, (Object)requestEntity, JSONObject.class, new Object[0]);
        JSONObject obj = (JSONObject)responseEntity.getBody();
        String errorCode = obj.getString("errorCode");
        if ("000000".equals(errorCode)) {
            log.info("\u5f53\u524d\u4efb\u52a1[{}-{}] \u5df2\u5b8c\u6210\u89e6\u53d1", (Object)crondict.getString("tradecode"), (Object)crondict.getString("cronname"));
        } else {
            String errorMsg = obj.getString("errorMsg");
            log.info("\u5f53\u524d\u4efb\u52a1[{}-{}] \u5df2\u5b8c\u6210\u89e6\u53d1,\u53d1\u751f\u9519\u8bef[{}-{}] ", new Object[]{crondict.getString("tradecode"), crondict.getString("cronname"), errorCode, errorMsg});
        }
    }

    private boolean checkContrl(JavaDict request, JavaDict crondict) throws ParseException {
        log.info("-------\u4efb-\u52a1-\u5206-\u5272-\u7ebf--------");
        String sysid = crondict.getString("sysid");
        String appid = crondict.getString("appid");
        String crontype = crondict.getString("crontype");
        String cronname = crondict.getString("cronname");
        String tradecode = crondict.getString("tradecode");
        String seqid = crondict.getString("seqid");
        String mutexflag = crondict.getString("mutexflag");
        String commip = crondict.getString("commip");
        String commport = crondict.getString("commport");
        String req = crondict.getString("req");
        String year = crondict.getString("year");
        String month = crondict.getString("month");
        String dayweek = crondict.getString("dayweek");
        String starttime = crondict.getString("starttime");
        String endtime = crondict.getString("endtime");
        String intercycle = crondict.getString("intercycle");
        String url = crondict.getString("url");
        String countnum = crondict.getString("countnum");
        String curdate = request.getString("curdate");
        String curtime = request.getString("curtime");
        String curdatetime = request.getString("curdatetime");
        String curdweek = request.getString("curdweek");
        String cronchkkey = request.getString("serverip", "");
        if ("1".equals(mutexflag)) {
            cronchkkey = "PUB";
        }
        if ("1".equals(crontype)) {
            log.info("\u5f53\u524d\u4efb\u52a1:[{}-{}] \u8c03\u7528\u6a21\u5f0f:[\u65e5\u671f\u65f6\u95f4\u70b9\u6a21\u5f0f]", (Object)tradecode, (Object)cronname);
            if (!"0".equals(year) && !year.equals(curdate.substring(0, 4))) {
                log.info("E01:\u5e74\u4efd\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curdate.substring(0, 4), (Object)year);
                return false;
            }
            if (!"0".equals(month) && !month.equals(curdate.substring(4, 6))) {
                log.info("E02:\u6708\u4efd\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curdate.substring(4, 6), (Object)month);
                return false;
            }
            if (!"0".equals(dayweek) && !dayweek.equals(curdate.substring(6, 8))) {
                log.info("E03:\u65e5\u671f\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curdate.substring(6, 8), (Object)dayweek);
                return false;
            }
            if (!starttime.equals(curtime.substring(0, 2))) {
                log.info("E04:\u89e6\u53d1\u5f00\u59cb\u5c0f\u65f6\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curtime.substring(0, 2), (Object)starttime);
                return false;
            }
            if (!endtime.equals(curtime.substring(2, 4))) {
                log.info("E05:\u89e6\u53d1\u5f00\u59cb\u5206\u949f\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curtime.substring(2, 4), (Object)endtime);
                return false;
            }
        } else if ("2".equals(crontype)) {
            log.info("\u5f53\u524d\u4efb\u52a1:[{}-{}] \u8c03\u7528\u6a21\u5f0f:[\u661f\u671f\u65f6\u95f4\u70b9\u6a21\u5f0f]", (Object)tradecode, (Object)cronname);
            if (!"0".equals(year) && !year.equals(curdate.substring(0, 4))) {
                log.info("E01:\u5e74\u4efd\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curdate.substring(0, 4), (Object)year);
                return false;
            }
            if (!"0".equals(month) && !month.equals(curdate.substring(4, 6))) {
                log.info("E02:\u6708\u4efd\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curdate.substring(4, 6), (Object)month);
                return false;
            }
            if (!"0".equals(dayweek) && !dayweek.equals(String.valueOf(Integer.parseInt(curdweek) + 1))) {
                log.info("E03:\u65e5\u671f\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)(Integer.parseInt(curdweek) + 1), (Object)dayweek);
                return false;
            }
            if (!starttime.equals(curtime.substring(0, 2))) {
                log.info("E04:\u89e6\u53d1\u5f00\u59cb\u5c0f\u65f6\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curtime.substring(0, 2), (Object)starttime);
                return false;
            }
            if (!endtime.equals(curtime.substring(2, 4))) {
                log.info("E05:\u89e6\u53d1\u5f00\u59cb\u5206\u949f\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curtime.substring(2, 4), (Object)endtime);
                return false;
            }
        } else if ("3".equals(crontype)) {
            log.info("\u5f53\u524d\u4efb\u52a1:[{}-{}] \u8c03\u7528\u6a21\u5f0f:[\u65e5\u671f\u65f6\u95f4\u6bb5\u6a21\u5f0f]", (Object)tradecode, (Object)cronname);
            if (!"0".equals(year) && !year.equals(curdate.substring(0, 4))) {
                log.info("E01:\u5e74\u4efd\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curdate.substring(0, 4), (Object)year);
                return false;
            }
            if (!"0".equals(month) && !month.equals(curdate.substring(4, 6))) {
                log.info("E02:\u6708\u4efd\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curdate.substring(4, 6), (Object)month);
                return false;
            }
            if (!"0".equals(dayweek) && !dayweek.equals(curdate.substring(6, 8))) {
                log.info("E03:\u65e5\u671f\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curdate.substring(6, 8), (Object)dayweek);
                return false;
            }
            if (Integer.parseInt(starttime) > Integer.parseInt(curtime.substring(0, 2))) {
                log.info("E04:\u89e6\u53d1\u5f00\u59cb\u65f6\u70b9\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curtime.substring(0, 2), (Object)starttime);
                return false;
            }
            if (Integer.parseInt(endtime) < Integer.parseInt(curtime.substring(0, 2))) {
                log.info("E05:\u89e6\u53d1\u7ed3\u675f\u65f6\u70b9\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curtime.substring(0, 2), (Object)endtime);
                return false;
            }
        } else if ("4".equals(crontype)) {
            log.info("\u5f53\u524d\u4efb\u52a1:[{}-{}] \u8c03\u7528\u6a21\u5f0f:[\u661f\u671f\u65f6\u95f4\u6bb5\u6a21\u5f0f]", (Object)tradecode, (Object)cronname);
            if (!"0".equals(year) && !year.equals(curdate.substring(0, 4))) {
                log.info("E01:\u5e74\u4efd\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curdate.substring(0, 4), (Object)year);
                return false;
            }
            if (!"0".equals(month) && !month.equals(curdate.substring(4, 6))) {
                log.info("E02:\u6708\u4efd\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curdate.substring(4, 6), (Object)month);
                return false;
            }
            if (!"0".equals(dayweek) && !dayweek.equals(String.valueOf(Integer.parseInt(curdweek) + 1))) {
                log.info("E03:\u65e5\u671f\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)(Integer.parseInt(curdweek) + 1), (Object)dayweek);
                return false;
            }
            if (Integer.parseInt(starttime) > Integer.parseInt(curtime.substring(0, 2))) {
                log.info("E04:\u89e6\u53d1\u5f00\u59cb\u65f6\u70b9\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curtime.substring(0, 2), (Object)starttime);
                return false;
            }
            if (Integer.parseInt(endtime) < Integer.parseInt(curtime.substring(0, 2))) {
                log.info("E05:\u89e6\u53d1\u7ed3\u675f\u65f6\u70b9\u4e0d\u7b26[\u7cfb\u7edf\u65f6\u95f4:[{}], \u914d\u7f6e\u65f6\u95f4:[{}]]", (Object)curtime.substring(0, 2), (Object)endtime);
                return false;
            }
        } else {
            log.info("E00:\u4e0d\u652f\u6301\u7684\u8c03\u5ea6\u7c7b\u578b[{}]", (Object)crontype);
            return false;
        }
        UpMCronPo upMCronPo = new UpMCronPo();
        upMCronPo.setSysid(sysid);
        upMCronPo.setAppid(appid);
        upMCronPo.setCrontype(crontype);
        upMCronPo.setTradecode(tradecode);
        upMCronPo.setTradename(cronname);
        upMCronPo.setMutexflag(mutexflag);
        upMCronPo.setCurdate(request.getString("curdate"));
        upMCronPo.setCurtime(request.getString("curtime"));
        upMCronPo.setServerip(request.getString("serverip"));
        upMCronPo.setServername(request.getString("servername"));
        if ("1".equals(crontype) || "2".equals(crontype)) {
            upMCronPo.setCurseq("1");
            upMCronPo.setCronchkkey(cronchkkey);
            try {
                this.upMCronMapper.insert(upMCronPo);
            }
            catch (DuplicateKeyException exception) {
                log.info("\u5f53\u524d\u4efb\u52a1:[{}-{}] \u5df2\u88ab\u89e6\u53d1\uff0c\u6b64\u6b21\u8df3\u8fc7", (Object)tradecode, (Object)cronname);
                return false;
            }
            catch (Exception e) {
                log.error("E99:\u767b\u8bb0\u6d41\u6c34\u8868\u5931\u8d25[{}]", (Object)e.getMessage());
                return false;
            }
        }
        String strSql = "select curdate, curtime, curseq from up_m_cron where sysid = '%s' and appid = '%s' and tradecode = '%s' and curdate = '%s' order by curseq+0 desc";
        List mapsList = this.dynamicSqlMapper.handworkSelect(String.format(strSql, sysid, appid, tradecode, curdate));
        if (mapsList.size() == 0) {
            upMCronPo.setCurseq("1");
            upMCronPo.setCronchkkey(cronchkkey);
            try {
                this.upMCronMapper.insert(upMCronPo);
            }
            catch (DuplicateKeyException exception) {
                log.info("\u5f53\u524d\u4efb\u52a1:[{}-{}] \u5df2\u88ab\u89e6\u53d1\uff0c\u6b64\u6b21\u8df3\u8fc7", (Object)tradecode, (Object)cronname);
                return false;
            }
            catch (Exception e) {
                log.error("E99:\u767b\u8bb0\u6d41\u6c34\u8868\u5931\u8d25[{}]", (Object)e.getMessage());
                return false;
            }
            return true;
        }
        String preRunTime = ((Map)mapsList.get(0)).get("curdate") + " " + ((Map)mapsList.get(0)).get("curtime");
        String precurseq = ((Map)mapsList.get(0)).get("curseq") + "";
        Date preDate = new SimpleDateFormat("yyyyMMdd HHmmss").parse(preRunTime);
        Date curDate = new SimpleDateFormat("yyyyMMdd HHmmss").parse(request.getString("curdate") + " " + request.getString("curtime"));
        if (curDate.compareTo(preDate) < 0) {
            log.info("\u5f53\u524d\u4efb\u52a1:[{}-{}] \u5df2\u88ab\u89e6\u53d1\uff0c\u6b64\u6b21\u8df3\u8fc7", (Object)tradecode, (Object)cronname);
            return false;
        }
        long difftime = (curDate.getTime() - preDate.getTime()) / 1000L;
        long intercyclel = 0L;
        intercyclel = intercycle.startsWith("-") ? Long.parseLong(intercycle.substring(1)) : Long.parseLong(intercycle) * 60L;
        if (intercyclel <= difftime) {
            upMCronPo.setCurseq(Integer.parseInt(precurseq) + 1 + "");
            upMCronPo.setCronchkkey(cronchkkey);
            try {
                this.upMCronMapper.insert(upMCronPo);
            }
            catch (DuplicateKeyException exception) {
                log.info("\u5f53\u524d\u4efb\u52a1:[{}-{}] \u5df2\u88ab\u89e6\u53d1\uff0c\u6b64\u6b21\u8df3\u8fc7", (Object)tradecode, (Object)cronname);
                return false;
            }
            catch (Exception e) {
                log.error("E99:\u767b\u8bb0\u6d41\u6c34\u8868\u5931\u8d25[{}]", (Object)e.getMessage());
                return false;
            }
        } else {
            log.info("\u5f53\u524d\u4efb\u52a1:[{}-{}] \u672a\u5230\u5904\u7406\u65f6\u95f4\uff0c\u6b64\u6b21\u8df3\u8fc7", (Object)tradecode, (Object)cronname);
            return false;
        }
        return true;
    }

    private boolean isLessThanCountNum(String countNum, String curdate, String tradecode) {
        int countNumInt = Integer.valueOf(countNum);
        if (countNumInt == -1) {
            return true;
        }
        String sql = "select count(*) as count from up_m_cron where tradecode='%s' and curdate='%s'";
        List mapsList = this.dynamicSqlMapper.handworkSelect(String.format(sql, tradecode, curdate));
        int count = Integer.valueOf(((Map)mapsList.get(0)).get("count").toString());
        if (this.intCompareTo(count, countNumInt) == -1) {
            return true;
        }
        log.info("\u8be5\u4ea4\u6613[{}}][{}]\u8fd9\u5929\u8fd0\u884c\u7684\u6b21\u6570[{}]\u4e0d\u5c0f\u4e8e\u8bbe\u7f6e\u8fd0\u884c\u6b21\u6570[{}]", new Object[]{tradecode, curdate, count, countNumInt});
        return false;
    }

    private boolean isCanRunIntercycle(String curdatetime, String curdate, String tradecode, String intercycle) throws ParseException {
        String strSql = String.format(" select curdate,curtime from up_m_cron where tradecode = '%s' and curdate = '%s' order by curseq+0 desc", tradecode, curdate);
        List mapsList = this.dynamicSqlMapper.handworkSelect(strSql);
        if (mapsList.size() == 0) {
            return true;
        }
        String preRunTime = ((Map)mapsList.get(0)).get("curdate") + " " + ((Map)mapsList.get(0)).get("curtime");
        Calendar preCalendar = Calendar.getInstance();
        preCalendar.setTime(new SimpleDateFormat("yyyyMMdd HHmmss").parse(preRunTime));
        if (intercycle.startsWith("-")) {
            preCalendar.add(Integer.parseInt(intercycle.substring(1)), 13);
        } else {
            preCalendar.add(Integer.parseInt(intercycle), 12);
        }
        Date runDate = preCalendar.getTime();
        Date curdatetimeDate = new SimpleDateFormat("yyyyMMdd HHmmss").parse(curdatetime);
        return curdatetimeDate.compareTo(runDate) == 1;
    }

    private int getLimitNum(String sysid, String appid, String tradecode) {
        int num;
        String sql = "select initvalue from up_p_initadm where sysid = '%s' and appid = '%s' and tradecode = '%s' and mainclass = 'PUB' and subclass = 'PUB' and addflag = '0'";
        List list = this.dynamicSqlMapper.handworkSelect(String.format(sql, sysid, appid, tradecode));
        try {
            num = null == list || list.size() == 0 ? 999 : Integer.parseInt(((Map)list.get(0)).get("initvalue").toString());
        }
        catch (NumberFormatException e) {
            num = 999;
        }
        if (this.intCompareTo(num, 0) != 1 && this.intCompareTo(-1, num) != 0) {
            num = 999;
        }
        return num;
    }

    private int intCompareTo(int a, int b) {
        Integer intA = a;
        Integer intB = b;
        return intA.compareTo(intB);
    }
}

