/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.busideal.component.business.service;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.pay.common.base.dto.UpPSeqParam;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import cn.com.yusys.yusp.pay.common.base.util.SequenceUtil;
import cn.com.yusys.yusp.pay.common.base.util.TradeUtils;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.func.FlowFlagService;
import cn.com.yusys.yusp.pay.common.busideal.flow.domain.constant.FlowField;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TradeInitService {
    @Autowired
    private FlowFlagService flowFlagService;
    @Autowired
    private SequenceUtil sequenceUtil;

    public YuinResult initSequence(JavaDict request) {
        if (this.flowFlagService.chkCommsgidFlag(request, String.format("%s[%s]", "\u5224\u65ad\u662f\u5426\u83b7\u53d6\u901a\u4fe1\u7ea7\u62a5\u6587\u6807\u8bc6\u53f7", "__commsgidflag__")).success()) {
            request.set("crtcommsgid", (Object)this.getSeqComMsgid(request.getString("workdate")));
            LogUtils.printInfo((Object)this, (String)"[{}][{}]", (Object[])new Object[]{"crtcommsgid", request.getString("crtcommsgid")});
        }
        if (this.flowFlagService.chkMsgidFlag(request, String.format("%s[%s]", "\u5224\u65ad\u662f\u5426\u83b7\u53d6\u62a5\u6587\u6807\u8bc6\u53f7", "__msgidflag__")).success()) {
            if ("BEPS".equals(request.getString("appid"))) {
                YuinResult result = TradeUtils.P_Trade_LocalSynComp((String)"getBepsSeqMsgid", (String)"BepsGetService", (Object[])new Object[]{request});
                if (!result.success()) {
                    return result;
                }
            } else {
                request.set("crtmsgid", (Object)this.getSeqMsgid(request.getString("appid"), request.getString("busidate", request.getString("__busidate__")), request.getString("sendclearbank"), request.getString("crtdetailno")));
                LogUtils.printInfo((Object)this, (String)"[{}][{}]", (Object[])new Object[]{"crtmsgid", request.getString("crtmsgid")});
            }
        }
        if (this.flowFlagService.chkEndtoendidFlag(request, String.format("%s[%s]", "\u5224\u65ad\u662f\u5426\u83b7\u53d6\u7aef\u5bf9\u7aef\u6807\u8bc6\u53f7", "__endtoendidflag__")).success()) {
            request.set("crtendtoendid", (Object)this.getSeqEndtoendid(request.getString("workdate"), request.getString("worktime"), request.getString("workseqid")));
            LogUtils.printInfo((Object)this, (String)"[{}][{}]", (Object[])new Object[]{"crtendtoendid", request.getString("crtendtoendid")});
        }
        if (this.flowFlagService.chkDetailnoFlag(request, String.format("%s[%s]", "\u5224\u65ad\u662f\u5426\u83b7\u53d6\u660e\u7ec6\u6807\u8bc6\u53f7", "__detailnoflag__")).success()) {
            request.set("crtdetailno", (Object)this.getSeqDetailno(request.getString("appid"), request.getString("busidate", request.getString("__busidate__")), request.getString("sendclearbank"), request.getString("crtmsgid")));
            LogUtils.printInfo((Object)this, (String)"[{}][{}]", (Object[])new Object[]{"crtdetailno", request.getString("crtdetailno")});
        }
        if (this.flowFlagService.chkBankseqnoFlag(request, String.format("%s[%s]", "\u5224\u65ad\u662f\u5426\u83b7\u53d6\u8bf7\u6c42\u6838\u5fc3\u6d41\u6c34\u4fe1\u606f", "__bankseqnoflag__")).success()) {
            request.set("bankdate", (Object)request.getString("busidate", request.getString("__busidate__")));
            request.set("bankseqno", (Object)this.getSeqBankseqno());
            LogUtils.printInfo((Object)this, (String)"[{}][{}]", (Object[])new Object[]{"bankdate", request.getString("bankdate")});
            LogUtils.printInfo((Object)this, (String)"[{}][{}]", (Object[])new Object[]{"bankseqno", request.getString("bankseqno")});
        }
        return YuinResult.newSuccessResult(null);
    }

    public String getSequence(String seqid, String length) {
        return this.getSequence(seqid, length, '0');
    }

    public String getSequence(String seqid, String length, char fillString) {
        UpPSeqParam upPSeqParam = new UpPSeqParam();
        upPSeqParam.setSeqid(seqid);
        upPSeqParam.setSeqlen(length);
        upPSeqParam.setFillString(fillString);
        return this.sequenceUtil.getSequence(upPSeqParam);
    }

    public String getSequence(JavaDict request, String seqid, String length, char fillString, String[] formate) {
        UpPSeqParam upPSeqParam = new UpPSeqParam();
        HashMap<String, String> map = new HashMap<String, String>();
        String formatestr = "";
        for (int i = 0; i < formate.length; ++i) {
            formatestr = formatestr + '{' + formate[i] + '}';
            map.put(formate[i], request.getString(formate[i], ""));
        }
        formatestr = formatestr + '{' + "SEQ" + '}';
        upPSeqParam.setSeqid(seqid);
        upPSeqParam.setSeqlen(length);
        upPSeqParam.setFillString(fillString);
        upPSeqParam.setFormate(formatestr);
        upPSeqParam.setParamMap(map);
        return this.sequenceUtil.getSequence(upPSeqParam);
    }

    public String getSeqWorkSeqid() {
        return this.getSequence("workseqid", "8");
    }

    public String getSeqComMsgid(String workdate) {
        JavaDict javaDict = new JavaDict();
        javaDict.set("workdate", (Object)workdate);
        return this.getSequence(javaDict, "commsgid", "8", '0', new String[]{"workdate"});
    }

    public String getSeqMsgid(String appid, String busidate, String sendclearbank, String detailno) {
        if (FlowField.CNAPS_APPID_LIST.contains(appid)) {
            return String.format("%s%s", busidate, this.getSequence("msgid", "8"));
        }
        if (FlowField.IBPS_APPID_LIST.contains(appid)) {
            if (!StringUtils.isEmpty((CharSequence)detailno)) {
                return detailno;
            }
            if (!StringUtils.isEmpty((CharSequence)sendclearbank)) {
                return String.format("%s%s%s", sendclearbank, busidate, this.getSequence("msgid", "8"));
            }
            LogUtils.printWarn((Object)this, (String)"\u8d85\u7f51\u7cfb\u7edf\u5e8f\u5217\u53f7\u672a\u914d\u7f6e\u884c\u53f7\u4fe1\u606f\uff0c\u9ed8\u8ba4\u4f7f\u7528\u201c0\u201d\u8fdb\u884c\u586b\u5145\uff01", (Object[])new Object[0]);
            return String.format("%s%s%s", "000000000000", busidate, this.getSequence("msgid", "8"));
        }
        if (FlowField.NCS_APPID_LIST.contains(appid)) {
            if (!StringUtils.isEmpty((CharSequence)detailno)) {
                return detailno;
            }
            return String.format("%s00%s", busidate, this.getSequence("msgid", "8"));
        }
        LogUtils.printWarn((Object)this, (String)"\u672a\u914d\u7f6e\u5f53\u524d\u5e94\u7528\u6807\u8bc6\u3010{}\u3011\uff0c\u9ed8\u8ba4\u4f7f\u7528\u4eba\u884c\u89c4\u5219\u751f\u6210", (Object[])new Object[]{appid});
        return String.format("%s%s", busidate, this.getSequence("msgid", "8"));
    }

    public String getSeqDetailno(String appid, String busidate, String sendclearbank, String msgid) {
        if (FlowField.CNAPS_APPID_LIST.contains(appid)) {
            return String.format("%s%s", busidate, this.getSequence("msgid", "8"));
        }
        if (FlowField.IBPS_APPID_LIST.contains(appid)) {
            if (!StringUtils.isEmpty((CharSequence)msgid)) {
                return msgid;
            }
            if (!StringUtils.isEmpty((CharSequence)sendclearbank)) {
                return String.format("%s%s%s", sendclearbank, busidate, this.getSequence("msgid", "8"));
            }
            LogUtils.printWarn((Object)this, (String)"\u8d85\u7f51\u7cfb\u7edf\u5e8f\u5217\u53f7\u672a\u914d\u7f6e\u884c\u53f7\u4fe1\u606f\uff0c\u9ed8\u8ba4\u4f7f\u7528\u201c0\u201d\u8fdb\u884c\u586b\u5145\uff01", (Object[])new Object[0]);
            return String.format("%s%s%s", "000000000000", busidate, this.getSequence("msgid", "8"));
        }
        if (FlowField.NCS_APPID_LIST.contains(appid)) {
            if (!StringUtils.isEmpty((CharSequence)msgid)) {
                return msgid;
            }
            return String.format("%s00%s", busidate, this.getSequence("msgid", "8"));
        }
        LogUtils.printWarn((Object)this, (String)"\u672a\u914d\u7f6e\u5f53\u524d\u5e94\u7528\u6807\u8bc6\u3010{}\u3011\uff0c\u9ed8\u8ba4\u4f7f\u7528\u4eba\u884c\u89c4\u5219\u751f\u6210", (Object[])new Object[]{appid});
        return String.format("%s%s", busidate, this.getSequence("msgid", "8"));
    }

    public String getSeqEndtoendid(String workdate, String worktime, String workseqid) {
        JavaDict javaDict = new JavaDict();
        javaDict.set("workdate", (Object)workdate);
        javaDict.set("worktime", (Object)worktime);
        javaDict.set("workseqid", (Object)workseqid);
        return this.getSequence(javaDict, "endtoendid", "8", '0', new String[]{"workdate", "worktime", "workseqid"});
    }

    public String getSeqBankseqno() {
        return this.getSequence("bankseqno", "8");
    }
}

