/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.busideal.flow.application.service;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.pay.common.base.component.code.ThreadParam;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import cn.com.yusys.yusp.pay.common.base.util.SequenceUtil;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.TradeCacheService;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPIntrademapService;
import com.alibaba.fastjson.JSONObject;
import java.net.InetAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class TradePreTreatService {
    @Autowired
    private UpPIntrademapService upPIntrademapService;
    @Autowired
    private SequenceUtil sequenceUtil;
    @Value(value="${UPP.appid:UPP}")
    private String appid;
    @Autowired
    private TradeCacheService tradeCacheService;

    public void tradePretreat(JavaDict requestDict, JavaDict request) throws Exception {
        String requestUrl = this.getRequestUrl();
        LogUtils.printInfo((Object)this, (String)"\u3010\u4ea4\u6613\u8bf7\u6c42URL\u63a5\u5165: {}\u3011", (Object[])new Object[]{requestUrl});
        LogUtils.printInfo((Object)this, (String)"\u63a5\u6536\u62a5\u6587MSG\u4fe1\u606f: {}", (Object[])new Object[]{new JSONObject(requestDict.get())});
        LogUtils.printInfo((Object)this, (String)"\u3010\u4ea4\u6613\u9884\u5904\u7406\u5f00\u59cb\u3011", (Object[])new Object[0]);
        request.set("sysid", (Object)"UPP");
        LogUtils.printInfo((Object)this, (String)"**\u7cfb\u7edf\u6807\u8bc6[{}][{}]", (Object[])new Object[]{"sysid", "UPP"});
        this.getAppid(requestDict, request);
        LogUtils.printInfo((Object)this, (String)"**\u5e94\u7528\u6807\u8bc6[{}][{}]", (Object[])new Object[]{"appid", request.getString("appid")});
        this.getComSyscode(requestDict, request);
        LogUtils.printInfo((Object)this, (String)"**\u901a\u8baf\u7cfb\u7edf\u6807\u8bc6[{}][{}]", (Object[])new Object[]{"syscode", request.getString("syscode")});
        this.getRequestAttributes(requestDict, request);
        LogUtils.printInfo((Object)this, (String)"**\u7cfb\u7edf\u63a5\u5165\u4ea4\u6613\u7801[{}][{}]", (Object[])new Object[]{"systradecode", request.getString("systradecode")});
        this.upPIntrademapService.getIntrademap(requestDict, request);
        LogUtils.printInfo((Object)this, (String)"**\u4ea4\u6613\u7801[{}][{}]", (Object[])new Object[]{"tradecode", request.getString("tradecode")});
        LogUtils.printInfo((Object)this, (String)"**\u4ea4\u6613\u540d\u79f0[{}][{}]", (Object[])new Object[]{"tradename", request.getString("tradename")});
        LogUtils.printInfo((Object)this, (String)"**\u540c\u5f02\u6b65\u901a\u8baf\u6807\u8bc6[{}][{}]", (Object[])new Object[]{"__directrspflag__", request.getString("__directrspflag__")});
        request.set("hostid", (Object)InetAddress.getLocalHost().getHostName());
        LogUtils.printInfo((Object)this, (String)"\u521d\u59cb\u5316**\u4e3b\u673a\u6807\u8bc6[{}][{}]", (Object[])new Object[]{"hostid", request.getString("hostid")});
        LogUtils.printInfo((Object)this, (String)"\u521d\u59cb\u5316**\u5168\u5c40\u6d41\u6c34\u53f7[{}][{}]", (Object[])new Object[]{"globalseq", request.getString("globalseq")});
        if (!StringUtils.isBlank((CharSequence)request.getString("asynctid"))) {
            LogUtils.printInfo((Object)this, (String)"\u521d\u59cb\u5316**\u540c\u5f02\u6b65\u901a\u8baf\u4fe1\u606f[{}][{}]", (Object[])new Object[]{"asynctid", request.getString("asynctid")});
        }
        LogUtils.printInfo((Object)this, (String)"\u8bfb\u53d6\u7f13\u5b58\u914d\u7f6e\u6570\u636e...", (Object[])new Object[0]);
        this.tradeCacheService.tradeCacheInit(request);
        LogUtils.printInfo((Object)this, (String)"\u8bfb\u53d6\u7f13\u5b58\u914d\u7f6e\u6570\u636e\u5b8c\u6210", (Object[])new Object[0]);
        LogUtils.printInfo((Object)this, (String)"\u3010\u4ea4\u6613\u9884\u5904\u7406\u7ed3\u675f\uff0c\u51c6\u5907\u5f00\u59cb\u5904\u7406\u4ea4\u6613[{}]\u3011", (Object[])new Object[]{request.getString("tradecode")});
    }

    private String getRequestUrl() {
        String requestUrl = "";
        if (!ObjectUtils.isEmpty((Object)RequestContextHolder.getRequestAttributes()) && !StringUtils.isBlank((CharSequence)((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getRequestURI())) {
            requestUrl = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getRequestURI();
            ThreadParam.logPrefix.set(requestUrl);
        }
        return requestUrl;
    }

    private void getAppid(JavaDict requestDict, JavaDict request) {
        if (!StringUtils.isBlank((CharSequence)requestDict.getString("appid"))) {
            request.set("appid", (Object)requestDict.getString("appid"));
        } else if (!StringUtils.isBlank((CharSequence)requestDict.getString("transaction.body.request.SysId"))) {
            request.set("appid", (Object)requestDict.getString("transaction.body.request.SysId"));
        } else if (!StringUtils.isBlank((CharSequence)requestDict.getString("transaction.body.request.SysID"))) {
            request.set("appid", (Object)requestDict.getString("transaction.body.request.SysID"));
        } else if (!StringUtils.isBlank((CharSequence)requestDict.getString("transaction.body.request.SNBReqHead.SysId"))) {
            request.set("appid", (Object)requestDict.getString("transaction.body.request.SNBReqHead.SysId"));
        } else if (!"UPP".equals(this.appid)) {
            request.set("appid", (Object)this.appid);
        } else {
            LogUtils.printError((Object)this, (String)"\u65e0\u6cd5\u8bc6\u522b\u7684\u5e94\u7528\u6807\u8bc6\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", (Object[])new Object[0]);
            throw new RuntimeException("\u65e0\u6cd5\u8bc6\u522b\u7684\u5e94\u7528\u6807\u8bc6\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
    }

    private void getComSyscode(JavaDict requestDict, JavaDict request) {
        if (!StringUtils.isBlank((CharSequence)requestDict.getString("tradecode"))) {
            request.set("syscode", (Object)request.getString("appid"));
        } else if (!StringUtils.isBlank((CharSequence)requestDict.getString("transaction.header.msg.msgCd"))) {
            request.set("syscode", (Object)"ESB");
        } else {
            LogUtils.printError((Object)this, (String)"\u65e0\u6cd5\u8bc6\u522b\u7684\u63a5\u5165\u7cfb\u7edf\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", (Object[])new Object[0]);
            throw new RuntimeException("\u65e0\u6cd5\u8bc6\u522b\u7684\u63a5\u5165\u7cfb\u7edf\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
    }

    private void getRequestAttributes(JavaDict requestDict, JavaDict request) {
        if (!ObjectUtils.isEmpty((Object)RequestContextHolder.getRequestAttributes())) {
            String globalseq;
            if (!StringUtils.isBlank((CharSequence)((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getRequestURI())) {
                String requestURI = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getRequestURI();
                String[] uris = requestURI.split("/");
                request.set("systradecode", (Object)uris[uris.length - 1]);
            }
            if (!StringUtils.isBlank((CharSequence)((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getHeader("asynctid"))) {
                request.set("asynctid", (Object)((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getHeader("asynctid"));
            }
            if (!StringUtils.isBlank((CharSequence)((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getHeader("globalseq"))) {
                globalseq = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getHeader("globalseq");
                request.set("globalseq", (Object)globalseq);
            } else {
                try {
                    globalseq = this.sequenceUtil.getGlobalSequence();
                    request.set("globalseq", (Object)globalseq);
                }
                catch (Exception e) {
                    LogUtils.printError((Object)this, (String)"\u5168\u5c40\u6d41\u6c34\u53f7\u83b7\u53d6\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fdb\u884c\u76f8\u5173\u4fe1\u606f\u767b\u8bb0\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", (Object[])new Object[0]);
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)request.getString("systradecode")) && !StringUtils.isBlank((CharSequence)requestDict.getString("tradecode"))) {
            request.set("systradecode", (Object)requestDict.getString("tradecode"));
        }
        if (StringUtils.isBlank((CharSequence)request.getString("systradecode"))) {
            LogUtils.printError((Object)this, (String)"\u672a\u8bc6\u522b\u5230\u7cfb\u7edf\u63a5\u5165\u4ea4\u6613\u7801\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", (Object[])new Object[0]);
            throw new RuntimeException("\u672a\u8bc6\u522b\u5230\u7cfb\u7edf\u63a5\u5165\u4ea4\u6613\u7801\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
    }
}

