/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.busideal.component.business.service;

import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.IDict;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.StringUtilEx;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPBankmapService;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPBrnoBankInfoGetService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.func.FlowFlagService;
import cn.com.yusys.yusp.pay.common.busideal.flow.domain.constant.ErrorCode;
import cn.com.yusys.yusp.pay.common.busideal.flow.domain.tools.Tools;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class PubInitService {
    @Resource
    private FlowFlagService flowFlagService;
    @Resource
    private UpPBrnoBankInfoGetService upPBrnoBankInfoGetService;
    @Resource
    private UpPBankinfoService upPBankinfoService;
    @Resource
    private UpPBankmapService upPBankmapService;

    public YuinResult getBankInfo(JavaDict request) throws Exception {
        JavaDict result = new JavaDict();
        if (request.hasKey("mbflag") && "1".equals(request.getString("mbflag")) && request.hasKey("__reqrspflag__") && !"1".equals(request.getString("__reqrspflag__"))) {
            YuinResult norecvresult;
            YuinResult nosendresult;
            if (this.flowFlagService.chkGetSendBankFlag(request, String.format("%s[%s]", "\u5224\u65ad\u662f\u5426\u83b7\u53d6\u53d1\u9001\u884c\u884c\u540d\u884c\u53f7\u4fe1\u606f", "__getsendbankflag__")).success() && (nosendresult = this.getSendBankInfoByNostro(request)).success() && nosendresult.getOutputParams() != null) {
                result.set((IDict)((JavaDict)nosendresult.getOutputParams().get(0)));
            }
            if (this.flowFlagService.chkGetRecvBankFlag(request, String.format("%s[%s]", "\u5224\u65ad\u662f\u5426\u83b7\u53d6\u63a5\u6536\u884c\u884c\u540d\u884c\u53f7\u4fe1\u606f", "__getrecvbankflag__")).success() && (norecvresult = this.getRecvBankInfoByNostro(request)).success() && norecvresult.getOutputParams() != null) {
                result.set((IDict)((JavaDict)norecvresult.getOutputParams().get(0)));
            }
        }
        return YuinResult.newSuccessResult((Object[])new Object[]{result});
    }

    public YuinResult getSendBankInfoByNostro(JavaDict request) throws Exception {
        if (StringUtilEx.isNullOrEmpty((String)request.getString("brno"))) {
            return YuinResult.newFailureResult((String)"E1109", (String)ErrorCode.getErrmsg((String)"E1109"));
        }
        JavaDict result = new JavaDict();
        YuinResult res = this.upPBrnoBankInfoGetService.getBankInfoByBrno(request, request.getString("brno"), new String[]{"sendbank", "sendbankname", "sendclearbank", "sendclearbankname"});
        if (!res.success() || res.getOutputParams() == null) {
            return res;
        }
        result.set((IDict)((JavaDict)res.getOutputParams().get(0)));
        Tools.dealKeyValue(this, result);
        return YuinResult.newSuccessResult((Object[])new Object[]{result});
    }

    public YuinResult getRecvBankInfoByNostro(JavaDict request) throws Exception {
        JavaDict result = new JavaDict();
        String bank = null;
        if (request.hasKey("recvbank") && !request.getString("recvbank").isEmpty()) {
            bank = request.getString("recvbank");
        } else if (request.hasKey("dcflag") && "1".equals(request.getString("dcflag")) && request.hasKey("payerbank") && !request.getString("payerbank").isEmpty()) {
            bank = request.getString("payerbank");
        } else if (request.hasKey("dcflag") && "2".equals(request.getString("dcflag")) && request.hasKey("payeebank") && !request.getString("payeebank").isEmpty()) {
            bank = request.getString("payeebank");
        } else if (request.hasKey("recvclearbank") && !request.getString("recvclearbank").isEmpty()) {
            bank = request.getString("recvclearbank");
        } else if (request.hasKey("dcflag") && "1".equals(request.getString("dcflag")) && request.hasKey("payerclearbank") && !request.getString("payerclearbank").isEmpty()) {
            bank = request.getString("payerclearbank");
        } else if (request.hasKey("dcflag") && "2".equals(request.getString("dcflag")) && request.hasKey("payeeclearbank") && !request.getString("payeeclearbank").isEmpty()) {
            bank = request.getString("payeeclearbank");
        } else {
            return YuinResult.newSuccessResult(null);
        }
        YuinResult res = this.upPBankinfoService.getBankInfoByBank(request, bank, new String[]{"recvbank", "recvbankname", "recvclearbank", "recvclearbankname"});
        if (!res.success() || res.getOutputParams() == null) {
            return res;
        }
        result.set((IDict)((JavaDict)res.getOutputParams().get(0)));
        Tools.dealKeyValue(this, result);
        return YuinResult.newSuccessResult((Object[])new Object[]{result});
    }

    public YuinResult getBrnoInfo(JavaDict request) {
        JavaDict result = new JavaDict();
        if (request.hasKey("mbflag") && "2".equals(request.getString("mbflag"))) {
            String recvbank = null;
            recvbank = request.hasKey("dcflag") && "1".equals(request.getString("dcflag")) && request.hasKey("payerbank") && !request.getString("payerbank").isEmpty() ? request.getString("payerbank") : (request.hasKey("dcflag") && "2".equals(request.getString("dcflag")) && request.hasKey("payeebank") && !request.getString("payeebank").isEmpty() ? request.getString("payeebank") : (request.hasKey("recvbank") && !request.getString("recvbank").isEmpty() ? request.getString("recvbank") : (request.hasKey("dcflag") && "1".equals(request.getString("dcflag")) && request.hasKey("payerclearbank") && !request.getString("payerclearbank").isEmpty() ? request.getString("payerclearbank") : (request.hasKey("dcflag") && "2".equals(request.getString("dcflag")) && request.hasKey("payeeclearbank") && !request.getString("payeeclearbank").isEmpty() ? request.getString("payeeclearbank") : request.getString("recvclearbank")))));
            if (recvbank != null) {
                YuinResult vobrnoresult = this.upPBankmapService.getBankMapByBankno(request, recvbank, new String[]{"brno", "brname", "clearbrno", "bankno", "bankname"});
                if (vobrnoresult.success() && vobrnoresult.getOutputParams() != null) {
                    result.set((IDict)((JavaDict)vobrnoresult.getOutputParams().get(0)));
                } else {
                    return vobrnoresult;
                }
            }
        }
        Tools.dealKeyValue(this, result);
        return YuinResult.newSuccessResult((Object[])new Object[]{result});
    }
}

