/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.base.component.dboper.service;

import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.pay.common.base.component.dboper.dao.mapper.DynamicSqlMapper;
import cn.com.yusys.yusp.pay.common.base.component.dboper.domain.tools.TableUtil;
import cn.com.yusys.yusp.pay.common.base.component.dboper.domain.vo.Col;
import cn.com.yusys.yusp.pay.common.base.component.dboper.domain.vo.DynamicSql;
import cn.com.yusys.yusp.pay.common.base.component.dboper.domain.vo.Table;
import cn.com.yusys.yusp.pay.common.base.component.dboper.domain.vo.TableInsert;
import cn.com.yusys.yusp.pay.common.base.component.dboper.domain.vo.UpPBusistsctlVo;
import cn.com.yusys.yusp.pay.common.base.component.dboper.domain.vo.UpPDbactionQueryVo;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.UpPBusistsctlService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DynamicSqlService {
    private static final Logger logger = LoggerFactory.getLogger(DynamicSqlService.class);
    @Autowired
    private DynamicSqlMapper dynamicSqlMapper;
    @Autowired
    private UpPBusistsctlService upPBusistsctlService;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public YuinResultDto operDynamicSql(JavaDict data, List<UpPDbactionQueryVo> actionkeyList) throws Exception {
        DynamicSql dynamicSql = new DynamicSql();
        dynamicSql.setData(data);
        YuinResultDto resultDto = new YuinResultDto();
        for (UpPDbactionQueryVo upPDbactionQueryVo : actionkeyList) {
            dynamicSql.setUpPDbaction(upPDbactionQueryVo);
            resultDto = this.dynamic(dynamicSql);
            if (resultDto.isSuccess()) continue;
            logger.error("\u52a8\u6001\u6570\u636eactionkey\u64cd\u4f5c\u5f02\u5e38:" + upPDbactionQueryVo.getActionkey() + "[" + upPDbactionQueryVo.getOpertype() + "]");
            return YuinResultDto.failure("S9002", String.format("\u52a8\u6001\u6570\u636eactionkey\u64cd\u4f5c\u5f02\u5e38:%s[%s]%s", upPDbactionQueryVo.getActionkey(), upPDbactionQueryVo.getOpertype(), resultDto.getHead().getResponseMsg()));
        }
        return resultDto;
    }

    public YuinResultDto dynamic(DynamicSql dynamicSql) throws Exception {
        if (null == dynamicSql || null == dynamicSql.getUpPDbaction()) {
            throw new Exception("\u64cd\u4f5c\u6570\u636e\u5f02\u5e38\uff0c\u5165\u53c2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String opertype = dynamicSql.getUpPDbaction().getOpertype();
        if ("I".equals(opertype)) {
            int result = this.insert(dynamicSql);
            if (result > 0) {
                return YuinResultDto.sucess(result);
            }
            return YuinResultDto.failure("500", "\u65b0\u589e\u5931\u8d25");
        }
        if ("U".equals(opertype)) {
            int result = this.update(dynamicSql);
            if (result > 0) {
                return YuinResultDto.sucess(result);
            }
            return YuinResultDto.failure("500", "\u4fee\u6539\u5931\u8d25");
        }
        if ("D".equals(opertype)) {
            int result = this.delete(dynamicSql);
            if (result > 0) {
                return YuinResultDto.sucess(result);
            }
            return YuinResultDto.failure("500", "\u5220\u9664\u5931\u8d25");
        }
        if ("S".equals(opertype)) {
            return YuinResultDto.sucess(this.select(dynamicSql));
        }
        if ("P".equals(opertype)) {
            return YuinResultDto.sucess(this.page(dynamicSql));
        }
        if (Arrays.asList("SI", "SU", "SD", "SL").contains(opertype)) {
            return YuinResultDto.sucess(this.handwork(dynamicSql));
        }
        if ("M".equals(opertype)) {
            return YuinResultDto.sucess(this.mapping(dynamicSql));
        }
        throw new Exception("\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef\uff01");
    }

    private int delete(DynamicSql dynamicSql) throws Exception {
        if (null == dynamicSql.getUpPDbaction().getCondinfo()) {
            throw new Exception("\u5220\u9664\u6570\u636e\u5f02\u5e38\uff0c\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Table table = TableUtil.setQueryValue(dynamicSql);
        return this.dynamicSqlMapper.delete(table);
    }

    private int insert(DynamicSql dynamicSql) throws Exception {
        HashMap<String, Object> defaultMap = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)dynamicSql.getUpPDbaction().getFieldlist())) {
            String script = String.format("SELECT COLUMN_NAME as name,COLUMN_DEFAULT as moren FROM information_schema.COLUMNS WHERE TABLE_NAME = '%S' AND TABLE_SCHEMA = (SELECT DATABASE())", dynamicSql.getUpPDbaction().getTablename());
            List<Map<String, Object>> defaultMapList = this.dynamicSqlMapper.handworkSelect(script);
            for (Map<String, Object> map : defaultMapList) {
                defaultMap.put(map.get("name").toString(), map.get("moren"));
            }
        }
        TableInsert table = TableUtil.setInsertValue(dynamicSql, defaultMap);
        return this.dynamicSqlMapper.insert(table);
    }

    private int update(DynamicSql dynamicSql) throws Exception {
        UpPDbactionQueryVo upPDbactionQueryVo = dynamicSql.getUpPDbaction();
        if (null == upPDbactionQueryVo.getCondinfo()) {
            throw new Exception("\u66f4\u65b0\u6570\u636e\u5f02\u5e38\uff0c\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Table table = TableUtil.setQueryValue(dynamicSql);
        String flag = upPDbactionQueryVo.getFlag();
        if (flag != null && flag.length() >= 2 && "1".equals(flag.substring(1, 2))) {
            String tradeBusinessStep = String.format("t0.%s", TableUtil.fieldTran("tradebusistep"));
            for (Col col : table.getCols()) {
                if (!tradeBusinessStep.equals(col.getField())) continue;
                Table selectTable = (Table)BeanUtils.beanCopy((Object)table, Table.class);
                ArrayList<Col> selectList = new ArrayList<Col>();
                for (int i = 0; i < 5; ++i) {
                    selectList.add(new Col());
                }
                ((Col)selectList.get(0)).setField(tradeBusinessStep);
                ((Col)selectList.get(1)).setField(String.format("t0.%s", TableUtil.fieldTran("sysid")));
                ((Col)selectList.get(2)).setField(String.format("t0.%s", TableUtil.fieldTran("appid")));
                ((Col)selectList.get(3)).setField(String.format("t0.%s", TableUtil.fieldTran("tradecode")));
                selectTable.setCols(selectList);
                List<Map<String, Object>> mapList = this.dynamicSqlMapper.select(selectTable);
                if (mapList.isEmpty()) {
                    throw new Exception("\u66f4\u65b0\u8868%s\u5931\u8d25\uff0c\u65e0\u76f8\u5173\u6570\u636e");
                }
                UpPBusistsctlVo upPBusistsctlVo = new UpPBusistsctlVo();
                upPBusistsctlVo.setSysid(mapList.get(0).get("sysid").toString());
                upPBusistsctlVo.setAppid(mapList.get(0).get("appid").toString());
                upPBusistsctlVo.setTradecode(mapList.get(0).get("tradecode").toString());
                upPBusistsctlVo.setTagstatus(col.getValue().toString());
                UpPBusistsctlVo busistsctlVo = this.upPBusistsctlService.detail(upPBusistsctlVo);
                if (busistsctlVo == null) {
                    logger.error("\u72b6\u6001\u63a7\u5236busistsctl\u8868\u914d\u7f6e\u4e3a\u7a7a");
                    throw new Exception("\u72b6\u6001\u63a7\u5236busistsctl\u8868\u914d\u7f6e\u4e3a\u7a7a");
                }
                Col cond = new Col();
                cond.setIsDefaultAnd("true");
                cond.setField(tradeBusinessStep);
                cond.setOperation("in");
                cond.setValue(busistsctlVo.getUpdstatuslist());
                cond.setIsCondition("true");
                table.getConds().add(cond);
                int result = this.dynamicSqlMapper.update(table);
                if (result > 0) {
                    return result;
                }
                throw new Exception(String.format("\u66f4\u65b0\u8868%s\u5931\u8d25\uff0c\u539f\u72b6\u6001\u4e3a%s", upPDbactionQueryVo.getTablename(), mapList.get(0).get("tradebusistep").toString()));
            }
            throw new Exception("\u672a\u914d\u7f6e\u66f4\u65b0\u4e1a\u52a1\u6b65\u9aa4\u72b6\u6001");
        }
        return this.dynamicSqlMapper.update(table);
    }

    private Map<String, Object> detail(DynamicSql dynamicSql) throws Exception {
        Table table = TableUtil.setQueryValue(dynamicSql);
        return this.dynamicSqlMapper.detail(table);
    }

    private List<Map<String, Object>> select(DynamicSql dynamicSql) throws Exception {
        Table table = TableUtil.setQueryValue(dynamicSql);
        PageHelper.orderBy((String)table.getOrderBy());
        List<Map<String, Object>> da = this.dynamicSqlMapper.select(table);
        PageHelper.clearPage();
        return da;
    }

    private List<Map<String, Object>> page(DynamicSql dynamicSql) throws Exception {
        Table table = TableUtil.setQueryValue(dynamicSql);
        PageHelper.startPage((int)table.getPageNum(), (int)table.getPageSize(), (String)table.getOrderBy());
        List<Map<String, Object>> da = this.dynamicSqlMapper.select(table);
        PageHelper.clearPage();
        return da;
    }

    private Object handwork(DynamicSql dynamicSql) throws Exception {
        JavaDict data = dynamicSql.getData();
        UpPDbactionQueryVo upDDbaction = dynamicSql.getUpPDbaction();
        String script = upDDbaction.getColinfo();
        if (StringUtils.isEmpty((String)script)) {
            throw new Exception("\u624b\u5de5\u64cd\u4f5c\u5f02\u5e38\uff0c\u6267\u884c\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)upDDbaction.getCondinfo())) {
            String[] condList = upDDbaction.getCondinfo().split(",");
            for (int i = 0; i < condList.length; ++i) {
                String cond = condList[i];
                script = script.contains("%s") ? script.replaceFirst("%s", cond.startsWith("#") ? cond.substring(1) : data.getString(cond)) : script.replace(String.format(":%s", i + 1), cond.startsWith("#") ? cond.substring(1) : data.getString(cond));
            }
        }
        if ("SL".equals(upDDbaction.getOpertype())) {
            return this.dynamicSqlMapper.handworkSelect(script);
        }
        if ("SI".equals(upDDbaction.getOpertype())) {
            return this.dynamicSqlMapper.handworkInsert(script);
        }
        if ("SU".equals(upDDbaction.getOpertype())) {
            return this.dynamicSqlMapper.handworkUpdate(script);
        }
        return this.dynamicSqlMapper.handworkDelete(script);
    }

    private Map<String, Object> mapping(DynamicSql dynamicSql) {
        HashMap<String, Object> resData = new HashMap<String, Object>();
        ArrayList<String> failList = new ArrayList<String>();
        JavaDict data = dynamicSql.getData();
        UpPDbactionQueryVo upDDbaction = dynamicSql.getUpPDbaction();
        String flag = upDDbaction.getFlag();
        Boolean addFiled = StringUtils.isNotEmpty((String)flag) && flag.length() >= 4 && "1".equals(String.valueOf(flag.charAt(3))) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        if (upDDbaction.getColinfo() != null) {
            String[] colinfoList;
            for (String colinfo : colinfoList = upDDbaction.getColinfo().split(",")) {
                String[] colinfoChild = colinfo.split(":");
                if (colinfoChild.length >= 2) {
                    if (colinfoChild[0].startsWith("#")) {
                        resData.put(colinfoChild[1], colinfoChild[0].substring(1));
                        continue;
                    }
                    if (addFiled.booleanValue()) {
                        resData.put(colinfoChild[1], null == data.get(colinfoChild[0]) ? "" : data.get(colinfoChild[0]));
                        continue;
                    }
                    if (null != data.get(colinfoChild[0])) {
                        resData.put(colinfoChild[1], data.get(colinfoChild[0]));
                        continue;
                    }
                    failList.add(colinfoChild[1]);
                    continue;
                }
                if (addFiled.booleanValue()) {
                    resData.put(colinfoChild[0], null == data.get(colinfoChild[0]) ? "" : data.get(colinfoChild[0]));
                    continue;
                }
                if (null != data.get(colinfoChild[0])) {
                    resData.put(colinfoChild[0], data.get(colinfoChild[0]));
                    continue;
                }
                failList.add(colinfoChild[0]);
            }
        }
        if (failList.size() > 0) {
            LogUtils.printInfo(this, "MFAILE[{}]", StringUtils.join(failList, (String)","));
        }
        LogUtils.printInfo(this, "\u6620\u5c04\u524dMAP[{}]", JSON.toJSONString((Object)data));
        LogUtils.printInfo(this, "\u6620\u5c04\u540eMAP[{}]", JSON.toJSONString(resData));
        return resData;
    }
}

