/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.base.component.fieldmap.service;

import cn.com.yusys.yusp.pay.common.base.component.fieldmap.dao.po.UpPDictPo;
import cn.com.yusys.yusp.pay.common.base.component.fieldmap.domain.repo.UpPDictRepo;
import cn.com.yusys.yusp.pay.common.base.component.fieldmap.domain.vo.UpPDictContext;
import cn.com.yusys.yusp.pay.common.base.component.fieldmap.domain.vo.UpPDictVo;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpPDictService {
    @Autowired
    private UpPDictRepo upPDictRepo;

    public YuinResult getDictValue2ByKey(String sysid, String appid, String dictClass, String dictType, String dictLang, String dictCode, String dictValue) {
        Map<String, UpPDictPo> dictMap;
        YuinResult result = this.chkDictKey(sysid, appid, dictClass, dictType, dictLang, dictCode, dictValue);
        if (!result.success()) {
            return result;
        }
        UpPDictVo upPDictVo = new UpPDictVo();
        upPDictVo.setSysid(sysid);
        upPDictVo.setAppid(appid);
        upPDictVo.setDictclass(dictClass);
        upPDictVo.setDicttype(dictType);
        upPDictVo.setDictlang(dictLang);
        upPDictVo.setDictcode(dictCode);
        upPDictVo.setDictvalue(dictValue);
        String key = sysid + appid + dictClass + dictType + dictLang + dictCode + dictValue;
        UpPDictPo upPDictPo = null;
        if (UpPDictContext.get() != null && (dictMap = UpPDictContext.get()).containsKey(key)) {
            upPDictPo = dictMap.get(key);
        }
        if (upPDictPo == null) {
            upPDictPo = this.upPDictRepo.selectById(upPDictVo);
        }
        if (upPDictPo == null) {
            return YuinResult.newFailureResult("S9002", String.format("\u672a\u67e5\u8be2\u5230[%s-%s-%s-%s-%s-%s-%s]\u7684\u5b57\u5178\u503c", sysid, appid, dictClass, dictType, dictLang, dictCode, dictValue));
        }
        String dictvalue2 = upPDictPo.getDictvalue2();
        return YuinResult.newSuccessResult(new Object[]{dictvalue2});
    }

    public YuinResult getDictValue2ByKey(JavaDict javaDict, String dictInfo) {
        String[] dictinfo = dictInfo.split(",");
        String sysid = "#".equals(dictinfo[0].substring(0, 1)) ? dictinfo[0].substring(1) : javaDict.getString(dictinfo[0]);
        String appid = "#".equals(dictinfo[1].substring(0, 1)) ? dictinfo[1].substring(1) : javaDict.getString(dictinfo[1]);
        String dictClass = "#".equals(dictinfo[2].substring(0, 1)) ? dictinfo[2].substring(1) : javaDict.getString(dictinfo[2]);
        String dictType = "#".equals(dictinfo[3].substring(0, 1)) ? dictinfo[3].substring(1) : javaDict.getString(dictinfo[3]);
        String dictLang = "ZH_CN";
        String dictCode = "#".equals(dictinfo[4].substring(0, 1)) ? dictinfo[4].substring(1) : javaDict.getString(dictinfo[4]);
        String dictValue = "#".equals(dictinfo[5].substring(0, 1)) ? dictinfo[5].substring(1) : javaDict.getString(dictinfo[5]);
        return this.getDictValue2ByKey(sysid, appid, dictClass, dictType, dictLang, dictCode, dictValue);
    }

    private YuinResult chkDictKey(String sysid, String appid, String dictClass, String dictType, String dictLang, String dictCode, String dictValue) {
        if (Objects.isNull(sysid)) {
            return YuinResult.newFailureResult("S9002", "\u5b57\u5178\u67e5\u8be2\u6761\u4ef6[sysid]\u503c\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (Objects.isNull(appid)) {
            return YuinResult.newFailureResult("S9002", "\u5b57\u5178\u67e5\u8be2\u6761\u4ef6[appid]\u503c\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (Objects.isNull(dictClass)) {
            return YuinResult.newFailureResult("S9002", "\u5b57\u5178\u67e5\u8be2\u6761\u4ef6[dictclass]\u503c\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (Objects.isNull(dictType)) {
            return YuinResult.newFailureResult("S9002", "\u5b57\u5178\u67e5\u8be2\u6761\u4ef6[dicttype]\u503c\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (Objects.isNull(dictLang)) {
            return YuinResult.newFailureResult("S9002", "\u5b57\u5178\u67e5\u8be2\u6761\u4ef6[dictlang]\u503c\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (Objects.isNull(dictCode)) {
            return YuinResult.newFailureResult("S9002", "\u5b57\u5178\u67e5\u8be2\u6761\u4ef6[dictcode]\u503c\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (Objects.isNull(dictValue)) {
            return YuinResult.newFailureResult("S9002", "\u5b57\u5178\u67e5\u8be2\u6761\u4ef6[dictvalue]\u503c\u4e0d\u53ef\u4e3a\u7a7a");
        }
        return YuinResult.newSuccessResult(null);
    }
}

