/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.base.component.fieldmap.service;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.StringUtilEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StringMethodService {
    private static final Logger logger = LoggerFactory.getLogger(StringMethodService.class);
    private static final String DIR_LEFT = "LEFT";
    private static final String DIR_RIGHT = "RIGHT";
    private static final String DIR_BOTH = "BOTH";
    private static final String STRING_FILL = "fill";
    private static final String STRING_JOINT = "joint";
    private static final String STRING_DELETE = "delete";
    private static final String STRING_CUT = "cut";
    private static final String STRING_REPLACE = "replace";
    private static final String STRING_ESCAPE = "escape";
    private static final String STRING_SUBSTR = "substr";

    public YuinResult stringFormat(JavaDict request, String colinpara) {
        String result;
        String[] inpara = colinpara.split(",");
        String srcData = "#".equals(inpara[0].substring(0, 1)) ? inpara[0].substring(1) : request.getString(inpara[0]);
        String type = inpara[1];
        if (StringUtils.isEmpty((CharSequence)srcData)) {
            return YuinResult.newFailureResult("S9002", "\u5b57\u7b26\u51fd\u6570\u5165\u53c2\u9519\u8bef\uff0c\u64cd\u4f5c\u5b57\u7b26\u4e3a\u7a7a");
        }
        try {
            switch (type) {
                case "fill": {
                    result = this.fillWord(request, srcData, inpara);
                    break;
                }
                case "joint": {
                    result = this.fillWords(request, srcData, inpara);
                    break;
                }
                case "delete": {
                    result = this.deleteWord(request, srcData, inpara);
                    break;
                }
                case "cut": {
                    result = this.cutString(request, srcData, inpara);
                    break;
                }
                case "replace": {
                    result = this.replaceString(request, srcData, inpara);
                    break;
                }
                case "escape": {
                    result = this.translateChar(srcData, inpara);
                    break;
                }
                case "substr": {
                    result = this.selectSubString(srcData, inpara);
                    break;
                }
                default: {
                    return YuinResult.newFailureResult("S9002", "\u5b57\u7b26\u51fd\u6570\u7c7b\u578b\u9519\u8bef");
                }
            }
        }
        catch (Exception e) {
            return YuinResult.newFailureResult("S9002", e.getMessage());
        }
        return YuinResult.newSuccessResult(new Object[]{result});
    }

    public String fillWord(JavaDict request, String srcData, String[] inpara) throws Exception {
        String signStr;
        if (inpara.length < 5) {
            throw new Exception("\u586b\u5145\u5b57\u7b26\u51fd\u6570 @ \u5165\u53c2\u4e2a\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((CharSequence)inpara[2])) {
            logger.warn("\u586b\u5145\u5b57\u7b26\u51fd\u6570 @ \u6807\u8bc6\u7b26\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u586b\u5145");
            return srcData;
        }
        String string = signStr = "#".equals(inpara[2].substring(0, 1)) ? inpara[2].substring(1) : request.getString(inpara[2]);
        if (StringUtils.isEmpty((CharSequence)signStr)) {
            logger.warn("\u586b\u5145\u5b57\u7b26\u51fd\u6570 @ \u586b\u5145\u5b57\u7b26\u4e3a\u7a7a,\u4e0d\u505a\u586b\u5145");
            return srcData;
        }
        char signChar = signStr.charAt(0);
        String direction = StringUtils.isEmpty((CharSequence)inpara[3]) ? DIR_RIGHT : inpara[3];
        int targetLength = Integer.parseInt(inpara[4]);
        if (srcData.length() >= targetLength) {
            return srcData;
        }
        if (DIR_LEFT.equals(direction)) {
            return StringUtilEx.fill(srcData, signChar, targetLength, true);
        }
        if (DIR_RIGHT.equals(direction)) {
            return StringUtilEx.fill(srcData, signChar, targetLength, false);
        }
        logger.warn(String.format("\u586b\u5145\u5b57\u7b26\u51fd\u6570 @ \u4e0d\u652f\u6301\u3010%s\u3011\u586b\u5145\u65b9\u5411,\u4e0d\u505a\u586b\u5145", direction));
        return srcData;
    }

    public String fillWords(JavaDict request, String srcData, String[] inpara) throws Exception {
        String signChar;
        if (inpara.length < 4) {
            throw new Exception("\u62fc\u63a5\u5b57\u7b26\u4e32\u51fd\u6570 @ \u5165\u53c2\u4e2a\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((CharSequence)inpara[2])) {
            logger.warn("\u62fc\u63a5\u5b57\u7b26\u4e32\u51fd\u6570 @ \u6807\u8bc6\u7b26\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u62fc\u63a5");
            return srcData;
        }
        String string = signChar = "#".equals(inpara[2].substring(0, 1)) ? inpara[2].substring(1) : request.getString(inpara[2]);
        if (StringUtils.isEmpty((CharSequence)signChar)) {
            logger.warn("\u62fc\u63a5\u5b57\u7b26\u4e32\u51fd\u6570 @ \u62fc\u63a5\u5b57\u7b26\u4e3a\u7a7a,\u4e0d\u505a\u62fc\u63a5");
            return srcData;
        }
        String direction = StringUtils.isEmpty((CharSequence)inpara[3]) ? DIR_RIGHT : inpara[3];
        if (DIR_LEFT.equals(direction)) {
            return String.format("%s%s", signChar, srcData);
        }
        if (DIR_RIGHT.equals(direction)) {
            return String.format("%s%s", srcData, signChar);
        }
        logger.warn(String.format("\u62fc\u63a5\u5b57\u7b26\u4e32\u51fd\u6570 @ \u4e0d\u652f\u6301\u3010%s\u3011\u62fc\u63a5\u65b9\u5411,\u4e0d\u505a\u62fc\u63a5", direction));
        return srcData;
    }

    public String deleteWord(JavaDict request, String srcData, String[] inpara) throws Exception {
        String result;
        int targetLength;
        String signStr;
        if (inpara.length < 4 || inpara.length < 5 && !DIR_BOTH.equals(inpara[3])) {
            throw new Exception("\u5220\u9664\u5b57\u7b26\u51fd\u6570 @ \u5165\u53c2\u4e2a\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((CharSequence)inpara[2])) {
            logger.warn("\u5220\u9664\u5b57\u7b26\u51fd\u6570 @ \u6807\u8bc6\u7b26\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u5220\u9664");
            return srcData;
        }
        String string = signStr = "#".equals(inpara[2].substring(0, 1)) ? inpara[2].substring(1) : request.getString(inpara[2]);
        if (StringUtils.isEmpty((CharSequence)signStr)) {
            logger.warn("\u5220\u9664\u5b57\u7b26\u51fd\u6570 @ \u5220\u9664\u5b57\u7b26\u4e3a\u7a7a,\u4e0d\u505a\u5220\u9664");
            return srcData;
        }
        char signChar = signStr.charAt(0);
        String direction = StringUtils.isEmpty((CharSequence)inpara[3]) ? DIR_RIGHT : inpara[3];
        int n = targetLength = DIR_BOTH.equals(direction) ? 0 : Integer.parseInt(inpara[4]);
        if (DIR_LEFT.equals(direction)) {
            result = StringUtilEx.delete(srcData, signChar, targetLength, true);
        } else if (DIR_RIGHT.equals(direction)) {
            result = StringUtilEx.delete(srcData, signChar, targetLength, false);
        } else if (DIR_BOTH.equals(direction)) {
            String sSrc = StringUtilEx.delete(srcData, signChar, -1, true);
            result = StringUtilEx.delete(sSrc, signChar, -1, false);
        } else {
            logger.warn(String.format("\u5220\u9664\u5b57\u7b26\u51fd\u6570 @ \u4e0d\u652f\u6301\u3010%s\u3011\u5220\u9664\u65b9\u5411,\u4e0d\u505a\u5220\u9664", direction));
            return srcData;
        }
        return result;
    }

    public String cutString(JavaDict request, String srcData, String[] inpara) throws Exception {
        String result;
        String signStr;
        if (inpara.length < 4) {
            throw new Exception("\u5b57\u7b26\u4e32\u622a\u53d6\u51fd\u6570 @ \u5165\u53c2\u4e2a\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((CharSequence)inpara[2])) {
            logger.warn("\u5b57\u7b26\u4e32\u622a\u53d6\u51fd\u6570 @ \u6807\u8bc6\u7b26\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u622a\u53d6");
            return srcData;
        }
        String string = signStr = "#".equals(inpara[2].substring(0, 1)) ? inpara[2].substring(1) : request.getString(inpara[2]);
        if (StringUtils.isEmpty((CharSequence)signStr)) {
            logger.warn("\u5b57\u7b26\u4e32\u622a\u53d6\u51fd\u6570 @ \u622a\u53d6\u5b57\u7b26\u4e3a\u7a7a,\u4e0d\u505a\u622a\u53d6");
            return srcData;
        }
        char signChar = signStr.charAt(0);
        String direction = StringUtils.isEmpty((CharSequence)inpara[3]) ? DIR_RIGHT : inpara[3];
        if (DIR_LEFT.equals(direction)) {
            result = StringUtilEx.cut(srcData, signChar, true);
        } else if (DIR_RIGHT.equals(direction)) {
            result = StringUtilEx.cut(srcData, signChar, false);
        } else {
            logger.warn(String.format("\u5b57\u7b26\u4e32\u622a\u53d6\u51fd\u6570 @ \u4e0d\u652f\u6301\u3010%s\u3011\u622a\u53d6\u65b9\u5411,\u4e0d\u505a\u622a\u53d6", direction));
            return srcData;
        }
        return result;
    }

    public String replaceString(JavaDict request, String srcData, String[] inpara) throws Exception {
        String signStr;
        if (inpara.length < 5) {
            throw new Exception("\u5b57\u7b26\u4e32\u622a\u53d6\u51fd\u6570 @ \u5165\u53c2\u4e2a\u6570\u9519\u8bef");
        }
        int start = StringUtils.isEmpty((CharSequence)inpara[2]) ? 1 : Integer.parseInt(inpara[2]);
        int end = StringUtils.isEmpty((CharSequence)inpara[3]) ? 1 : Integer.parseInt(inpara[3]);
        if (StringUtils.isEmpty((CharSequence)inpara[4])) {
            logger.warn("\u5b57\u7b26\u4e32\u66ff\u6362\u51fd\u6570 @ \u66ff\u6362\u5b57\u7b26\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u66ff\u6362");
            return srcData;
        }
        String string = signStr = "#".equals(inpara[4].substring(0, 1)) ? inpara[4].substring(1) : request.getString(inpara[4]);
        if (StringUtils.isEmpty((CharSequence)signStr)) {
            logger.warn("\u5b57\u7b26\u4e32\u622a\u53d6\u51fd\u6570 @ \u66ff\u6362\u5b57\u7b26\u4e3a\u7a7a,\u4e0d\u505a\u66ff\u6362");
            return srcData;
        }
        return StringUtilEx.replaceString(srcData, start, end, signStr);
    }

    public String translateChar(String srcData, String[] inpara) throws Exception {
        return StringUtilEx.translateChar(srcData);
    }

    public String selectSubString(String srcData, String[] inpara) throws Exception {
        if (inpara.length < 4) {
            throw new Exception("\u5b57\u7b26\u4e32\u622a\u53d6\u51fd\u6570 @ \u5165\u53c2\u4e2a\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((CharSequence)inpara[2]) || StringUtils.isEmpty((CharSequence)inpara[3])) {
            logger.warn("\u9009\u53d6\u5b50\u4e32\u51fd\u6570@ \u8d77\u59cb\u4f4d\u7f6e\u6216\u7ed3\u675f\u4f4d\u7f6e\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u9009\u53d6");
            return srcData;
        }
        int start = Integer.parseInt(inpara[2]);
        int end = Integer.parseInt(inpara[3]);
        int len = srcData.length();
        if (start < 1) {
            start = 1;
        }
        if (end > len || end < 1) {
            end = len;
        }
        if (start > end || start > srcData.length()) {
            logger.warn("\u9009\u53d6\u5b50\u4e32\u51fd\u6570 @ \u8d77\u59cb\u4f4d\u7f6e\u6216\u7ed3\u675f\u4f4d\u7f6e\u914d\u7f6e\u6709\u8bef,\u4e0d\u505a\u9009\u53d6");
            return srcData;
        }
        return srcData.substring(start - 1, end);
    }
}

