/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.payment.common.base.component.fieldmap.service;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DateMethodService {
    private static final Logger logger = LoggerFactory.getLogger(DateMethodService.class);

    public YuinResult dateFormat(JavaDict request, String colinpara) {
        String result;
        String[] inpara = colinpara.split(",");
        String srcData = "#".equals(inpara[0].substring(0, 1)) ? inpara[0].substring(1) : request.getString(inpara[0]);
        try {
            result = this.dateFormat(srcData, inpara);
        }
        catch (Exception e) {
            return YuinResult.newFailureResult("S9002", e.getMessage());
        }
        return YuinResult.newSuccessResult(new Object[]{result});
    }

    public String dateFormat(String srcData, String[] inpara) throws Exception {
        if (inpara.length < 3) {
            throw new Exception("\u65e5\u8d77\u65f6\u95f4\u683c\u5f0f\u5316\u51fd\u6570 @ \u5165\u53c2\u4e2a\u6570\u9519\u8bef");
        }
        String receiveFormat = inpara[1];
        if (StringUtils.isEmpty((CharSequence)receiveFormat) || srcData.length() != receiveFormat.length()) {
            logger.warn("\u683c\u5f0f\u5316\u65f6\u95f4\u51fd\u6570 @ \u65f6\u95f4\u53c2\u6570\u4e0d\u6b63\u786e,\u539f\u503c\u8fd4\u56de");
            return srcData;
        }
        String convertFormat = inpara[2];
        if (StringUtils.isEmpty((CharSequence)convertFormat)) {
            logger.warn("\u683c\u5f0f\u5316\u65f6\u95f4\u51fd\u6570 @ \u65f6\u95f4\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u539f\u503c\u8fd4\u56de");
            return srcData;
        }
        Date date = DateUtils.parseDate((String)srcData, (String)receiveFormat);
        return DateUtils.formatDate((Date)date, (String)convertFormat);
    }
}

