/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.payment.common.base.component.fieldmap.service;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AmtMethodService {
    private static final Logger logger = LoggerFactory.getLogger(AmtMethodService.class);
    private static final char CHAR_DOT = '.';
    private static final String AMT_FORMAT = "format";
    private static final String AMT_ADD = "add";
    private static final String AMT_DELETE = "delete";

    public YuinResult amtFormat(JavaDict request, String colinpara) {
        String result;
        String[] inpara = colinpara.split(",");
        String srcData = "#".equals(inpara[0].substring(0, 1)) ? inpara[0].substring(1) : request.getString(inpara[0]);
        String type = inpara[1];
        try {
            switch (type) {
                case "format": {
                    result = this.formatMoney(srcData, inpara);
                    break;
                }
                case "add": {
                    result = this.addDecimalPoint(srcData, inpara);
                    break;
                }
                case "delete": {
                    result = this.delDecimalPoint(srcData, inpara);
                    break;
                }
                default: {
                    return YuinResult.newFailureResult("S9002", "\u91d1\u989d\u51fd\u6570\u7c7b\u578b\u9519\u8bef");
                }
            }
        }
        catch (Exception e) {
            return YuinResult.newFailureResult("S9002", e.getMessage());
        }
        return YuinResult.newSuccessResult(new Object[]{result});
    }

    public String formatMoney(String srcData, String[] inpara) throws Exception {
        String ret;
        if (inpara.length < 3) {
            throw new Exception("\u586b\u5145\u5b57\u7b26\u51fd\u6570 @ \u5165\u53c2\u4e2a\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((CharSequence)inpara[2])) {
            logger.warn("\u683c\u5f0f\u5316\u91d1\u989d\u51fd\u6570 @ \u8f6c\u6362\u540e\u7684\u91d1\u989d\u683c\u5f0f\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u683c\u5f0f\u5316");
            return srcData;
        }
        if (srcData.length() == 0) {
            return "";
        }
        String sf = StringUtils.join((Object[])inpara, (String)",", (int)2, (int)inpara.length);
        DecimalFormat formatter = new DecimalFormat(sf);
        if (srcData.indexOf(46) != -1) {
            double i = Double.parseDouble(srcData);
            ret = formatter.format(i);
        } else {
            long i = Long.parseLong(srcData);
            ret = formatter.format(i);
        }
        return ret;
    }

    public String addDecimalPoint(String srcData, String[] inpara) throws Exception {
        if (srcData.contains(".")) {
            return srcData;
        }
        BigDecimal decimal = new BigDecimal(String.valueOf(Integer.valueOf(srcData) / 100));
        decimal = decimal.setScale(2);
        return decimal.toString();
    }

    public String delDecimalPoint(String srcData, String[] inpara) throws Exception {
        if (!srcData.contains(".")) {
            return srcData;
        }
        String result = srcData.replace(".", "");
        return result;
    }
}

