/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.payment.common.base.component.dboper.service;

import cn.com.yusys.yusp.payment.common.base.component.dboper.dao.po.UpPDbeventPo;
import cn.com.yusys.yusp.payment.common.base.component.dboper.domain.vo.UpPBusistsctlVo;
import cn.com.yusys.yusp.payment.common.base.component.dboper.domain.vo.UpPDbactionQueryVo;
import cn.com.yusys.yusp.payment.common.base.component.dboper.domain.vo.UpPDbeventQueryVo;
import cn.com.yusys.yusp.payment.common.base.component.dboper.service.DynamicSqlService;
import cn.com.yusys.yusp.payment.common.base.component.dboper.service.UpPBusistsctlService;
import cn.com.yusys.yusp.payment.common.base.component.dboper.service.UpPDbactionService;
import cn.com.yusys.yusp.payment.common.base.component.dboper.service.UpPDbeventService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.base.util.StringUtilEx;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TradeOperDbService {
    private static final Logger logger = LoggerFactory.getLogger(TradeOperDbService.class);
    @Autowired
    private UpPDbactionService upPDbactionService;
    @Autowired
    private UpPDbeventService upPDbeventService;
    @Autowired
    private UpPBusistsctlService upPBusistsctlService;
    @Autowired
    private DynamicSqlService dynamicSqlService;

    public YuinResult operEvent(JavaDict data, String sysid, String appid, String eventid) throws Exception {
        try {
            this.beforeCheck(data, sysid, appid, eventid);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            return YuinResult.newFailureResult("S9002", e.getMessage());
        }
        UpPDbeventQueryVo upPDbeventQueryVo = new UpPDbeventQueryVo();
        upPDbeventQueryVo.setSysid(sysid);
        upPDbeventQueryVo.setAppid(appid);
        upPDbeventQueryVo.setEventid(eventid);
        List<UpPDbeventPo> eventVoLis = this.upPDbeventService.list(upPDbeventQueryVo);
        if (CollectionUtils.isEmpty(eventVoLis)) {
            logger.info("\u6570\u636e\u4e8b\u52a1event\u8868\u914d\u7f6e\u4e3a\u7a7a:" + eventid);
            return YuinResult.newFailureResult("S9002", "\u6570\u636e\u4e8b\u52a1event\u8868\u914d\u7f6e\u4e3a\u7a7a:" + eventid);
        }
        ArrayList<String> actionkeyList = new ArrayList<String>();
        for (UpPDbeventPo eventPo : eventVoLis) {
            actionkeyList.add(eventPo.getActionkey());
        }
        YuinResultDto resultDto = this.operDbaction(data, sysid, appid, actionkeyList);
        if (!resultDto.isSuccess()) {
            return YuinResult.newFailureResult(resultDto.getHead().getResponseCode(), resultDto.getHead().getResponseMsg());
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResultDto operDbaction(JavaDict data, String sysid, String appid, String actionkey) throws Exception {
        ArrayList<String> actionkeyList = new ArrayList<String>();
        actionkeyList.add(actionkey);
        return this.operDbaction(data, sysid, appid, actionkeyList);
    }

    public YuinResultDto operDbaction(JavaDict data, String sysid, String appid, List<String> actionkeyList) throws Exception {
        ArrayList<UpPDbactionQueryVo> actionList = new ArrayList<UpPDbactionQueryVo>();
        UpPBusistsctlVo busistsctlVo = null;
        UpPDbactionQueryVo upPDbactionQueryVo = new UpPDbactionQueryVo();
        upPDbactionQueryVo.setSysid(sysid);
        upPDbactionQueryVo.setAppid(appid);
        for (String actionkey : actionkeyList) {
            if (StringUtilEx.isNullOrEmpty(actionkey)) {
                logger.error("\u6570\u636e\u64cd\u4f5cactionkey\u4e3a\u7a7a:" + actionkey);
                return YuinResultDto.failure("S9002", "\u6570\u636e\u64cd\u4f5cactionkey\u4e3a\u7a7a:" + actionkey);
            }
            upPDbactionQueryVo.setActionkey(actionkey);
            UpPDbactionQueryVo actionQueryVo = this.upPDbactionService.detail(upPDbactionQueryVo);
            if (actionQueryVo == null) {
                logger.error("\u6570\u636e\u64cd\u4f5caction\u8868\u914d\u7f6e\u4e3a\u7a7a:" + actionkey);
                return YuinResultDto.failure("S9002", "\u6570\u636e\u64cd\u4f5caction\u8868\u914d\u7f6e\u4e3a\u7a7a:" + actionkey);
            }
            String flag = actionQueryVo.getFlag();
            if (flag != null && flag.length() >= 2 && "1".equals(flag.substring(1, 2))) {
                if (null == busistsctlVo) {
                    UpPBusistsctlVo upPBusistsctlVo = new UpPBusistsctlVo();
                    upPBusistsctlVo.setSysid(sysid);
                    upPBusistsctlVo.setAppid(appid);
                    upPBusistsctlVo.setTradecode(data.getString("tradecode"));
                    upPBusistsctlVo.setTagstatus(data.getString("tradebusistep"));
                    busistsctlVo = this.upPBusistsctlService.detail(upPBusistsctlVo);
                }
                if (busistsctlVo != null) {
                    actionQueryVo.setUpPBusistsctlVo(busistsctlVo);
                    actionQueryVo.setCondinfo(String.format("%s,%s", actionQueryVo.getCondinfo(), "tradebusistep:lasttradebusistep"));
                } else {
                    logger.error("\u72b6\u6001\u63a7\u5236busistsctl\u8868\u914d\u7f6e\u4e3a\u7a7a");
                    return YuinResultDto.failure("S9002", "\u72b6\u6001\u63a7\u5236busistsctl\u8868\u914d\u7f6e\u4e3a\u7a7a");
                }
            }
            actionList.add(actionQueryVo);
        }
        return this.dynamicSqlService.operDynamicSql(data, actionList);
    }

    private void beforeCheck(JavaDict data, String sysid, String appid, String eventid) throws Exception {
        if (null == data) {
            throw new Exception("\u4e0a\u4e0b\u6587\u6570\u636e\u4e0d\u5b58\u5728!");
        }
        if (StringUtils.isEmpty((String)sysid)) {
            throw new Exception("\u7cfb\u7edf\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)appid)) {
            throw new Exception("\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)eventid)) {
            throw new Exception("\u4e8b\u52a1\u4ee3\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

