/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.payment.common.base.component.fieldmap.service;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.payment.common.base.component.fieldmap.dao.po.UpPErrinfoPo;
import cn.com.yusys.yusp.payment.common.base.component.fieldmap.domain.repo.UpPErrinfoRepo;
import cn.com.yusys.yusp.payment.common.base.component.fieldmap.domain.vo.UpPErrinfoVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpPErrinfoService {
    private static final Logger logger = LoggerFactory.getLogger(UpPErrinfoService.class);
    @Autowired
    private UpPErrinfoRepo upPErrinfoRepo;

    public YuinResult transRetCode(JavaDict request, String inPara) {
        String[] listInPara = inPara.split(",");
        if (listInPara.length < 6) {
            return YuinResult.newFailureResult("S9002", String.format("\u914d\u7f6e\u5f02\u5e38:\u5165\u53c2\u81f3\u5c11\u4e3a%s\u4e2a", listInPara.length));
        }
        String strSysId = listInPara[0].startsWith("#") ? listInPara[0].substring(1) : request.getString("sysid");
        String strAppId = listInPara[1].startsWith("#") ? listInPara[1].substring(1) : request.getString("appid");
        String strChlCd = listInPara[2].startsWith("#") ? listInPara[2].substring(1) : request.getString("chnlcode");
        String strErrCd = listInPara[3].startsWith("#") ? listInPara[3].substring(1) : request.getString("errcode");
        String strFlag = listInPara[5].substring(1);
        if ("1".equals(request.getString("status"))) {
            return YuinResult.newSuccessResult(null);
        }
        if (request.hasKey("bankerrcode") && !StringUtils.isEmpty((CharSequence)request.getString("bankerrcode")) && request.getString("__BANKOK__", "000000").equals(request.getString("bankerrcode"))) {
            strErrCd = request.getString("bankerrcode");
        }
        String strbusikind = request.getString("busikind", "PUB");
        UpPErrinfoVo vo = new UpPErrinfoVo();
        vo.setSysid(strSysId);
        vo.setAppid(strAppId);
        vo.setChnlcode(StringUtils.isBlank((CharSequence)strChlCd) ? "PUB" : strChlCd);
        vo.setInerrcode(strErrCd);
        vo.setBusikind(strbusikind);
        List<UpPErrinfoPo> selectListPo = this.upPErrinfoRepo.selectErrInfo(vo);
        if (selectListPo.size() < 1) {
            logger.info(String.format("\u672a\u67e5\u8be2\u5230\u9519\u8bef\u7801[%s]\u7684\u6620\u5c04\u914d\u7f6e\uff0c\u4f7f\u7528\u9ed8\u8ba4\u9519\u8bef\u7801", strErrCd));
            vo.setDefaultflag("1");
            selectListPo = this.upPErrinfoRepo.selectErrInfoDefault(vo);
            if (selectListPo.size() < 1) {
                return YuinResult.newFailureResult("S9002", String.format("\u672a\u67e5\u8be2\u5230\u9519\u8bef\u7801[%s]\u7684\u6620\u5c04\u914d\u7f6e", strErrCd));
            }
        }
        UpPErrinfoPo upPErrinfoPo = null;
        int intPower = 0;
        for (UpPErrinfoPo upPErrinfoPotmp : selectListPo) {
            if ("PUB".equals(upPErrinfoPotmp.getBusikind()) && intPower == 0) {
                intPower = 1;
                upPErrinfoPo = upPErrinfoPotmp;
                continue;
            }
            if ("PUB".equals(upPErrinfoPotmp.getBusikind()) || intPower >= 2) continue;
            intPower = 2;
            upPErrinfoPo = upPErrinfoPotmp;
        }
        if ("1".equals(strFlag)) {
            request.set(listInPara[3].startsWith("#") ? listInPara[3].substring(1) : listInPara[3], upPErrinfoPo.getOuterrcode());
            request.set(listInPara[4].startsWith("#") ? listInPara[4].substring(1) : listInPara[4], upPErrinfoPo.getOuterrmsg());
            return YuinResult.newSuccessResult(new Object[]{upPErrinfoPo.getOuterrcode(), upPErrinfoPo.getOuterrmsg()});
        }
        request.set(listInPara[3].startsWith("#") ? listInPara[3].substring(1) : listInPara[3], upPErrinfoPo.getInerrcode());
        request.set(listInPara[4].startsWith("#") ? listInPara[4].substring(1) : listInPara[4], upPErrinfoPo.getInerrmsg());
        return YuinResult.newSuccessResult(new Object[]{upPErrinfoPo.getInerrcode(), upPErrinfoPo.getInerrmsg()});
    }

    public YuinResult transRetCode(JavaDict request, String sysid, String appid, String chnlcode, String inerrcode, String inerrmsg, String flag) {
        return this.transRetCode(request, String.format("%s,%s,%s,%s,%s,%s", sysid, appid, chnlcode, inerrcode, inerrmsg, flag));
    }
}

