/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.payment.common.base.component.cosapi;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.payment.common.base.component.cosapi.SelfDefineEndPointBuilder;
import cn.com.yusys.yusp.payment.common.base.util.YuinLogUtils;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.endpoint.EndpointBuilder;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import java.io.File;
import java.util.Date;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CspComponent {
    @Value(value="${tsf.csp.SecretId:'AKIDqPfaAQLwC8jzv1qKTHmVz8xRbQu5vQbR'}")
    private String SecretId;
    @Value(value="${tsf.csp.SecretId:'YldBPIq4xVib9MEmzrPdW5KGr84fwsUm'}")
    private String SecretKey;
    @Value(value="${tsf.csp.region:'imcr'}")
    private String region;

    public COSClient getcosclient() {
        BasicCOSCredentials cred = new BasicCOSCredentials(this.SecretId, this.SecretKey);
        ClientConfig clientConfig = new ClientConfig(new Region(this.region));
        SelfDefineEndPointBuilder selfDefineEndPointBuilder = new SelfDefineEndPointBuilder();
        clientConfig.setHttpProtocol(HttpProtocol.http);
        clientConfig.setEndpointBuilder((EndpointBuilder)selfDefineEndPointBuilder);
        return new COSClient((COSCredentials)cred, clientConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putObject(String bucketName, File localFile, String key) {
        COSClient cosClient = this.getcosclient();
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setHeader("expires", (Object)new Date());
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
            putObjectRequest.withMetadata(objectMetadata);
            PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
            if (putObjectResult != null && StringUtils.nonEmpty((CharSequence)putObjectResult.getRequestId())) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            YuinLogUtils.getInst(this).error("\u4e0a\u4f20\u6587\u4ef6\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (cosClient != null) {
                cosClient.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getObject(String bucketName, String key, String filepath, boolean useTrafficLimit) {
        COSClient cosclient = this.getcosclient();
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
            if (useTrafficLimit) {
                getObjectRequest.setTrafficLimit(0x800000);
            }
            File localFile = new File(filepath);
            ObjectMetadata objectMetadata = cosclient.getObject(getObjectRequest, localFile);
            Long length = objectMetadata.getContentLength();
            cosclient.shutdown();
            Long l = length;
            return l;
        }
        catch (Exception e) {
            Long l = 0L;
            return l;
        }
        finally {
            if (cosclient != null) {
                cosclient.shutdown();
            }
        }
    }
}

