/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.payment.common.base.component.fieldmap.service;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.base.util.StringUtilEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StringMethodService {
    private static final Logger logger = LoggerFactory.getLogger(StringMethodService.class);
    private static final String DIR_LEFT = "LEFT";
    private static final String DIR_RIGHT = "RIGHT";
    private static final String DIR_BOTH = "BOTH";
    private static final String STRING_FILL = "fill";
    private static final String STRING_JOINT = "joint";
    private static final String STRING_DELETE = "delete";
    private static final String STRING_CUT = "cut";
    private static final String STRING_REPLACE = "replace";
    private static final String STRING_ESCAPE = "escape";
    private static final String STRING_SUBSTR = "substr";

    public YuinResult stringFormat(JavaDict request, String colinpara) {
        String result;
        String[] inpara = colinpara.split(",");
        String srcData = "#".equals(inpara[0].substring(0, 1)) ? inpara[0].substring(1) : request.getString(inpara[0]);
        String type = inpara[1];
        try {
            switch (type) {
                case "fill": {
                    result = this.fillWord(srcData, inpara);
                    break;
                }
                case "joint": {
                    result = this.fillWords(srcData, inpara);
                    break;
                }
                case "delete": {
                    result = this.deleteWord(srcData, inpara);
                    break;
                }
                case "cut": {
                    result = this.cutString(srcData, inpara);
                    break;
                }
                case "replace": {
                    result = this.replaceString(srcData, inpara);
                    break;
                }
                case "escape": {
                    result = this.translateChar(srcData, inpara);
                    break;
                }
                case "substr": {
                    result = this.selectSubString(srcData, inpara);
                    break;
                }
                default: {
                    return YuinResult.newFailureResult("S9002", "\u5b57\u7b26\u51fd\u6570\u7c7b\u578b\u9519\u8bef");
                }
            }
        }
        catch (Exception e) {
            return YuinResult.newFailureResult("S9002", e.getMessage());
        }
        return YuinResult.newSuccessResult(new Object[]{result});
    }

    public String fillWord(String srcData, String[] inpara) throws Exception {
        if (inpara.length < 5) {
            throw new Exception("\u586b\u5145\u5b57\u7b26\u51fd\u6570 @ \u5165\u53c2\u4e2a\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((CharSequence)inpara[2])) {
            logger.warn("\u586b\u5145\u5b57\u7b26\u51fd\u6570 @ \u6807\u8bc6\u7b26\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u586b\u5145");
            return srcData;
        }
        char signChar = inpara[2].charAt(0);
        String direction = StringUtils.isEmpty((CharSequence)inpara[3]) ? DIR_RIGHT : inpara[3];
        int targetLength = Integer.parseInt(inpara[4]);
        if (srcData.length() >= targetLength) {
            return srcData;
        }
        if (DIR_LEFT.equals(direction)) {
            return StringUtilEx.fill(srcData, signChar, targetLength, true);
        }
        if (DIR_RIGHT.equals(direction)) {
            return StringUtilEx.fill(srcData, signChar, targetLength, false);
        }
        logger.warn(String.format("\u586b\u5145\u5b57\u7b26\u51fd\u6570 @ \u4e0d\u652f\u6301\u3010%s\u3011\u586b\u5145\u65b9\u5411,\u4e0d\u505a\u586b\u5145", direction));
        return srcData;
    }

    public String fillWords(String srcData, String[] inpara) throws Exception {
        if (inpara.length < 4) {
            throw new Exception("\u62fc\u63a5\u5b57\u7b26\u4e32\u51fd\u6570 @ \u5165\u53c2\u4e2a\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((CharSequence)inpara[2])) {
            logger.warn("\u62fc\u63a5\u5b57\u7b26\u4e32\u51fd\u6570 @ \u6807\u8bc6\u7b26\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u586b\u5145");
            return srcData;
        }
        String signChar = inpara[2];
        String direction = StringUtils.isEmpty((CharSequence)inpara[3]) ? DIR_RIGHT : inpara[3];
        if (DIR_LEFT.equals(direction)) {
            return String.format("%s%s", signChar, srcData);
        }
        if (DIR_RIGHT.equals(direction)) {
            return String.format("%s%s", srcData, signChar);
        }
        logger.warn(String.format("\u62fc\u63a5\u5b57\u7b26\u4e32\u51fd\u6570 @ \u4e0d\u652f\u6301\u3010%s\u3011\u62fc\u63a5\u65b9\u5411,\u4e0d\u505a\u62fc\u63a5", direction));
        return srcData;
    }

    public String deleteWord(String srcData, String[] inpara) throws Exception {
        String result;
        int targetLength;
        if (inpara.length < 4 || inpara.length < 5 && !DIR_BOTH.equals(inpara[3])) {
            throw new Exception("\u5220\u9664\u5b57\u7b26\u51fd\u6570 @ \u5165\u53c2\u4e2a\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((CharSequence)inpara[2])) {
            logger.warn("\u5220\u9664\u5b57\u7b26\u51fd\u6570 @ \u6807\u8bc6\u7b26\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u586b\u5145");
            return srcData;
        }
        char signChar = inpara[2].charAt(0);
        String direction = StringUtils.isEmpty((CharSequence)inpara[3]) ? DIR_RIGHT : inpara[3];
        int n = targetLength = DIR_BOTH.equals(direction) ? 0 : Integer.parseInt(inpara[4]);
        if (DIR_LEFT.equals(direction)) {
            result = StringUtilEx.delete(srcData, signChar, targetLength, true);
        } else if (DIR_RIGHT.equals(direction)) {
            result = StringUtilEx.delete(srcData, signChar, targetLength, false);
        } else if (DIR_BOTH.equals(direction)) {
            String sSrc = StringUtilEx.delete(srcData, signChar, -1, true);
            result = StringUtilEx.delete(sSrc, signChar, -1, false);
        } else {
            logger.warn(String.format("\u5220\u9664\u5b57\u7b26\u51fd\u6570 @ \u4e0d\u652f\u6301\u3010%s\u3011\u586b\u5145\u65b9\u5411,\u4e0d\u505a\u586b\u5145", direction));
            return srcData;
        }
        return result;
    }

    public String cutString(String srcData, String[] inpara) throws Exception {
        String result;
        if (inpara.length < 4) {
            throw new Exception("\u5b57\u7b26\u4e32\u622a\u53d6\u51fd\u6570 @ \u5165\u53c2\u4e2a\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((CharSequence)inpara[2])) {
            logger.warn("\u5b57\u7b26\u4e32\u622a\u53d6\u51fd\u6570 @ \u6807\u8bc6\u7b26\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u586b\u5145");
            return srcData;
        }
        char signChar = inpara[2].charAt(0);
        String direction = StringUtils.isEmpty((CharSequence)inpara[3]) ? DIR_RIGHT : inpara[3];
        if (DIR_LEFT.equals(direction)) {
            result = StringUtilEx.cut(srcData, signChar, true);
        } else if (DIR_RIGHT.equals(direction)) {
            result = StringUtilEx.cut(srcData, signChar, false);
        } else {
            logger.warn(String.format("\u622a\u53d6\u5b57\u7b26\u51fd\u6570 @ \u4e0d\u652f\u6301\u3010%s\u3011\u586b\u5145\u65b9\u5411,\u4e0d\u505a\u586b\u5145", direction));
            return srcData;
        }
        return result;
    }

    public String replaceString(String srcData, String[] inpara) throws Exception {
        if (inpara.length < 5) {
            throw new Exception("\u5b57\u7b26\u4e32\u622a\u53d6\u51fd\u6570 @ \u5165\u53c2\u4e2a\u6570\u9519\u8bef");
        }
        int start = StringUtils.isEmpty((CharSequence)inpara[2]) ? 1 : Integer.parseInt(inpara[2]);
        int end = StringUtils.isEmpty((CharSequence)inpara[3]) ? 1 : Integer.parseInt(inpara[3]);
        String signString = inpara[4];
        if (StringUtils.isEmpty((CharSequence)signString)) {
            logger.warn("\u5b57\u7b26\u4e32\u66ff\u6362\u51fd\u6570 @ \u66ff\u6362\u5b57\u7b26\u4e32\u4e3a\u7a7a,\u4e0d\u505a\u66ff\u6362");
            return srcData;
        }
        return StringUtilEx.replaceString(srcData, start, end, signString);
    }

    public String translateChar(String srcData, String[] inpara) throws Exception {
        return StringUtilEx.translateChar(srcData);
    }

    public String selectSubString(String srcData, String[] inpara) throws Exception {
        if (inpara.length < 4) {
            throw new Exception("\u5b57\u7b26\u4e32\u622a\u53d6\u51fd\u6570 @ \u5165\u53c2\u4e2a\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((CharSequence)inpara[2]) || StringUtils.isEmpty((CharSequence)inpara[3])) {
            logger.warn("\u9009\u53d6\u5b50\u4e32\u51fd\u6570@ \u8d77\u59cb\u4f4d\u7f6e\u6216\u7ed3\u675f\u4f4d\u7f6e\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u9009\u53d6");
            return srcData;
        }
        int start = Integer.parseInt(inpara[2]);
        int end = Integer.parseInt(inpara[3]);
        int len = srcData.length();
        if (start < 1) {
            start = 1;
        }
        if (end > len || end < 1) {
            end = len;
        }
        if (start > end || start > srcData.length()) {
            logger.warn("\u9009\u53d6\u5b50\u4e32\u51fd\u6570 @ \u8d77\u59cb\u4f4d\u7f6e\u6216\u7ed3\u675f\u4f4d\u7f6e\u914d\u7f6e\u6709\u8bef,\u4e0d\u505a\u9009\u53d6");
            return srcData;
        }
        return srcData.substring(start - 1, end);
    }
}

