/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.ability.domain.service.func.util;

import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.util.Arrays;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class HostMac {
    private static final long serialVersionUID = 5021465048705319546L;
    static final String GENERATEMAC = "generateMac";
    static final String VERIFYMAC = "verifyMac";
    static final String PARA_ENCODING = "UTF-8";

    public String hostChk(String options, String macData, String mac) throws Exception {
        String result = null;
        if (GENERATEMAC.equals(options)) {
            byte[] srcData = macData.getBytes(PARA_ENCODING);
            result = HostMac.generateMac(srcData);
            LogUtils.printInfo((Object)this, (String)"\u751f\u6210MAC\u6210\u529f", (Object[])new Object[0]);
        } else if (VERIFYMAC.equals(options)) {
            result = "0";
            byte[] srcData = macData.getBytes(PARA_ENCODING);
            boolean isValid = HostMac.verifyMac(srcData, mac);
            if (isValid) {
                result = "1";
                LogUtils.printInfo((Object)this, (String)"\u6821\u9a8cMAC\u6210\u529f", (Object[])new Object[0]);
            }
        }
        return result;
    }

    public String MacFormat(String StrMsg, String StrFilterFields) {
        LogUtils.printInfo((Object)this, (String)"---------\u683c\u5f0f\u5316mac\u6570\u636e-----", (Object[])new Object[0]);
        String StrMacData = "";
        StrMsg = StrMsg.replace("\\", "C9B5B1C6D3C3B7B4D0B1B8DC!");
        JSONObject jsonObject2 = JSONObject.parseObject((String)StrMsg, (Feature[])new Feature[]{Feature.OrderedField});
        String[] StrFilterFieldsL = StrFilterFields.split(",");
        for (int i = 0; i < StrFilterFieldsL.length; ++i) {
            Object obj = jsonObject2.get((Object)StrFilterFieldsL[i]);
            if (null == obj) continue;
            String value = obj.toString();
            if (value.contains("C9B5B1C6D3C3B7B4D0B1B8DC!")) {
                value = value.replace("C9B5B1C6D3C3B7B4D0B1B8DC!", "\\");
            }
            StrMacData = StrMacData + "\"" + StrFilterFieldsL[i] + "\":" + value;
        }
        return StrMacData;
    }

    private static byte[] hash(byte[] srcData) {
        SM3Digest digest = new SM3Digest();
        digest.update(srcData, 0, srcData.length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return hash;
    }

    public static String generateMac(byte[] paramStr) {
        String resultHexString = "";
        byte[] resultHash = HostMac.hash(paramStr);
        resultHexString = ByteUtils.toHexString((byte[])resultHash);
        return resultHexString;
    }

    public static boolean verifyMac(byte[] srcStr, String sm3HexString) {
        boolean flag = false;
        byte[] sm3Hash = ByteUtils.fromHexString((String)sm3HexString);
        byte[] newHash = HostMac.hash(srcStr);
        if (Arrays.equals(newHash, sm3Hash)) {
            flag = true;
        }
        return flag;
    }
}

