/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.ability.domain.service.func;

import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.pay.common.ability.domain.constant.EComOutType;
import cn.com.yusys.yusp.pay.common.ability.domain.repo.data.CheckRepo;
import cn.com.yusys.yusp.pay.common.ability.domain.repo.data.ExchangeRepo;
import cn.com.yusys.yusp.pay.common.ability.domain.repo.data.ReqPackRepo;
import cn.com.yusys.yusp.pay.common.ability.domain.repo.data.RespUnpackRepo;
import cn.com.yusys.yusp.pay.common.ability.domain.repo.data.SaveRepo;
import cn.com.yusys.yusp.pay.common.ability.domain.repo.data.UpPOuttrademapRepo;
import cn.com.yusys.yusp.pay.common.ability.domain.vo.UpPOuttrademapVo;
import cn.com.yusys.yusp.pay.common.base.dto.ReqCommInfo;
import cn.com.yusys.yusp.pay.common.base.dto.RspCommInfo;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import cn.hutool.core.util.XmlUtil;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public abstract class ChannelOutService {
    @Autowired
    public ApplicationContext applicationContext;
    @Autowired
    public UpPOuttrademapRepo uiPOuttrademapRepo;
    @Autowired
    private SaveRepo saveRepo;
    @Autowired
    private ReqPackRepo reqPackRepo;
    @Autowired
    private CheckRepo checkRepo;
    @Autowired
    private RespUnpackRepo respUnpackRepo;
    @Autowired
    private ExchangeRepo exchangeRepo;

    public RspCommInfo outExchange(ReqCommInfo hostReqCommInfo, UpPOuttrademapVo uiPOuttrademapVo) throws Exception {
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        LogUtils.printInfo((Object)this, (String)(EComOutType.MODULE_NAME.getCode() + EComOutType.START.getName()), (Object[])new Object[0]);
        LocalDateTime startTime = LocalDateTime.now();
        String savetime = startTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        RspCommInfo rspCommInfo = new RspCommInfo();
        rspCommInfo.setErrcode("E8101");
        YuinResult result = null;
        String servicecode = hostReqCommInfo.getHostcommid();
        if (EComOutType.DISABLED_CODE.getCode().equals(uiPOuttrademapVo.getDisabled()) || EComOutType.STATUS.getCode().equals(uiPOuttrademapVo.getSvcstatus())) {
            rspCommInfo.setErrmsg(EComOutType.ERR_OUT_DISABLED.getName() + servicecode);
            return rspCommInfo;
        }
        int comtimeout = 60000;
        if (uiPOuttrademapVo.getComtimeout() != 0) {
            comtimeout = uiPOuttrademapVo.getComtimeout();
        }
        reqMap.put(EComOutType.TIME_OUT.getCode(), comtimeout);
        reqMap.put("send", JSONObject.toJSONString((Object)hostReqCommInfo.getSender()));
        reqMap.put("tradeDataMap", hostReqCommInfo.getSender());
        String rtncodekey = null;
        try {
            Map transaction;
            String xml = null;
            Map message = hostReqCommInfo.getSender();
            if ("CHL".equals(uiPOuttrademapVo.getReqsysid().substring(0, 3))) {
                transaction = (Map)message.get("root");
                rtncodekey = "pub.retcode";
                xml = XmlUtil.mapToXmlStr((Map)transaction, (String)"root");
            } else if ("ESB".equals(uiPOuttrademapVo.getReqsysid().substring(0, 3))) {
                transaction = (Map)message.get("transaction");
                rtncodekey = "transaction.header.status.retCd";
                xml = XmlUtil.mapToXmlStr((Map)transaction, (String)"transaction");
            } else {
                LogUtils.printError((Object)this, (String)"\u65e0\u6b64\u6e20\u9053\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
            }
            LogUtils.printInfo((Object)this, (String)("\u62fc\u5305\u8f6cxml:" + xml), (Object[])new Object[0]);
            result = this.exchangeRepo.exchangeOutAdapter(reqMap, uiPOuttrademapVo);
        }
        catch (Exception e) {
            result = YuinResult.newFailureResult((String)"E8199", (String)EComOutType.ERR_OUT.getName());
            rspCommInfo.setErrcode("E8199");
            rspCommInfo.setErrmsg(EComOutType.ERR_OUT.getName());
        }
        if (!result.success()) {
            rspCommInfo.setErrmsg(result.getErrorMsg());
            return rspCommInfo;
        }
        if (result.success()) {
            Map resultData = (Map)result.getOutputParams().get(0);
            JavaDict javaDict = new JavaDict();
            javaDict.setMap(resultData);
            if (result.success()) {
                String rtncode = javaDict.getString(rtncodekey, "");
                if (rtncode.equals("0000000")) {
                    javaDict.set(rtncodekey, (Object)"000000");
                }
                if (EComOutType.ERR_ESB_OUT.getCode().equals(rtncode) || EComOutType.ERR_ESB_100001.getCode().equals(rtncode) || EComOutType.ERR_ESB_SW09997.getCode().equals(rtncode) || EComOutType.ERR_ESB_300003.getCode().equals(rtncode) || EComOutType.ERR_ESB_SW09990.getCode().equals(rtncode) || EComOutType.ERR_ESB_SW09996.getCode().equals(rtncode) || EComOutType.ERR_ESB_SW09995.getCode().equals(rtncode)) {
                    rspCommInfo.setRecv(resultData);
                    rspCommInfo.setErrcode("E8103");
                    rspCommInfo.setErrmsg(EComOutType.ERR_OUT_TIME.getName());
                } else {
                    rspCommInfo.setRecv(resultData);
                    rspCommInfo.setErrcode(EComOutType.SUCCESS_CODE.getCode());
                    rspCommInfo.setErrmsg(EComOutType.SUCCESS_CODE.getName());
                }
            } else {
                rspCommInfo.setErrcode("E8102");
                rspCommInfo.setErrmsg(EComOutType.ERR_PACK.getName());
            }
        } else {
            rspCommInfo.setErrcode(result.getErrorCode());
            rspCommInfo.setErrmsg(result.getErrorMsg());
        }
        LogUtils.printInfo((Object)this, (String)(EComOutType.MODULE_NAME.getCode() + EComOutType.END.getName()), (Object[])new Object[0]);
        return rspCommInfo;
    }

    private void setBspSession(Map<String, Object> attributes, String moduleCode) {
        Session session = (Session)attributes.get(EComOutType.T_SESSION.getCode());
        String startWithCommOut = EComOutType.COMM_OUT.getCode() + moduleCode;
        if (session == null) {
            session = new Session();
            session.setModuleName(startWithCommOut);
            session.setContext(attributes);
            session.getContext().put(EComOutType.T_SESSION.getCode(), session);
        }
    }
}

