/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.ability.domain.repo.data;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.pay.common.ability.domain.code.ECommType;
import cn.com.yusys.yusp.pay.common.ability.domain.config.GrayConfig;
import cn.com.yusys.yusp.pay.common.ability.domain.constant.HostErrorCode;
import cn.com.yusys.yusp.pay.common.ability.domain.repo.data.UpPCominfoRepo;
import cn.com.yusys.yusp.pay.common.ability.domain.vo.data.UpPCominfoQueryVo;
import cn.com.yusys.yusp.pay.common.base.dto.ReqCommInfo;
import cn.com.yusys.yusp.pay.common.base.dto.RspCommInfo;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.math.RandomUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class UpPCommServiceRepo {
    @Resource
    private UpPCominfoRepo upPCominfoRepo;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private GrayConfig grayConfig;

    public RspCommInfo execCommon(ReqCommInfo reqCommInfo) {
        return this.execCommon(reqCommInfo, null);
    }

    public RspCommInfo execCommon(ReqCommInfo reqCommInfo, String serverName) {
        String sysid = reqCommInfo.getSysid();
        String appid = reqCommInfo.getAppid();
        String commid = reqCommInfo.getHostcommid();
        LogUtils.printInfo((Object)this, (String)("sysid:" + sysid), (Object[])new Object[0]);
        LogUtils.printInfo((Object)this, (String)("appid:" + appid), (Object[])new Object[0]);
        LogUtils.printInfo((Object)this, (String)("commid:" + commid), (Object[])new Object[0]);
        Map sender = reqCommInfo.getSender();
        RspCommInfo rspCommInfo = new RspCommInfo();
        HashMap info = new HashMap();
        UpPCominfoQueryVo upPCominfoQueryVo = this.getComminfo(sysid, appid, commid);
        if (upPCominfoQueryVo == null) {
            rspCommInfo.setErrcode("E8401");
            rspCommInfo.setErrmsg(HostErrorCode.getErrmsgAdd((String)"E8401", (String)("\u83b7\u53d6\u901a\u8baf\u914d\u7f6e\u5f02\u5e38:" + reqCommInfo.toString())));
            return rspCommInfo;
        }
        Object result = null;
        try {
            String comtype = upPCominfoQueryVo.getComtype();
            if (!ECommType.HOSTTYPE_MQ.getCode().equals(comtype)) {
                String url = "";
                String server = upPCominfoQueryVo.getComip();
                if (this.grayConfig.getGrayFlag().booleanValue()) {
                    server = "gray-" + server;
                }
                url = ECommType.HOSTTYPE_RESTFUL.getCode().equals(comtype) ? (StringUtils.isBlank((CharSequence)serverName) ? "http://" + server + "/api/" + upPCominfoQueryVo.getComip() : "http://" + server + "/api/" + serverName) : "http://" + server + ":" + upPCominfoQueryVo.getComport();
                return this.execCommon(url, reqCommInfo);
            }
            rspCommInfo.setErrcode(result.getErrorCode());
            rspCommInfo.setErrmsg(result.getErrorMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.printError((Object)this, (String)"\u901a\u8baf\u5f02\u5e38: {}", (Object[])new Object[]{e.getMessage()});
            rspCommInfo.setErrcode("E8499");
            rspCommInfo.setErrmsg(HostErrorCode.getErrmsgAdd((String)"E8499", (String)e.getMessage()));
        }
        return rspCommInfo;
    }

    public RspCommInfo execCommon(String url, ReqCommInfo reqCommInfo) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)reqCommInfo, (MultiValueMap)httpHeaders);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, RspCommInfo.class, new Object[0]);
        return (RspCommInfo)responseEntity.getBody();
    }

    public UpPCominfoQueryVo getComminfo(String sysid, String appid, String commid) {
        UpPCominfoQueryVo upPCominfoQueryVo = new UpPCominfoQueryVo();
        upPCominfoQueryVo.setAppid(appid);
        upPCominfoQueryVo.setSysid(sysid);
        upPCominfoQueryVo.setComid(commid);
        upPCominfoQueryVo.setEffectflag("1");
        upPCominfoQueryVo.setStatus("1");
        List<UpPCominfoQueryVo> cominfolist = this.upPCominfoRepo.listData(upPCominfoQueryVo);
        if (cominfolist == null || cominfolist.size() == 0) {
            UpPCominfoQueryVo upPCominfoQueryVoDef = new UpPCominfoQueryVo();
            upPCominfoQueryVoDef.setAppid(appid);
            upPCominfoQueryVoDef.setSysid(sysid);
            upPCominfoQueryVoDef.setComid(commid);
            upPCominfoQueryVoDef.setDefaultflag("1");
            cominfolist = this.upPCominfoRepo.listDefaultData(upPCominfoQueryVoDef);
            if (cominfolist == null || cominfolist.size() == 0) {
                LogUtils.printError((Object)this, (String)"\u83b7\u53d6\u901a\u8baf\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38", (Object[])new Object[0]);
                return null;
            }
        }
        ArrayList last = new ArrayList();
        cominfolist.forEach(upPCominfoQueryVoRes -> {
            String strsysid = upPCominfoQueryVoRes.getSysid();
            String strappid = upPCominfoQueryVoRes.getAppid();
            int flag = 0;
            if (!"PUB".equals(strsysid) && !"PUB".equals(strappid)) {
                if (flag > 1 && last.size() > 0) {
                    last.clear();
                }
                last.add(upPCominfoQueryVoRes);
                flag = 1;
            } else if (!"PUB".equals(strsysid) && "PUB".equals(strappid)) {
                if (flag > 2 && last.size() > 0) {
                    last.clear();
                }
                last.add(upPCominfoQueryVoRes);
                flag = 2;
            } else {
                if (flag > 3 && last.size() > 0) {
                    last.clear();
                }
                last.add(upPCominfoQueryVoRes);
                flag = 3;
            }
        });
        if (last.size() > 0) {
            if (last.size() == 1) {
                return (UpPCominfoQueryVo)((Object)last.get(0));
            }
            return (UpPCominfoQueryVo)((Object)last.get(RandomUtils.nextInt((int)last.size())));
        }
        return null;
    }
}

